/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.cloud.impl.manager;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.aludratest.cloud.app.CloudManagerApp;
import org.aludratest.cloud.impl.manager.DefaultResourceManagerImplMBean;
import org.aludratest.cloud.impl.manager.ResourceInfo;
import org.aludratest.cloud.manager.ManagedResourceQuery;
import org.aludratest.cloud.manager.ResourceManager;
import org.aludratest.cloud.manager.ResourceManagerListener;
import org.aludratest.cloud.module.ResourceModule;
import org.aludratest.cloud.request.ResourceRequest;
import org.aludratest.cloud.resource.Resource;
import org.aludratest.cloud.resource.ResourceCollectionListener;
import org.aludratest.cloud.resource.ResourceListener;
import org.aludratest.cloud.resource.ResourceState;
import org.aludratest.cloud.resource.ResourceStateHolder;
import org.aludratest.cloud.resource.ResourceType;
import org.aludratest.cloud.resource.user.ResourceTypeAuthorization;
import org.aludratest.cloud.resource.user.ResourceTypeAuthorizationConfig;
import org.aludratest.cloud.resourcegroup.AuthorizingResourceGroup;
import org.aludratest.cloud.resourcegroup.ResourceGroup;
import org.aludratest.cloud.resourcegroup.ResourceGroupManager;
import org.aludratest.cloud.resourcegroup.ResourceGroupManagerListener;
import org.aludratest.cloud.user.StoreException;
import org.aludratest.cloud.user.User;
import org.codehaus.plexus.component.annotations.Component;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=ResourceManager.class)
public class DefaultResourceManagerImpl
implements ResourceManager,
ResourceCollectionListener,
ResourceGroupManagerListener,
ResourceListener,
DefaultResourceManagerImplMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultResourceManagerImpl.class);
    private ResourceGroupManager groupManager;
    private List<WaitingResourceRequest> queue = new LinkedList<WaitingResourceRequest>();
    private Set<WaitingResourceRequest> runningJobs = new HashSet<WaitingResourceRequest>();
    private Map<ResourceType, Set<Resource>> idleResources = new HashMap<ResourceType, Set<Resource>>();
    private List<ResourceManagerListener> listeners = new ArrayList<ResourceManagerListener>();
    private ExecutorService queueWorkerService;
    private RequestQueueWorker queueWorker;
    private AtomicInteger nextResourceId = new AtomicInteger();
    private Map<Resource, Integer> resourceIds = new ConcurrentHashMap<Resource, Integer>();

    public void start(ResourceGroupManager resourceGroupManager) {
        if (this.queueWorkerService != null) {
            throw new IllegalStateException("This resource manager has already been started");
        }
        this.queueWorker = new RequestQueueWorker();
        this.queueWorkerService = Executors.newFixedThreadPool(1);
        this.queueWorkerService.execute(this.queueWorker);
        this.groupManager = resourceGroupManager;
        this.groupManager.addResourceGroupManagerListener((ResourceGroupManagerListener)this);
        for (int id : this.groupManager.getAllResourceGroupIds()) {
            ResourceGroup group = this.groupManager.getResourceGroup(id);
            this.resourceGroupAdded(group);
        }
    }

    public synchronized void addResourceManagerListener(ResourceManagerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removeResourceManagerListener(ResourceManagerListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResourceRequest(ResourceRequest request) {
        WaitingResourceRequest waitingRequest = new WaitingResourceRequest(request);
        this.fireRequestEnqueued(waitingRequest);
        RequestQueueWorker requestQueueWorker = this.queueWorker;
        synchronized (requestQueueWorker) {
            this.queue.add(waitingRequest);
            this.queueWorker.handleNewRequest(waitingRequest);
        }
    }

    public void shutdown() {
        if (this.queueWorkerService != null) {
            this.queueWorkerService.shutdownNow();
            this.queueWorkerService = null;
        }
        this.queue.clear();
        this.runningJobs.clear();
        this.queueWorker = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotalQueueSize() {
        RequestQueueWorker requestQueueWorker = this.queueWorker;
        synchronized (requestQueueWorker) {
            return this.queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends ManagedResourceQuery> getAllRunningQueries() {
        ArrayList<WaitingResourceRequest> result;
        RequestQueueWorker requestQueueWorker = this.queueWorker;
        synchronized (requestQueueWorker) {
            result = new ArrayList<WaitingResourceRequest>(this.runningJobs);
        }
        return result;
    }

    public void resourceAdded(Resource resource) {
        resource.addResourceListener((ResourceListener)this);
        if (resource.getState() == ResourceState.READY) {
            this.putIntoIdle(resource);
            this.queueWorker.handleResourceAvailable(resource);
        }
    }

    private void registerResourceMBean(Resource resource) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            int id = this.nextResourceId.incrementAndGet();
            ObjectName name = new ObjectName("org.aludratest.cloud:00=resources,01=" + resource.getResourceType().getName() + ",name=" + id);
            ResourceInfo info = ResourceInfo.create(resource);
            mbs.registerMBean(info, name);
            this.resourceIds.put(resource, id);
        }
        catch (JMException e) {
            LOGGER.warn("Could not register resource in MBean server", (Throwable)e);
        }
    }

    private synchronized void putIntoIdle(Resource resource) {
        Set<Resource> idles = this.idleResources.get(resource.getResourceType());
        if (idles == null) {
            idles = new HashSet<Resource>();
            this.idleResources.put(resource.getResourceType(), idles);
        }
        idles.add(resource);
    }

    private synchronized boolean isInIdle(Resource resource) {
        Set<Resource> idles = this.idleResources.get(resource.getResourceType());
        if (idles != null) {
            return idles.contains(resource);
        }
        return false;
    }

    private synchronized void removeFromIdle(Resource resource) {
        Set<Resource> idles = this.idleResources.get(resource.getResourceType());
        if (idles != null) {
            idles.remove(resource);
        }
    }

    public void resourceRemoved(Resource resource) {
        resource.removeResourceListener((ResourceListener)this);
        Integer id = this.resourceIds.remove(resource);
        if (id != null) {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            try {
                Set<ObjectInstance> instances = mbs.queryMBeans(new ObjectName("org.aludratest.cloud:00=resources,01=" + resource.getResourceType().getName() + ",name=" + id), null);
                if (!instances.isEmpty()) {
                    mbs.unregisterMBean(instances.iterator().next().getObjectName());
                }
            }
            catch (JMException e) {
                LOGGER.warn("Could not unregister resource from MBean server", (Throwable)e);
            }
        }
    }

    public void resourceGroupAdded(ResourceGroup group) {
        group.getResourceCollection().addResourceCollectionListener((ResourceCollectionListener)this);
        for (ResourceStateHolder rsh : group.getResourceCollection()) {
            Resource res = (Resource)rsh;
            res.addResourceListener((ResourceListener)this);
            if (rsh.getState() == ResourceState.READY) {
                this.resourceAdded(res);
            }
            this.registerResourceMBean(res);
        }
    }

    public void resourceGroupRemoved(ResourceGroup group) {
        group.getResourceCollection().removeResourceCollectionListener((ResourceCollectionListener)this);
        for (ResourceStateHolder rsh : group.getResourceCollection()) {
            this.resourceRemoved((Resource)rsh);
        }
    }

    public void resourceStateChanged(Resource resource, ResourceState previousState, ResourceState newState) {
        if (previousState != newState) {
            switch (previousState) {
                case IN_USE: {
                    this.checkReleasedResource(resource);
                    break;
                }
                case READY: {
                    this.removeFromIdle(resource);
                    break;
                }
            }
            switch (newState) {
                case READY: {
                    this.putIntoIdle(resource);
                    this.queueWorker.handleResourceAvailable(resource);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRequestEnqueued(ManagedResourceQuery request) {
        ArrayList<ResourceManagerListener> ls;
        DefaultResourceManagerImpl defaultResourceManagerImpl = this;
        synchronized (defaultResourceManagerImpl) {
            ls = new ArrayList<ResourceManagerListener>(this.listeners);
        }
        for (ResourceManagerListener l : ls) {
            l.requestEnqueued(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireResourceReleased(ManagedResourceQuery request, Resource releasedResource) {
        ArrayList<ResourceManagerListener> ls;
        DefaultResourceManagerImpl defaultResourceManagerImpl = this;
        synchronized (defaultResourceManagerImpl) {
            ls = new ArrayList<ResourceManagerListener>(this.listeners);
        }
        for (ResourceManagerListener l : ls) {
            l.resourceReleased(request, releasedResource);
        }
    }

    private void fireError(ManagedResourceQuery request, String errorMessage) {
        this.fireError(request, errorMessage, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireError(ManagedResourceQuery request, String errorMessage, Throwable cause) {
        ArrayList<ResourceManagerListener> ls;
        DefaultResourceManagerImpl defaultResourceManagerImpl = this;
        synchronized (defaultResourceManagerImpl) {
            ls = new ArrayList<ResourceManagerListener>(this.listeners);
        }
        for (ResourceManagerListener l : ls) {
            l.requestError(request, errorMessage, cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fireResourceReceived(ManagedResourceQuery request, Resource resource) {
        ArrayList<ResourceManagerListener> ls;
        DefaultResourceManagerImpl defaultResourceManagerImpl = this;
        synchronized (defaultResourceManagerImpl) {
            ls = new ArrayList<ResourceManagerListener>(this.listeners);
        }
        for (ResourceManagerListener l : ls) {
            if (!l.resourceAvailable(request, resource)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReleasedResource(Resource resource) {
        WaitingResourceRequest request = null;
        RequestQueueWorker requestQueueWorker = this.queueWorker;
        synchronized (requestQueueWorker) {
            for (WaitingResourceRequest r : this.runningJobs) {
                if (!resource.equals(r.getReceivedResource())) continue;
                request = r;
                break;
            }
        }
        if (request != null) {
            LOGGER.debug("Request " + request + " has released resource " + resource);
            requestQueueWorker = this.queueWorker;
            synchronized (requestQueueWorker) {
                this.runningJobs.remove(request);
            }
            request.resourceReleasedTime = DateTime.now();
            this.fireResourceReleased(request, resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIdleResourceCount() {
        int result = 0;
        DefaultResourceManagerImpl defaultResourceManagerImpl = this;
        synchronized (defaultResourceManagerImpl) {
            for (Set<Resource> rs : this.idleResources.values()) {
                result += rs.size();
            }
        }
        return result;
    }

    @Override
    public int getRunningQueriesCount() {
        return this.getAllRunningQueries().size();
    }

    private class WaitingRequestComparator
    implements Comparator<WaitingResourceRequest> {
        private ResourceTypeAuthorizationConfig authConfig;
        private int totalResourceCount;
        private Map<User, Integer> userJobCount;
        private static final int NORMALIZE_DIFF = 20;

        public WaitingRequestComparator(ResourceTypeAuthorizationConfig authConfig, Map<User, Integer> userJobCount, int totalResourceCount) {
            this.authConfig = authConfig;
            this.userJobCount = userJobCount;
            this.totalResourceCount = totalResourceCount;
        }

        @Override
        public int compare(WaitingResourceRequest req1, WaitingResourceRequest req2) {
            User u1 = req1.getRequest().getRequestingUser();
            User u2 = req2.getRequest().getRequestingUser();
            ResourceTypeAuthorization auth1 = this.authConfig.getResourceTypeAuthorizationForUser(u1);
            ResourceTypeAuthorization auth2 = this.authConfig.getResourceTypeAuthorizationForUser(u2);
            return this.calculateRequestScore(req1, auth1) - this.calculateRequestScore(req2, auth2);
        }

        private int calculateRequestScore(WaitingResourceRequest request, ResourceTypeAuthorization auth) {
            DateTime now = DateTime.now();
            int normalizedNiceLevel = auth.getNiceLevel() - 20;
            double userMax = Math.min(auth.getMaxResources(), this.totalResourceCount);
            if (userMax == 0.0) {
                return 0;
            }
            double userRunCount = this.userJobCount.get(request.getRequest().getRequestingUser()).intValue();
            normalizedNiceLevel -= (int)(userRunCount / userMax * (double)normalizedNiceLevel);
            long millisWaiting = new Duration((ReadableInstant)request.getEnqueueStartTime(), (ReadableInstant)now).getMillis();
            if (millisWaiting == 0L) {
                millisWaiting = 1L;
            }
            return (int)(millisWaiting * (long)normalizedNiceLevel);
        }
    }

    private static class WaitingResourceRequest
    implements ManagedResourceQuery {
        private ResourceRequest request;
        private DateTime enqueueStartTime;
        private DateTime resourceReceivedTime;
        private DateTime resourceReleasedTime;
        private Resource receivedResource;

        public WaitingResourceRequest(ResourceRequest request) {
            if (request == null) {
                throw new IllegalArgumentException("request is null");
            }
            this.request = request;
            this.enqueueStartTime = new DateTime();
        }

        public ResourceRequest getRequest() {
            return this.request;
        }

        public DateTime getEnqueueStartTime() {
            return this.enqueueStartTime;
        }

        public DateTime getResourceReceivedTime() {
            return this.resourceReceivedTime;
        }

        public DateTime getResourceReleasedTime() {
            return this.resourceReleasedTime;
        }

        public Resource getReceivedResource() {
            return this.receivedResource;
        }

        public int hashCode() {
            if (this.receivedResource != null) {
                return this.receivedResource.hashCode();
            }
            return this.request.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            WaitingResourceRequest req = (WaitingResourceRequest)obj;
            return req.request.equals(this.request);
        }

        public String toString() {
            return this.request.toString();
        }
    }

    private class RequestQueueWorker
    implements Runnable {
        private List<Object> events = new ArrayList<Object>();

        private RequestQueueWorker() {
        }

        public synchronized void handleNewRequest(WaitingResourceRequest request) {
            this.events.add(request);
            this.notify();
        }

        public synchronized void handleResourceAvailable(Resource resource) {
            this.events.add(resource);
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.interrupted()) {
                Resource res;
                Object nextEvent;
                RequestQueueWorker requestQueueWorker = this;
                synchronized (requestQueueWorker) {
                    while (this.events.isEmpty()) {
                        try {
                            this.wait(5000L);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                    nextEvent = this.events.remove(0);
                }
                if (nextEvent instanceof WaitingResourceRequest) {
                    this.checkResourceForRequest((WaitingResourceRequest)nextEvent);
                    continue;
                }
                if (!(nextEvent instanceof Resource) || (res = (Resource)nextEvent).getState() != ResourceState.READY || !DefaultResourceManagerImpl.this.isInIdle(res) || this.checkRequestForResource(res)) continue;
                DefaultResourceManagerImpl.this.putIntoIdle(res);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkResourceForRequest(WaitingResourceRequest request) {
            HashSet idles;
            ResourceTypeAuthorizationConfig authStore;
            Object group;
            LOGGER.debug("Checking resource for request " + request);
            ResourceType resourceType = request.getRequest().getResourceType();
            ResourceModule module = CloudManagerApp.getInstance().getResourceModule(resourceType);
            if (module == null) {
                DefaultResourceManagerImpl.this.fireError(request, "No resources of type " + resourceType + " available in this manager.");
                return;
            }
            User user = request.getRequest().getRequestingUser();
            boolean groupFound = false;
            for (int groupId : DefaultResourceManagerImpl.this.groupManager.getAllResourceGroupIds()) {
                group = DefaultResourceManagerImpl.this.groupManager.getResourceGroup(groupId);
                if (!resourceType.equals(group.getResourceType()) || group.getResourceCollection().getResourceCount() <= 0) continue;
                if (group instanceof AuthorizingResourceGroup) {
                    AuthorizingResourceGroup authGroup = (AuthorizingResourceGroup)group;
                    if (authGroup.isLimitingUsers() && !authGroup.isUserAuthorized(user)) continue;
                    groupFound = true;
                    break;
                }
                groupFound = true;
                break;
            }
            if (!groupFound) {
                DefaultResourceManagerImpl.this.fireError(request, "No resources of type " + resourceType + " for requesting user available in this manager.");
                return;
            }
            try {
                authStore = CloudManagerApp.getInstance().getResourceTypeAuthorizationStore().loadResourceTypeAuthorizations(resourceType);
            }
            catch (StoreException e) {
                LOGGER.error("Could not load resource type authorization for resource type " + resourceType, (Throwable)e);
                return;
            }
            ResourceTypeAuthorization auth = authStore.getResourceTypeAuthorizationForUser(user);
            if (auth == null || auth.getMaxResources() < 1) {
                DefaultResourceManagerImpl.this.fireError(request, "User does not have access to resource type " + resourceType);
                return;
            }
            Map<User, Integer> applicableUsers = this.getApplicableUsersMap(resourceType, authStore);
            if (!applicableUsers.containsKey(user)) {
                LOGGER.debug("Request " + request + " left in queue as user already uses max no of resources");
                return;
            }
            LOGGER.debug("User " + user.getName() + " uses " + applicableUsers.get(user) + " of max " + authStore.getResourceTypeAuthorizationForUser(user).getMaxResources() + " resources");
            group = this;
            synchronized (group) {
                idles = (HashSet)DefaultResourceManagerImpl.this.idleResources.get(resourceType);
                if (idles == null || idles.isEmpty()) {
                    LOGGER.debug("No resources available for request " + request + ", leaving request in queue (queue size: " + DefaultResourceManagerImpl.this.queue.size() + ")");
                    return;
                }
                idles = new HashSet(idles);
            }
            ArrayList availables = module.getAvailableResources(request.getRequest(), idles);
            if (availables.isEmpty()) {
                LOGGER.debug("No resources available yet for incoming request, enqueueing request.");
                return;
            }
            RequestQueueWorker requestQueueWorker = this;
            synchronized (requestQueueWorker) {
                availables = new ArrayList(availables);
                availables.retainAll(idles);
                if (availables.isEmpty()) {
                    return;
                }
                this.checkRequestForResource((Resource)availables.get(0), module);
            }
        }

        private boolean checkRequestForResource(Resource resource) {
            ResourceModule module = CloudManagerApp.getInstance().getResourceModule(resource.getResourceType());
            if (module == null) {
                return false;
            }
            for (int groupId : DefaultResourceManagerImpl.this.groupManager.getAllResourceGroupIds()) {
                ResourceGroup group = DefaultResourceManagerImpl.this.groupManager.getResourceGroup(groupId);
                if (group == null || !group.getResourceType().equals(module.getResourceType())) continue;
                LOGGER.debug("Checking if there is a waiting request for resource " + resource + "...");
                return this.checkRequestForResource(resource, module);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<User, Integer> getApplicableUsersMap(ResourceType resourceType, ResourceTypeAuthorizationConfig authStore) {
            HashMap<User, Integer> applicableUsers = new HashMap<User, Integer>();
            for (Object user : authStore.getConfiguredUsers()) {
                applicableUsers.put((User)user, 0);
            }
            RequestQueueWorker requestQueueWorker = this;
            synchronized (requestQueueWorker) {
                for (WaitingResourceRequest request : DefaultResourceManagerImpl.this.runningJobs) {
                    if (!request.getRequest().getResourceType().equals(resourceType)) continue;
                    User u = request.getRequest().getRequestingUser();
                    Integer i = (Integer)applicableUsers.get(u);
                    if (i == null) {
                        i = 0;
                    }
                    applicableUsers.put(u, i + 1);
                }
            }
            Iterator mapIter = applicableUsers.entrySet().iterator();
            while (mapIter.hasNext()) {
                Map.Entry entry = mapIter.next();
                ResourceTypeAuthorization auth = authStore.getResourceTypeAuthorizationForUser((User)entry.getKey());
                if (auth != null && auth.getMaxResources() > (Integer)entry.getValue()) continue;
                mapIter.remove();
            }
            return applicableUsers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkRequestForResource(Resource resource, ResourceModule module) {
            ResourceTypeAuthorizationConfig authStore;
            ArrayList<WaitingResourceRequest> matchingRequests = new ArrayList<WaitingResourceRequest>();
            RequestQueueWorker requestQueueWorker = this;
            synchronized (requestQueueWorker) {
                for (WaitingResourceRequest request : DefaultResourceManagerImpl.this.queue) {
                    if (!request.getRequest().getResourceType().equals(resource.getResourceType())) continue;
                    matchingRequests.add(request);
                }
            }
            if (matchingRequests.isEmpty()) {
                LOGGER.debug("No matching requests found for resource " + resource + " (queue size: " + DefaultResourceManagerImpl.this.queue.size() + ")");
                return false;
            }
            try {
                authStore = CloudManagerApp.getInstance().getResourceTypeAuthorizationStore().loadResourceTypeAuthorizations(resource.getResourceType());
            }
            catch (StoreException e) {
                LOGGER.error("Could not load resource type authorization for resource type " + resource.getResourceType(), (Throwable)e);
                return true;
            }
            Map<User, Integer> applicableUsers = this.getApplicableUsersMap(resource.getResourceType(), authStore);
            Iterator iter = matchingRequests.iterator();
            while (iter.hasNext()) {
                WaitingResourceRequest request = (WaitingResourceRequest)iter.next();
                if (!applicableUsers.containsKey(request.getRequest().getRequestingUser())) {
                    iter.remove();
                    continue;
                }
                Object ls = module.getAvailableResources(request.getRequest(), Collections.singleton(resource));
                if (!ls.isEmpty()) continue;
                iter.remove();
            }
            if (!matchingRequests.isEmpty()) {
                int resCnt = 0;
                for (int groupId : DefaultResourceManagerImpl.this.groupManager.getAllResourceGroupIds()) {
                    ResourceGroup group = DefaultResourceManagerImpl.this.groupManager.getResourceGroup(groupId);
                    if (group == null) continue;
                    resCnt += group.getResourceCollection().getResourceCount();
                }
                WaitingRequestComparator comp = new WaitingRequestComparator(authStore, applicableUsers, resCnt);
                Collections.sort(matchingRequests, comp);
                RequestQueueWorker requestQueueWorker2 = this;
                synchronized (requestQueueWorker2) {
                    matchingRequests.retainAll(DefaultResourceManagerImpl.this.queue);
                }
                for (WaitingResourceRequest request : matchingRequests) {
                    Object object = this;
                    synchronized (object) {
                        DefaultResourceManagerImpl.this.queue.remove(request);
                    }
                    request.receivedResource = resource;
                    request.resourceReceivedTime = DateTime.now();
                    if (DefaultResourceManagerImpl.this.fireResourceReceived(request, resource)) {
                        LOGGER.debug("Resource " + resource + " assigned successfully to request " + request + ", removing from idle cache");
                        DefaultResourceManagerImpl.this.removeFromIdle(resource);
                        object = DefaultResourceManagerImpl.this;
                        synchronized (object) {
                            DefaultResourceManagerImpl.this.runningJobs.add(request);
                        }
                        return true;
                    }
                    LOGGER.debug("Request " + request + " did not want to consume resource " + resource + ", releasing resource.");
                    request.resourceReleasedTime = DateTime.now();
                    DefaultResourceManagerImpl.this.fireResourceReleased(request, resource);
                }
                return true;
            }
            LOGGER.debug("No matching waiting requests found for resource " + resource);
            return false;
        }
    }
}

