/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.cloud.impl.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aludratest.cloud.config.AbstractPreferences;
import org.aludratest.cloud.config.ConfigException;
import org.aludratest.cloud.config.ConfigUtil;
import org.aludratest.cloud.config.MainPreferences;
import org.aludratest.cloud.config.MutablePreferences;
import org.aludratest.cloud.config.Preferences;
import org.aludratest.cloud.config.PreferencesListener;
import org.aludratest.cloud.config.SimplePreferences;

public class MainPreferencesImpl
extends AbstractPreferences
implements MainPreferences {
    private List<PreferencesListener> listeners = new ArrayList<PreferencesListener>();
    private Map<String, String> values = new HashMap<String, String>();
    private Map<String, MainPreferencesImpl> children = new HashMap<String, MainPreferencesImpl>();
    private boolean virtual;

    public MainPreferencesImpl(MainPreferencesImpl parent) {
        super((Preferences)parent);
    }

    public synchronized void addPreferencesListener(PreferencesListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removePreferencesListener(PreferencesListener listener) {
        this.listeners.remove(listener);
    }

    private synchronized PreferencesListener[] getPreferencesListeners() {
        return this.listeners.toArray(new PreferencesListener[0]);
    }

    public String[] getKeyNames() {
        return this.values.keySet().toArray(new String[0]);
    }

    public MainPreferences getParent() {
        return (MainPreferences)super.getParent();
    }

    public MainPreferencesImpl getChildNode(String name) {
        return this.children.get(name);
    }

    public MainPreferences getOrCreateChildNode(String name) {
        if (!this.children.containsKey(name)) {
            MainPreferencesImpl newNode = new MainPreferencesImpl(this);
            newNode.virtual = true;
            this.children.put(name, newNode);
        }
        return this.children.get(name);
    }

    public String[] getChildNodeNames() {
        return this.children.keySet().toArray(new String[0]);
    }

    protected String internalGetStringValue(String key) {
        return this.values.get(key);
    }

    public void applyPreferences(Preferences prefs) throws ConfigException {
        SimplePreferences oldPrefs;
        if (this.virtual) {
            this.virtual = false;
            oldPrefs = new SimplePreferences(null);
            ConfigUtil.copyPreferences((Preferences)this.getParent(), (MutablePreferences)oldPrefs);
            ((MainPreferencesImpl)this.getParent()).applyPreferences((Preferences)oldPrefs);
        }
        this.fireAboutToChange(prefs);
        oldPrefs = new SimplePreferences(null);
        ConfigUtil.copyPreferences((Preferences)this, (MutablePreferences)oldPrefs);
        this.values.clear();
        for (String key : prefs.getKeyNames()) {
            this.values.put(key, prefs.getStringValue(key));
        }
        List<String> newChildNodes = Arrays.asList(prefs.getChildNodeNames());
        for (String node : newChildNodes) {
            MainPreferencesImpl child = this.getChildNode(node);
            if (child == null) {
                child = new MainPreferencesImpl(this);
                this.children.put(node, child);
            }
            child.applyPreferences(prefs.getChildNode(node));
        }
        for (String node : this.getChildNodeNames()) {
            if (newChildNodes.contains(node)) continue;
            this.children.remove(node);
        }
        this.fireChanged((Preferences)oldPrefs);
    }

    private void fireAboutToChange(Preferences newPrefs) throws ConfigException {
        for (String string : newPrefs.getChildNodeNames()) {
            MainPreferencesImpl child = this.children.get(string);
            if (child == null) continue;
            child.fireAboutToChange(newPrefs.getChildNode(string));
        }
        for (String string : this.getPreferencesListeners()) {
            string.preferencesAboutToChange((Preferences)this, newPrefs);
        }
    }

    private void fireChanged(Preferences oldPrefs) throws ConfigException {
        for (PreferencesListener listener : this.getPreferencesListeners()) {
            listener.preferencesChanged(oldPrefs, (MainPreferences)this);
        }
    }
}

