/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.cloud.impl.auth;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.aludratest.cloud.impl.auth.JSONResourceTypeAuthorizationConfig;
import org.aludratest.cloud.resource.ResourceType;
import org.aludratest.cloud.resource.user.ResourceTypeAuthorizationConfig;
import org.aludratest.cloud.resource.user.ResourceTypeAuthorizationStore;
import org.aludratest.cloud.user.StoreException;
import org.aludratest.cloud.user.admin.UserDatabaseRegistry;
import org.apache.commons.io.IOUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Configuration;
import org.codehaus.plexus.component.annotations.Requirement;
import org.json.JSONException;
import org.json.JSONObject;

@Component(role=ResourceTypeAuthorizationStore.class)
public class LocalResourceTypeAuthorizationStore
implements ResourceTypeAuthorizationStore {
    @Requirement
    private UserDatabaseRegistry userDatabaseRegistry;
    @Configuration(value="~/.atcloudmanager/resourceAuth.json")
    private String storeFile;

    public ResourceTypeAuthorizationConfig loadResourceTypeAuthorizations(ResourceType resourceType) throws StoreException {
        try {
            return new JSONResourceTypeAuthorizationConfig(this.load().getJSONArray(resourceType.getName()), this.userDatabaseRegistry);
        }
        catch (JSONException e) {
            return null;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveResourceTypeAuthorizations(ResourceType resourceType, ResourceTypeAuthorizationConfig authorizations) throws StoreException {
        FileOutputStream fos = null;
        try {
            JSONObject obj = this.load();
            if (authorizations instanceof JSONResourceTypeAuthorizationConfig) {
                obj.put(resourceType.getName(), (Object)((JSONResourceTypeAuthorizationConfig)authorizations).getJsonArray());
            } else {
                obj.put(resourceType.getName(), (Object)JSONResourceTypeAuthorizationConfig.toJSONArray(authorizations));
            }
            fos = new FileOutputStream(this.getFile());
            fos.write(obj.toString().getBytes("UTF-8"));
        }
        catch (IOException e) {
            try {
                throw new StoreException("Could not write resource authorization file", (Throwable)e);
                catch (JSONException e2) {
                    throw new StoreException("Could not create JSON for resource authorization file", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject load() throws StoreException {
        JSONObject jSONObject;
        if (!this.getFile().exists()) {
            return new JSONObject();
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.getFile());
            jSONObject = new JSONObject(IOUtils.toString((InputStream)fis, (String)"UTF-8"));
        }
        catch (IOException e) {
            try {
                throw new StoreException("Could not load resource type authorization file", (Throwable)e);
                catch (JSONException e2) {
                    throw new StoreException("Resource type authorization file has invalid contents", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
        return jSONObject;
    }

    private synchronized File getFile() {
        if (this.storeFile.startsWith("~")) {
            return new File(System.getProperty("user.home") + this.storeFile.substring(1));
        }
        return new File(this.storeFile);
    }

    public synchronized void setStoreFile(String storeFile) {
        this.storeFile = storeFile;
    }

    public synchronized String getStoreFile() {
        return this.storeFile;
    }
}

