/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.cloud.impl.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aludratest.cloud.impl.auth.SimpleResourceTypeAuthorization;
import org.aludratest.cloud.resource.user.MutableResourceTypeAuthorizationConfig;
import org.aludratest.cloud.resource.user.ResourceTypeAuthorization;
import org.aludratest.cloud.resource.user.ResourceTypeAuthorizationConfig;
import org.aludratest.cloud.user.StoreException;
import org.aludratest.cloud.user.User;
import org.aludratest.cloud.user.UserDatabase;
import org.aludratest.cloud.user.admin.UserDatabaseRegistry;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONResourceTypeAuthorizationConfig
implements MutableResourceTypeAuthorizationConfig {
    private JSONArray jsonArray;
    private List<User> allUsers = new ArrayList<User>();

    public JSONResourceTypeAuthorizationConfig(JSONArray jsonArray, UserDatabaseRegistry userDatabaseRegistry) throws JSONException, StoreException {
        this.jsonArray = jsonArray;
        for (int i = 0; i < jsonArray.length(); ++i) {
            User u;
            JSONObject o = jsonArray.getJSONObject(i);
            String source = o.getString("userSource");
            String userName = o.getString("userName");
            UserDatabase db = userDatabaseRegistry.getUserDatabase(source);
            if (db == null || (u = db.findUser(userName)) == null) continue;
            this.allUsers.add(u);
        }
    }

    public static JSONArray toJSONArray(ResourceTypeAuthorizationConfig config) throws JSONException {
        ArrayList<JSONObject> values = new ArrayList<JSONObject>();
        for (User user : config.getConfiguredUsers()) {
            ResourceTypeAuthorization auth = config.getResourceTypeAuthorizationForUser(user);
            JSONObject obj = new JSONObject();
            obj.put("userName", (Object)user.getName());
            obj.put("userSource", (Object)user.getSource());
            obj.put("maxResources", auth.getMaxResources());
            obj.put("niceLevel", auth.getNiceLevel());
            values.add(obj);
        }
        return new JSONArray(values);
    }

    public JSONArray getJsonArray() {
        return this.jsonArray;
    }

    public ResourceTypeAuthorization getResourceTypeAuthorizationForUser(User user) {
        try {
            int i = this.getUserIndex(user);
            if (i == -1) {
                return null;
            }
            JSONObject o = this.jsonArray.getJSONObject(i);
            return new SimpleResourceTypeAuthorization(o.getInt("maxResources"), o.getInt("niceLevel"));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public List<User> getConfiguredUsers() {
        return Collections.unmodifiableList(this.allUsers);
    }

    public void addUser(User user, ResourceTypeAuthorization authorization) throws IllegalArgumentException {
        try {
            if (this.getUserIndex(user) > -1) {
                throw new IllegalArgumentException("A resource type authorization for user " + user + " is already set.");
            }
            JSONObject o = new JSONObject();
            o.put("userName", (Object)user.getName());
            o.put("userSource", (Object)user.getSource());
            o.put("maxResources", authorization.getMaxResources());
            o.put("niceLevel", authorization.getNiceLevel());
            this.jsonArray.put((Object)o);
            this.allUsers.add(user);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeUser(User user) throws IllegalArgumentException {
        try {
            int i;
            int index = this.getUserIndex(user);
            if (index == -1) {
                throw new IllegalArgumentException("No resource type authorization for user " + user + " is set.");
            }
            ArrayList<JSONObject> ls = new ArrayList<JSONObject>();
            for (i = 0; i < index; ++i) {
                ls.add(this.jsonArray.getJSONObject(i));
            }
            for (i = index + 1; i < this.jsonArray.length(); ++i) {
                ls.add(this.jsonArray.getJSONObject(i));
            }
            this.jsonArray = new JSONArray(ls);
            this.allUsers.remove(user);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public void editUserAuthorization(User user, ResourceTypeAuthorization newAuthorization) throws IllegalArgumentException {
        try {
            int index = this.getUserIndex(user);
            if (index == -1) {
                throw new IllegalArgumentException("No resource type authorization for user " + user + " is set.");
            }
            JSONObject o = this.jsonArray.getJSONObject(index);
            o.put("maxResources", newAuthorization.getMaxResources());
            o.put("niceLevel", newAuthorization.getNiceLevel());
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private int getUserIndex(User user) throws JSONException {
        for (int i = 0; i < this.jsonArray.length(); ++i) {
            JSONObject o = this.jsonArray.getJSONObject(i);
            if (!user.getName().equals(o.getString("userName")) || !user.getSource().equals(o.getString("userSource"))) continue;
            return i;
        }
        return -1;
    }
}

