/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.cloud.impl.app;

import java.io.File;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import javax.sql.rowset.CachedRowSet;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DataSourceConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogDatabase {
    private static final Logger LOG = LoggerFactory.getLogger(LogDatabase.class);
    private static final String DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    private NetworkServerControl server;
    private DataSource dataSource;

    LogDatabase() throws Exception {
        File derbyDir = new File(new File(System.getProperty("user.home")), ".atcloudmanager/derby");
        System.setProperty("derby.system.home", derbyDir.getAbsolutePath());
        Class.forName(DRIVER).newInstance();
        this.server = new NetworkServerControl(InetAddress.getByName("0.0.0.0"), 1527);
        this.server.start(null);
    }

    public boolean isDatabaseExisting() {
        try {
            DriverManager.getConnection("jdbc:derby:acm").close();
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public void createDatabase() throws SQLException {
        DriverManager.getConnection("jdbc:derby:acm;create=true").close();
    }

    public void shutdown() {
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.server.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Connection getConnection() throws SQLException {
        if (this.dataSource == null) {
            EmbeddedDataSource ds = new EmbeddedDataSource();
            ds.setDatabaseName("acm");
            DataSourceConnectionFactory connectionFactory = new DataSourceConnectionFactory((DataSource)ds);
            PoolableConnectionFactory objFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
            objFactory.setValidationQuery("VALUES 1");
            objFactory.setDefaultAutoCommit(Boolean.valueOf(true));
            objFactory.setMaxConnLifetimeMillis(600000L);
            objFactory.setValidationQueryTimeout(5);
            GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)objFactory);
            pool.setMaxIdle(2);
            this.dataSource = new PoolingDataSource((ObjectPool)pool);
        }
        return this.dataSource.getConnection();
    }

    /*
     * Exception decompiling
     */
    public CachedRowSet populateQuery(String query) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void executeStatement(String sql) throws SQLException {
        this.executeStatement(sql, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long executeStatement(String sql, int[] autoGenerationIndices) throws SQLException {
        Connection connection = this.getConnection();
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            LOG.debug("Executing database statement: " + sql);
            if (autoGenerationIndices != null) {
                stmt.execute(sql, autoGenerationIndices);
            } else {
                stmt.execute(sql);
            }
            LOG.debug("Statement execution complete.");
            ResultSet rs = stmt.getGeneratedKeys();
            if (rs == null || !rs.next()) {
                Long l = null;
                return l;
            }
            Long l = rs.getLong(1);
            return l;
        }
        finally {
            this.closeQuietly(stmt);
            this.closeQuietly(connection);
        }
    }

    private void closeQuietly(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void closeQuietly(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

