/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.cloud.impl.app;

import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.rowset.CachedRowSet;
import org.aludratest.cloud.impl.app.LogDatabase;
import org.aludratest.cloud.user.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseRequestLogger
implements Runnable {
    private static final int[] DB_SCHEMA_VERSION = new int[]{1, 0};
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseRequestLogger.class);
    private LogDatabase database;
    private ConcurrentLinkedQueue<DatabaseCommand> commandQueue = new ConcurrentLinkedQueue();
    private Map<Long, Long> virtualToDbRequestIds = new ConcurrentHashMap<Long, Long>();
    private final DateFormat DF_TIMESTAMP = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private AtomicLong nextVirtualRequestId = new AtomicLong();

    public DatabaseRequestLogger(LogDatabase database) throws SQLException {
        this.database = database;
        this.DF_TIMESTAMP.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (!database.isDatabaseExisting()) {
            database.createDatabase();
            this.createBasicTables();
        }
        this.checkTablesVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(DatabaseCommand command) {
        this.commandQueue.add(command);
        DatabaseRequestLogger databaseRequestLogger = this;
        synchronized (databaseRequestLogger) {
            this.notify();
        }
    }

    private void executeCommand(DatabaseCommand command) throws SQLException {
        if (command.create) {
            Long result = this.database.executeStatement(command.sql, new int[]{1});
            this.virtualToDbRequestIds.put(command.mappingRequestId, result);
        } else {
            Long dbId = this.virtualToDbRequestIds.get(command.mappingRequestId);
            if (dbId == null) {
                throw new SQLException("No database ID known to update request " + command.mappingRequestId);
            }
            this.database.executeStatement(command.sql.replace(":dbId", dbId.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!Thread.interrupted()) {
            while (this.commandQueue.isEmpty()) {
                DatabaseRequestLogger databaseRequestLogger = this;
                synchronized (databaseRequestLogger) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
            while (!this.commandQueue.isEmpty()) {
                DatabaseCommand command = this.commandQueue.poll();
                try {
                    this.executeCommand(command);
                }
                catch (SQLException e) {
                    LOG.error("Could not execute log database statement", (Throwable)e);
                }
                if (!Thread.interrupted()) continue;
                return;
            }
        }
    }

    public long createRequestLog(User user, String jobName) {
        long virtualId = this.nextVirtualRequestId.incrementAndGet();
        String sql = "INSERT INTO acm_request (start_wait_time_utc, user_name, user_source, job_name) VALUES (" + this.getCurrentUTCTimestampExpr() + ", '" + user.getName() + "', '" + user.getSource() + "', '" + jobName + "')";
        this.enqueue(new DatabaseCommand(sql, virtualId, true));
        return virtualId;
    }

    public void updateRequestLogWorkStarted(long id, String resourceType, String resource) {
        String sql = "UPDATE acm_request SET start_work_time_utc = " + this.getCurrentUTCTimestampExpr() + ", resource_type = '" + resourceType + "', received_resource = '" + resource + "' WHERE request_id = :dbId";
        this.enqueue(new DatabaseCommand(sql, id, false));
    }

    public void updateRequestLogWorkDone(long id, String status, int cntActiveResourcesLeft) {
        String sql = "UPDATE acm_request SET end_work_time_utc = " + this.getCurrentUTCTimestampExpr() + ", end_work_status = '" + status + "', cnt_active_res_after_work = " + cntActiveResourcesLeft + " WHERE request_id = :dbId";
        this.enqueue(new DatabaseCommand(sql, id, false));
    }

    private void checkTablesVersion() throws SQLException {
        String sql = "SELECT major, minor FROM acm_version";
        CachedRowSet rs = this.database.populateQuery(sql);
        if (!rs.next()) {
            throw new SQLException("acm_version is empty");
        }
        int major = rs.getInt(1);
        int minor = rs.getInt(2);
        if (major != DB_SCHEMA_VERSION[0] || minor != DB_SCHEMA_VERSION[1]) {
            throw new SQLException("Unsupported version of database schema: " + major + "." + minor);
        }
    }

    private void createBasicTables() throws SQLException {
        String sql = "CREATE TABLE acm_version (major INTEGER NOT NULL, minor INTEGER NOT NULL)";
        this.database.executeStatement(sql);
        sql = "CREATE TABLE acm_request (request_id BIGINT GENERATED ALWAYS AS IDENTITY, start_wait_time_utc TIMESTAMP, start_work_time_utc TIMESTAMP, end_work_time_utc TIMESTAMP, user_name VARCHAR(50), user_source VARCHAR(100), job_name VARCHAR(400), received_resource VARCHAR(400), resource_type VARCHAR(40), end_work_status VARCHAR(20), cnt_active_res_after_work INTEGER)";
        this.database.executeStatement(sql);
        this.writeAcmVersion();
    }

    private void writeAcmVersion() throws SQLException {
        String sql = "DELETE FROM acm_version";
        this.database.executeStatement(sql);
        sql = "INSERT INTO acm_version VALUES (" + DB_SCHEMA_VERSION[0] + ", " + DB_SCHEMA_VERSION[1] + ")";
        this.database.executeStatement(sql);
    }

    private String getCurrentUTCTimestampExpr() {
        return this.getUTCTimestampExpr(new Date());
    }

    private String getUTCTimestampExpr(Date dt) {
        return "TIMESTAMP('" + this.DF_TIMESTAMP.format(dt) + "')";
    }

    private static class DatabaseCommand {
        private String sql;
        private boolean create;
        private Long mappingRequestId;

        public DatabaseCommand(String sql, long mappingRequestId, boolean create) {
            this.sql = sql;
            this.mappingRequestId = mappingRequestId;
            this.create = create;
        }
    }
}

