/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.cloud.impl.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.aludratest.cloud.app.CloudManagerApp;
import org.aludratest.cloud.config.ConfigException;
import org.aludratest.cloud.config.MainPreferences;
import org.aludratest.cloud.config.MutablePreferences;
import org.aludratest.cloud.config.Preferences;
import org.aludratest.cloud.config.PreferencesListener;
import org.aludratest.cloud.config.SimplePreferences;
import org.aludratest.cloud.impl.app.DatabaseRequestLogger;
import org.aludratest.cloud.impl.app.LogDatabase;
import org.aludratest.cloud.impl.config.MainPreferencesImpl;
import org.apache.commons.io.IOUtils;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudManagerApplicationHolder
implements PreferencesListener {
    private static final Logger LOG = LoggerFactory.getLogger(CloudManagerApplicationHolder.class);
    private static final String CONFIG_FILENAME = "acm.config";
    private static CloudManagerApplicationHolder instance;
    private PlexusContainer plexus;
    private CloudManagerApp application;
    private MainPreferences rootPreferences;
    private File configFile;
    private LogDatabase logDatabase;
    private DatabaseRequestLogger requestLogger;
    private Thread requestLoggerThread;
    private ScheduledExecutorService saveScheduler;
    private ScheduledFuture<?> scheduledSave;

    private CloudManagerApplicationHolder() {
    }

    public static CloudManagerApplicationHolder getInstance() {
        return instance;
    }

    public static void startup() throws PlexusContainerException, ComponentLookupException, ConfigException {
        instance = new CloudManagerApplicationHolder();
        instance.internalStartup();
    }

    private void internalStartup() throws PlexusContainerException, ComponentLookupException, ConfigException {
        this.plexus = new DefaultPlexusContainer();
        this.saveScheduler = Executors.newScheduledThreadPool(1);
        this.application = (CloudManagerApp)this.plexus.lookup(CloudManagerApp.class);
        this.rootPreferences = new MainPreferencesImpl(null);
        ((MainPreferencesImpl)this.rootPreferences).applyPreferences((Preferences)this.readConfig());
        this.attachPreferencesListener(this.rootPreferences);
        try {
            this.logDatabase = new LogDatabase();
            this.requestLogger = new DatabaseRequestLogger(this.logDatabase);
            this.requestLoggerThread = new Thread(this.requestLogger);
            this.requestLoggerThread.start();
        }
        catch (Exception e) {
            throw new ConfigException("Could not initialize internal Derby Database", (Throwable)e);
        }
        this.application.start(this.rootPreferences);
    }

    private void attachPreferencesListener(MainPreferences preferences) {
        preferences.addPreferencesListener((PreferencesListener)this);
        for (String nodeName : preferences.getChildNodeNames()) {
            this.attachPreferencesListener(preferences.getChildNode(nodeName));
        }
    }

    public static void shutdown() {
        instance.internalShutdown();
        instance = null;
    }

    private void internalShutdown() {
        this.application.shutdown();
        this.saveScheduler.shutdown();
        this.plexus.dispose();
        this.requestLoggerThread.interrupt();
        try {
            this.requestLoggerThread.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.logDatabase.shutdown();
    }

    public PlexusContainer getPlexusContainer() {
        return this.plexus;
    }

    public MainPreferences getRootPreferences() {
        return this.rootPreferences;
    }

    public LogDatabase getDatabase() {
        return this.logDatabase;
    }

    public DatabaseRequestLogger getRequestLogger() {
        return this.requestLogger;
    }

    private MutablePreferences readConfig() {
        File f;
        String acmHome = System.getProperty("acm.home");
        if (acmHome != null) {
            f = new File(acmHome);
            if (!f.isDirectory() && !f.mkdirs()) {
                LOG.warn("Cannot use directory " + acmHome + " for AludraTest Cloud Manager configuration. Falling back user home.");
            } else {
                try {
                    this.testWriteability(f);
                    this.configFile = new File(f, CONFIG_FILENAME);
                }
                catch (IOException e) {
                    LOG.warn("Cannot store configuration in directory " + acmHome + ": Could not create config file in " + f.getAbsolutePath());
                    LOG.warn("Falling back to user home.");
                }
            }
        }
        if (this.configFile == null) {
            f = new File(new File(System.getProperty("user.home")), ".atcloudmanager");
            if (!f.isDirectory() && !f.mkdir()) {
                LOG.error("Cannot store configuration in user home directory: Could not create directory " + f.getAbsolutePath());
                return new SimplePreferences(null);
            }
            try {
                this.testWriteability(f);
            }
            catch (IOException e) {
                LOG.error("Cannot store configuration in user home directory: Could not write config file to " + f.getAbsolutePath());
                return new SimplePreferences(null);
            }
            this.configFile = new File(f, CONFIG_FILENAME);
        }
        return this.readPreferences(this.configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testWriteability(File directory) throws IOException {
        File f = new File(directory, CONFIG_FILENAME);
        if (!f.exists()) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                f.delete();
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fos);
            f.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MutablePreferences readPreferences(File f) {
        SimplePreferences prefs = new SimplePreferences(null);
        if (!f.exists()) {
            return prefs;
        }
        Properties p = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            p.loadFromXML(fis);
            for (String key : p.stringPropertyNames()) {
                String value = p.getProperty(key);
                if ("".equals(value)) {
                    value = null;
                }
                prefs.setValue(key, value);
            }
        }
        catch (IOException e) {
            SimplePreferences simplePreferences;
            try {
                LOG.error("Could not read preferences file " + f.getAbsolutePath(), (Throwable)e);
                simplePreferences = prefs;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fis);
            return simplePreferences;
        }
        IOUtils.closeQuietly((InputStream)fis);
        return prefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePreferences(File f, Preferences prefs) {
        Properties p = new Properties();
        CloudManagerApplicationHolder.copyToProperties(prefs, null, p);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
            p.storeToXML(fos, "AludraTest Cloud Manager auto-generated config file. DO NOT MODIFY!!");
        }
        catch (IOException e) {
            try {
                LOG.error("Could not write preferences file " + f.getAbsolutePath(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fos);
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    private static void copyToProperties(Preferences prefs, String prefix, Properties p) {
        for (String key : prefs.getKeyNames()) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            String value = prefs.getStringValue(key);
            if (value == null) {
                value = "";
            }
            p.setProperty(prefix == null ? key : prefix + "/" + key, value);
        }
        for (String node : prefs.getChildNodeNames()) {
            CloudManagerApplicationHolder.copyToProperties(prefs.getChildNode(node), prefix == null ? node : prefix + "/" + node, p);
        }
    }

    private void saveAllPreferences() {
        if (this.configFile == null) {
            throw new IllegalStateException("Config cannot be saved before loaded");
        }
        LOG.debug("Saving ACM preferences");
        this.writePreferences(this.configFile, (Preferences)this.rootPreferences);
    }

    public void preferencesAboutToChange(Preferences oldPreferences, Preferences newPreferences) throws ConfigException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preferencesChanged(Preferences oldPreferences, MainPreferences newPreferences) throws ConfigException {
        this.attachPreferencesListener(newPreferences);
        CloudManagerApplicationHolder cloudManagerApplicationHolder = this;
        synchronized (cloudManagerApplicationHolder) {
            if (this.scheduledSave != null) {
                this.scheduledSave.cancel(false);
            }
        }
        this.scheduledSave = this.saveScheduler.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CloudManagerApplicationHolder cloudManagerApplicationHolder = CloudManagerApplicationHolder.this;
                synchronized (cloudManagerApplicationHolder) {
                    CloudManagerApplicationHolder.this.scheduledSave = null;
                }
                CloudManagerApplicationHolder.this.saveAllPreferences();
            }
        }, 100L, TimeUnit.MILLISECONDS);
    }
}

