/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.cloud.impl.app;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.aludratest.cloud.app.CloudManagerApp;
import org.aludratest.cloud.app.CloudManagerAppConfig;
import org.aludratest.cloud.config.ConfigException;
import org.aludratest.cloud.config.ConfigManager;
import org.aludratest.cloud.config.ConfigUtil;
import org.aludratest.cloud.config.Configurable;
import org.aludratest.cloud.config.MainPreferences;
import org.aludratest.cloud.config.MutablePreferences;
import org.aludratest.cloud.config.Preferences;
import org.aludratest.cloud.config.PreferencesListener;
import org.aludratest.cloud.config.SimplePreferences;
import org.aludratest.cloud.impl.app.CloudManagerAppConfigImpl;
import org.aludratest.cloud.manager.ResourceManager;
import org.aludratest.cloud.module.ResourceModule;
import org.aludratest.cloud.plugin.CloudManagerPlugin;
import org.aludratest.cloud.resource.ResourceType;
import org.aludratest.cloud.resource.user.ResourceTypeAuthorizationStore;
import org.aludratest.cloud.resource.writer.ResourceWriterFactory;
import org.aludratest.cloud.resourcegroup.ResourceGroupManager;
import org.aludratest.cloud.user.UserDatabase;
import org.aludratest.cloud.user.admin.UserDatabaseRegistry;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=CloudManagerApp.class)
public final class CloudManagerAppImpl
extends CloudManagerApp {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudManagerAppImpl.class);
    @Requirement(role=ResourceModule.class)
    private Map<String, ResourceModule> resourceModules = new HashMap<String, ResourceModule>();
    @Requirement
    private UserDatabaseRegistry userDatabaseRegistry;
    @Requirement
    private ResourceTypeAuthorizationStore authorizationStore;
    @Requirement
    private ResourceManager resourceManager;
    @Requirement
    private ResourceGroupManager resourceGroupManager;
    @Requirement
    private ConfigManager configManager;
    @Requirement(role=CloudManagerPlugin.class)
    private Map<String, CloudManagerPlugin> pluginRegistry;
    private UserDatabase selectedUserDatabase;
    private List<ResourceModule> readOnlyResourceModules;
    private MainPreferences preferencesRoot;
    private CloudManagerAppConfigImpl configuration;

    public CloudManagerAppImpl() {
        CloudManagerApp.instance = this;
    }

    public void start(MainPreferences configuration) throws ConfigException {
        this.preferencesRoot = configuration;
        SimplePreferences mutableRoot = new SimplePreferences(null);
        ConfigUtil.copyPreferences((Preferences)this.preferencesRoot, (MutablePreferences)mutableRoot);
        if (mutableRoot.getChildNode("basic") == null) {
            MutablePreferences basicRoot = mutableRoot.createChildNode("basic");
            CloudManagerAppConfigImpl.fillDefaults(basicRoot);
        }
        MutablePreferences modulesRoot = mutableRoot.createChildNode("modules");
        for (ResourceModule resourceModule : this.getAllResourceModules()) {
            String string;
            if (!(resourceModule instanceof Configurable) || modulesRoot.getChildNode(string = resourceModule.getResourceType().getName()) != null) continue;
            ((Configurable)resourceModule).fillDefaults(modulesRoot.createChildNode(string));
        }
        MutablePreferences pluginsRoot = mutableRoot.createChildNode("plugins");
        for (Map.Entry<String, CloudManagerPlugin> entry : this.pluginRegistry.entrySet()) {
            String nodeName;
            if (!(entry.getValue() instanceof Configurable) || pluginsRoot.getChildNode(nodeName = entry.getKey()) != null) continue;
            ((Configurable)entry.getValue()).fillDefaults(pluginsRoot.createChildNode(nodeName));
        }
        if (mutableRoot.getChildNode("groups") == null) {
            MutablePreferences mutablePreferences = mutableRoot.createChildNode("groups");
            if (this.resourceGroupManager instanceof Configurable) {
                ((Configurable)this.resourceGroupManager).fillDefaults(mutablePreferences);
            }
        }
        if (ConfigUtil.differs((Preferences)mutableRoot, (Preferences)this.preferencesRoot)) {
            this.getConfigManager().applyConfig((Preferences)mutableRoot, this.preferencesRoot);
        }
        this.preferencesRoot.getChildNode("basic").addPreferencesListener(new PreferencesListener(){

            public void preferencesChanged(Preferences oldPreferences, MainPreferences newPreferences) throws ConfigException {
                CloudManagerAppImpl.this.configuration = new CloudManagerAppConfigImpl((Preferences)newPreferences);
            }

            public void preferencesAboutToChange(Preferences oldPreferences, Preferences newPreferences) throws ConfigException {
            }
        });
        this.configure(this.preferencesRoot);
        this.resourceManager.start(this.resourceGroupManager);
        for (CloudManagerPlugin cloudManagerPlugin : this.pluginRegistry.values()) {
            cloudManagerPlugin.applicationStarted();
        }
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.aludratest.cloud:type=ResourceGroupManager");
            mBeanServer.registerMBean(this.resourceGroupManager, objectName);
            ObjectName objectName2 = new ObjectName("org.aludratest.cloud:type=ResourceManager");
            mBeanServer.registerMBean(this.resourceManager, objectName2);
        }
        catch (JMException jMException) {
            LOGGER.warn("Could not register beans in JMX", (Throwable)jMException);
        }
    }

    public void shutdown() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.unregisterMBean(new ObjectName("org.aludratest.cloud:type=ResourceGroupManager"));
            mbs.unregisterMBean(new ObjectName("org.aludratest.cloud:type=ResourceManager"));
        }
        catch (JMException e) {
            LOGGER.warn("Could not register beans in JMX", (Throwable)e);
        }
        this.resourceManager.shutdown();
        for (ResourceModule module : this.resourceModules.values()) {
            module.handleApplicationShutdown();
        }
        for (CloudManagerPlugin plugin : this.pluginRegistry.values()) {
            plugin.applicationStopped();
        }
        this.preferencesRoot = null;
    }

    public boolean isStarted() {
        return this.preferencesRoot != null;
    }

    private void configure(MainPreferences preferences) throws ConfigException {
        MainPreferences basic = preferences.getOrCreateChildNode("basic");
        this.configuration = new CloudManagerAppConfigImpl((Preferences)basic);
        this.selectedUserDatabase = this.userDatabaseRegistry.getUserDatabase(this.configuration.getUserAuthenticationSource());
        if (this.selectedUserDatabase == null) {
            this.selectedUserDatabase = (UserDatabase)this.userDatabaseRegistry.getAllUserDatabases().get(0);
            LOGGER.warn("Could not find user database of type " + this.configuration.getUserAuthenticationSource() + ". Using first found user database " + this.selectedUserDatabase + ".");
        }
        MainPreferences modulesRoot = preferences.getOrCreateChildNode("modules");
        for (ResourceModule resourceModule : this.getAllResourceModules()) {
            MainPreferences mainPreferences;
            if (!(resourceModule instanceof Configurable) || (mainPreferences = modulesRoot.getChildNode(resourceModule.getResourceType().getName())) == null) continue;
            ((Configurable)resourceModule).setPreferences(mainPreferences);
        }
        MainPreferences pluginsRoot = preferences.getOrCreateChildNode("plugins");
        for (Map.Entry<String, CloudManagerPlugin> entry : this.pluginRegistry.entrySet()) {
            MainPreferences prefs;
            if (!(entry.getValue() instanceof Configurable) || (prefs = pluginsRoot.getChildNode(entry.getKey())) == null) continue;
            ((Configurable)entry.getValue()).setPreferences(prefs);
        }
        MainPreferences mainPreferences = preferences.getOrCreateChildNode("groups");
        if (this.resourceGroupManager instanceof Configurable) {
            ((Configurable)this.resourceGroupManager).setPreferences(mainPreferences);
        }
    }

    public ResourceWriterFactory getResourceWriterFactory(ResourceType resourceType) {
        ResourceModule module = this.getResourceModule(resourceType);
        return module == null ? null : module.getResourceWriterFactory();
    }

    public UserDatabaseRegistry getUserDatabaseRegistry() {
        return this.userDatabaseRegistry;
    }

    public UserDatabase getSelectedUserDatabase() {
        return this.selectedUserDatabase;
    }

    public ResourceTypeAuthorizationStore getResourceTypeAuthorizationStore() {
        return this.authorizationStore;
    }

    public ResourceGroupManager getResourceGroupManager() {
        return this.resourceGroupManager;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public CloudManagerAppConfig getBasicConfiguration() {
        return this.configuration;
    }

    public List<ResourceModule> getAllResourceModules() {
        if (this.readOnlyResourceModules == null) {
            this.readOnlyResourceModules = Collections.unmodifiableList(new ArrayList<ResourceModule>(this.resourceModules.values()));
        }
        return this.readOnlyResourceModules;
    }
}

