/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.cloud.impl.app;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.aludratest.cloud.app.CloudManagerAppConfig;
import org.aludratest.cloud.config.ConfigException;
import org.aludratest.cloud.config.MutablePreferences;
import org.aludratest.cloud.config.Preferences;

public class CloudManagerAppConfigImpl
implements CloudManagerAppConfig {
    private static final String CONFIG_HOST_NAME = "hostName";
    private static final String CONFIG_USE_PROXY = "useProxy";
    private static final String CONFIG_PROXY_HOST = "proxyHost";
    private static final String CONFIG_PROXY_PORT = "proxyPort";
    private static final String CONFIG_PROXY_BYPASS_REGEXP = "bypassProxyRegexp";
    private static final String CONFIG_USER_AUTH = "userAuthentication";
    private static final String CONFIG_PHANTOMJS_EXE = "phantomJSExecutable";
    private String hostName;
    private String userAuthenticationSource;
    private String phantomJsExecutable;
    private boolean useProxy;
    private String proxyHost;
    private int proxyPort;
    private String bypassProxyRegexp;

    public CloudManagerAppConfigImpl(Preferences prefs) throws ConfigException {
        this.hostName = prefs.getStringValue(CONFIG_HOST_NAME);
        this.useProxy = prefs.getBooleanValue(CONFIG_USE_PROXY);
        this.proxyHost = prefs.getStringValue(CONFIG_PROXY_HOST);
        String s = prefs.getStringValue(CONFIG_PROXY_PORT);
        if (s != null) {
            try {
                this.proxyPort = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new ConfigException("Proxy port is invalid", CONFIG_PROXY_PORT);
            }
            if (this.proxyPort < 1 || this.proxyPort > 65535) {
                throw new ConfigException("Proxy port is invalid", CONFIG_PROXY_PORT);
            }
        }
        this.bypassProxyRegexp = prefs.getStringValue(CONFIG_PROXY_BYPASS_REGEXP);
        if (this.bypassProxyRegexp != null) {
            try {
                Pattern.compile(this.bypassProxyRegexp);
            }
            catch (PatternSyntaxException e) {
                throw new ConfigException("Regular expression for proxy bypass hosts is invalid: " + e.getMessage(), CONFIG_PROXY_BYPASS_REGEXP);
            }
        }
        this.userAuthenticationSource = prefs.getStringValue(CONFIG_USER_AUTH);
        this.phantomJsExecutable = prefs.getStringValue(CONFIG_PHANTOMJS_EXE);
    }

    public static void fillDefaults(MutablePreferences preferences) {
        preferences.setValue(CONFIG_HOST_NAME, "localhost");
        preferences.setValue(CONFIG_USER_AUTH, "local-file");
    }

    public String getHostName() {
        return this.hostName;
    }

    public boolean isUseProxy() {
        return this.useProxy;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getBypassProxyRegexp() {
        return this.bypassProxyRegexp;
    }

    public String getUserAuthenticationSource() {
        return this.userAuthenticationSource;
    }

    public String getPhantomJsExecutable() {
        return this.phantomJsExecutable;
    }
}

