/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.swift.http;

import alluxio.underfs.swift.SwiftOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.annotation.concurrent.ThreadSafe;
import org.javaswift.joss.model.Access;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SwiftDirectClient {
    private static final Logger LOG = LoggerFactory.getLogger(SwiftDirectClient.class);
    private static final int HTTP_READ_TIMEOUT = 100000;
    private static final int HTTP_CHUNK_STREAMING = 0x800000;

    public static SwiftOutputStream put(Access access, String objectName) throws IOException {
        LOG.debug("PUT method, object : {}", (Object)objectName);
        URL url = new URL(access.getPublicURL() + "/" + objectName);
        URLConnection connection = url.openConnection();
        if (!(connection instanceof HttpURLConnection)) {
            throw new IOException("Connection is not an instance of HTTP URL Connection");
        }
        HttpURLConnection httpCon = (HttpURLConnection)connection;
        httpCon.setRequestMethod("PUT");
        httpCon.addRequestProperty("X-Auth-Token", access.getToken());
        httpCon.addRequestProperty("Content-Type", "binary/octet-stream");
        httpCon.setDoInput(true);
        httpCon.setRequestProperty("Connection", "close");
        httpCon.setReadTimeout(100000);
        httpCon.setRequestProperty("Transfer-Encoding", "chunked");
        httpCon.setDoOutput(true);
        httpCon.setChunkedStreamingMode(0x800000);
        httpCon.connect();
        return new SwiftOutputStream(httpCon);
    }
}

