/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.swift;

import alluxio.AlluxioURI;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.swift.SwiftUnderFileSystem;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SwiftUnderFileSystemFactory
implements UnderFileSystemFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SwiftUnderFileSystemFactory.class);

    public UnderFileSystem create(String path, UnderFileSystemConfiguration conf, AlluxioConfiguration alluxioConf) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        if (this.checkSwiftCredentials(conf)) {
            try {
                return new SwiftUnderFileSystem(new AlluxioURI(path), conf, alluxioConf);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        String err = "Swift Credentials not available, cannot create Swift Under File System.";
        throw Throwables.propagate((Throwable)new IOException(err));
    }

    public boolean supportsPath(String path) {
        return path != null && path.startsWith("swift://");
    }

    private boolean checkSwiftCredentials(UnderFileSystemConfiguration conf) {
        if (conf.isSet(PropertyKey.SWIFT_SIMULATION) && Boolean.valueOf(conf.get(PropertyKey.SWIFT_SIMULATION)).booleanValue()) {
            return true;
        }
        PropertyKey apiOrPasswordKey = conf.isSet(PropertyKey.SWIFT_API_KEY) ? PropertyKey.SWIFT_API_KEY : PropertyKey.SWIFT_PASSWORD_KEY;
        return conf.isSet(apiOrPasswordKey) && conf.isSet(PropertyKey.SWIFT_TENANT_KEY) && conf.isSet(PropertyKey.SWIFT_AUTH_URL_KEY) && conf.isSet(PropertyKey.SWIFT_USER_KEY);
    }
}

