/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.swift;

import alluxio.AlluxioURI;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.FileDoesNotExistException;
import alluxio.underfs.ObjectUnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.options.OpenOptions;
import alluxio.underfs.swift.KeystoneV3AccessProvider;
import alluxio.underfs.swift.SwiftInputStream;
import alluxio.underfs.swift.SwiftMockOutputStream;
import alluxio.underfs.swift.http.SwiftDirectClient;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.io.PathUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.javaswift.joss.client.factory.AccountConfig;
import org.javaswift.joss.client.factory.AccountFactory;
import org.javaswift.joss.client.factory.AuthenticationMethod;
import org.javaswift.joss.exception.CommandException;
import org.javaswift.joss.model.Access;
import org.javaswift.joss.model.Account;
import org.javaswift.joss.model.Container;
import org.javaswift.joss.model.DirectoryOrObject;
import org.javaswift.joss.model.PaginationMap;
import org.javaswift.joss.model.StoredObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SwiftUnderFileSystem
extends ObjectUnderFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(SwiftUnderFileSystem.class);
    private static final String ACL_SEPARATOR_REGEXP = "\\s*,\\s*";
    private static final String FOLDER_SUFFIX = PATH_SEPARATOR;
    private static final int NUM_RETRIES = 3;
    private final Account mAccount;
    private final String mContainerName;
    private final Access mAccess;
    private boolean mSimulationMode;
    private String mAccountOwner;
    private short mAccountMode;

    public SwiftUnderFileSystem(AlluxioURI uri, UnderFileSystemConfiguration conf, AlluxioConfiguration alluxioConf) throws FileDoesNotExistException {
        super(uri, conf, alluxioConf);
        List<String> writeAcl;
        String containerName = UnderFileSystemUtils.getBucketName((AlluxioURI)uri);
        LOG.debug("Constructor init: {}", (Object)containerName);
        AccountConfig config = new AccountConfig();
        this.mSimulationMode = false;
        if (conf.isSet(PropertyKey.SWIFT_SIMULATION)) {
            this.mSimulationMode = Boolean.valueOf(conf.get(PropertyKey.SWIFT_SIMULATION));
        }
        if (this.mSimulationMode) {
            config.setMock(true);
            config.setMockAllowEveryone(true);
        } else {
            if (conf.isSet(PropertyKey.SWIFT_API_KEY)) {
                config.setPassword(conf.get(PropertyKey.SWIFT_API_KEY));
            } else if (conf.isSet(PropertyKey.SWIFT_PASSWORD_KEY)) {
                config.setPassword(conf.get(PropertyKey.SWIFT_PASSWORD_KEY));
            }
            config.setAuthUrl(conf.get(PropertyKey.SWIFT_AUTH_URL_KEY));
            String authMethod = conf.get(PropertyKey.SWIFT_AUTH_METHOD_KEY);
            if (authMethod != null) {
                config.setUsername(conf.get(PropertyKey.SWIFT_USER_KEY));
                config.setTenantName(conf.get(PropertyKey.SWIFT_TENANT_KEY));
                switch (authMethod) {
                    case "keystone": {
                        config.setAuthenticationMethod(AuthenticationMethod.KEYSTONE);
                        if (!conf.isSet(PropertyKey.SWIFT_REGION_KEY)) break;
                        config.setPreferredRegion(conf.get(PropertyKey.SWIFT_REGION_KEY));
                        break;
                    }
                    case "keystonev3": {
                        if (conf.isSet(PropertyKey.SWIFT_REGION_KEY)) {
                            config.setPreferredRegion(conf.get(PropertyKey.SWIFT_REGION_KEY));
                        }
                        config.setAuthenticationMethod(AuthenticationMethod.EXTERNAL);
                        KeystoneV3AccessProvider accessProvider = new KeystoneV3AccessProvider(config);
                        config.setAccessProvider((AuthenticationMethod.AccessProvider)accessProvider);
                        break;
                    }
                    case "swiftauth": {
                        config.setAuthenticationMethod(AuthenticationMethod.BASIC);
                        config.setTenantName(conf.get(PropertyKey.SWIFT_USER_KEY));
                        config.setUsername(conf.get(PropertyKey.SWIFT_TENANT_KEY));
                        break;
                    }
                    default: {
                        config.setAuthenticationMethod(AuthenticationMethod.TEMPAUTH);
                        config.setTenantName(conf.get(PropertyKey.SWIFT_USER_KEY));
                        config.setUsername(conf.get(PropertyKey.SWIFT_TENANT_KEY));
                    }
                }
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
        this.mContainerName = containerName;
        this.mAccount = new AccountFactory(config).createAccount();
        this.mAccount.setAllowContainerCaching(false);
        this.mAccess = this.mAccount.authenticate();
        Container container = this.mAccount.getContainer(containerName);
        if (!container.exists()) {
            throw new FileDoesNotExistException(ExceptionMessage.PATH_DOES_NOT_EXIST.getMessage(new Object[]{"Container %s does not exist", containerName}));
        }
        this.mAccountOwner = conf.get(PropertyKey.SWIFT_USER_KEY);
        int mode = 0;
        List<String> readAcl = Arrays.asList(container.getContainerReadPermission().split(ACL_SEPARATOR_REGEXP));
        if (readAcl.contains(this.mAccountOwner) || readAcl.contains("*") || readAcl.contains(".r:*")) {
            mode = (short)(mode | 0x140);
        }
        if ((writeAcl = Arrays.asList(container.getcontainerWritePermission().split(ACL_SEPARATOR_REGEXP))).contains(this.mAccountOwner) || writeAcl.contains("*") || writeAcl.contains(".w:*")) {
            mode = (short)(mode | 0x80);
        }
        if (mode == 0 && this.mAccess.getToken() != null) {
            mode = 448;
        }
        this.mAccountMode = (short)mode;
    }

    public String getUnderFSType() {
        return "swift";
    }

    public void setOwner(String path, String user, String group) {
    }

    public void setMode(String path, short mode) throws IOException {
    }

    protected boolean copyObject(String source, String destination) {
        LOG.debug("copy from {} to {}", (Object)source, (Object)destination);
        for (int i = 0; i < 3; ++i) {
            try {
                Container container = this.mAccount.getContainer(this.mContainerName);
                container.getObject(source).copyObject(container, container.getObject(destination));
                return true;
            }
            catch (CommandException e) {
                LOG.error("Source path {} does not exist", (Object)source);
                return false;
            }
            catch (Exception e) {
                LOG.error("Failed to copy file {} to {}", new Object[]{source, destination, e.getMessage()});
                if (i == 2) continue;
                LOG.error("Retrying copying file {} to {}", (Object)source, (Object)destination);
                continue;
            }
        }
        LOG.error("Failed to copy file {} to {}, after {} retries", new Object[]{source, destination, 3});
        return false;
    }

    protected boolean createEmptyObject(String key) {
        try {
            Container container = this.mAccount.getContainer(this.mContainerName);
            StoredObject object = container.getObject(key);
            object.uploadObject(new byte[0]);
            return true;
        }
        catch (CommandException e) {
            LOG.error("Failed to create object: {}", (Object)key, (Object)e);
            return false;
        }
    }

    protected OutputStream createObject(String key) throws IOException {
        if (this.mSimulationMode) {
            return new SwiftMockOutputStream(this.mAccount, this.mContainerName, key, this.mAlluxioConf.getList(PropertyKey.TMP_DIRS, ","));
        }
        return SwiftDirectClient.put(this.mAccess, PathUtils.concatPath((Object)PathUtils.normalizePath((String)this.mContainerName, (String)PATH_SEPARATOR), (Object)key));
    }

    protected boolean deleteObject(String path) throws IOException {
        try {
            Container container = this.mAccount.getContainer(this.mContainerName);
            StoredObject object = container.getObject(path);
            if (object != null) {
                object.delete();
                return true;
            }
        }
        catch (CommandException e) {
            LOG.debug("Object {} not found", (Object)path);
        }
        return false;
    }

    protected String getFolderSuffix() {
        return FOLDER_SUFFIX;
    }

    protected ObjectUnderFileSystem.ObjectListingChunk getObjectListingChunk(String key, boolean recursive) throws IOException {
        String prefix;
        Container container = this.mAccount.getContainer(this.mContainerName);
        PaginationMap paginationMap = container.getPaginationMap(prefix = (prefix = PathUtils.normalizePath((String)key, (String)PATH_SEPARATOR)).equals(PATH_SEPARATOR) ? "" : prefix, this.getListingChunkLength(this.mAlluxioConf));
        if (paginationMap != null && paginationMap.getNumberOfPages() > 0) {
            return new SwiftObjectListingChunk(paginationMap, 0, recursive);
        }
        return null;
    }

    protected ObjectUnderFileSystem.ObjectStatus getObjectStatus(String key) {
        Container container = this.mAccount.getContainer(this.mContainerName);
        StoredObject meta = container.getObject(key);
        if (meta != null && meta.exists()) {
            return new ObjectUnderFileSystem.ObjectStatus((ObjectUnderFileSystem)this, key, meta.getEtag(), meta.getContentLength(), meta.getLastModifiedAsDate().getTime());
        }
        return null;
    }

    protected ObjectUnderFileSystem.ObjectPermissions getPermissions() {
        return new ObjectUnderFileSystem.ObjectPermissions((ObjectUnderFileSystem)this, this.mAccountOwner, this.mAccountOwner, this.mAccountMode);
    }

    protected String getRootKey() {
        return "swift://" + this.mContainerName + PATH_SEPARATOR;
    }

    protected InputStream openObject(String key, OpenOptions options) throws IOException {
        return new SwiftInputStream(this.mAccount, this.mContainerName, key, options.getOffset(), this.mAlluxioConf.getBytes(PropertyKey.UNDERFS_OBJECT_STORE_MULTI_RANGE_CHUNK_SIZE));
    }

    private final class SwiftObjectListingChunk
    implements ObjectUnderFileSystem.ObjectListingChunk {
        final PaginationMap mPaginationMap;
        final int mPage;
        final boolean mRecursive;

        SwiftObjectListingChunk(PaginationMap paginationMap, int page, boolean recursive) {
            this.mPaginationMap = paginationMap;
            this.mPage = page;
            this.mRecursive = recursive;
        }

        public ObjectUnderFileSystem.ObjectStatus[] getObjectStatuses() {
            ArrayDeque objects = new ArrayDeque();
            Container container = SwiftUnderFileSystem.this.mAccount.getContainer(SwiftUnderFileSystem.this.mContainerName);
            if (!this.mRecursive) {
                objects.addAll(container.listDirectory(this.mPaginationMap.getPrefix(), Character.valueOf('/'), this.mPaginationMap.getMarker(Integer.valueOf(this.mPage)), this.mPaginationMap.getPageSize()));
            } else {
                objects.addAll(container.list(this.mPaginationMap, this.mPage));
            }
            int i = 0;
            ObjectUnderFileSystem.ObjectStatus[] res = new ObjectUnderFileSystem.ObjectStatus[objects.size()];
            for (DirectoryOrObject object : objects) {
                if (object.isObject()) {
                    res[i++] = new ObjectUnderFileSystem.ObjectStatus((ObjectUnderFileSystem)SwiftUnderFileSystem.this, object.getName(), object.getAsObject().getEtag(), object.getAsObject().getContentLength(), object.getAsObject().getLastModifiedAsDate().getTime());
                    continue;
                }
                res[i++] = new ObjectUnderFileSystem.ObjectStatus((ObjectUnderFileSystem)SwiftUnderFileSystem.this, object.getName());
            }
            return res;
        }

        public String[] getCommonPrefixes() {
            return new String[0];
        }

        public ObjectUnderFileSystem.ObjectListingChunk getNextChunk() throws IOException {
            int nextPage = this.mPage + 1;
            if (nextPage >= this.mPaginationMap.getNumberOfPages()) {
                return null;
            }
            return new SwiftObjectListingChunk(this.mPaginationMap, nextPage, this.mRecursive);
        }
    }
}

