/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.swift;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class SwiftOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(SwiftOutputStream.class);
    private OutputStream mOutputStream;
    private HttpURLConnection mHttpCon;

    public SwiftOutputStream(HttpURLConnection httpCon) throws IOException {
        try {
            this.mOutputStream = httpCon.getOutputStream();
            this.mHttpCon = httpCon;
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            throw new IOException(e);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.mOutputStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.mOutputStream.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.mOutputStream.write(b);
    }

    @Override
    public void close() throws IOException {
        block4: {
            this.mOutputStream.close();
            InputStream is = null;
            try {
                if (this.mHttpCon.getResponseCode() >= 400) {
                    LOG.error("Failed to write data to Swift with error code: " + this.mHttpCon.getResponseCode());
                    is = this.mHttpCon.getErrorStream();
                } else {
                    is = this.mHttpCon.getInputStream();
                }
                is.close();
            }
            catch (Exception e) {
                LOG.error(e.getMessage());
                if (is == null) break block4;
                is.close();
            }
        }
        this.mHttpCon.disconnect();
    }

    @Override
    public void flush() throws IOException {
        this.mOutputStream.flush();
    }
}

