/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.swift;

import alluxio.util.CommonUtils;
import alluxio.util.io.PathUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.UUID;
import javax.annotation.concurrent.NotThreadSafe;
import org.javaswift.joss.model.Account;
import org.javaswift.joss.model.Container;
import org.javaswift.joss.model.StoredObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class SwiftMockOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(SwiftMockOutputStream.class);
    private final File mFile;
    private final OutputStream mOutputStream;
    private final String mObjectName;
    private final Account mAccount;
    private final String mContainerName;
    private boolean mClosed = false;

    public SwiftMockOutputStream(Account account, String containerName, String objectName, List<String> tmpDirs) throws IOException {
        try {
            this.mAccount = account;
            this.mContainerName = containerName;
            this.mObjectName = objectName;
            this.mFile = new File(PathUtils.concatPath((Object)CommonUtils.getTmpDir(tmpDirs), (Object)UUID.randomUUID()));
            this.mOutputStream = new BufferedOutputStream(new FileOutputStream(this.mFile));
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            throw new IOException(e);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.mOutputStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.mOutputStream.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.mOutputStream.write(b);
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mOutputStream.close();
        try {
            Container container = this.mAccount.getContainer(this.mContainerName);
            StoredObject object = container.getObject(this.mObjectName);
            object.uploadObject(this.mFile);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.mClosed = true;
    }

    @Override
    public void flush() throws IOException {
        this.mOutputStream.flush();
    }
}

