/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.swift;

import alluxio.underfs.MultiRangeObjectInputStream;
import alluxio.underfs.swift.MidPartLongRange;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;
import org.javaswift.joss.headers.object.range.AbstractRange;
import org.javaswift.joss.instructions.DownloadInstructions;
import org.javaswift.joss.model.Account;
import org.javaswift.joss.model.StoredObject;

@NotThreadSafe
public class SwiftInputStream
extends MultiRangeObjectInputStream {
    private final Account mAccount;
    private final String mContainerName;
    private final String mObjectPath;

    public SwiftInputStream(Account account, String container, String object, long multiRangeChunkSize) {
        this(account, container, object, 0L, multiRangeChunkSize);
    }

    public SwiftInputStream(Account account, String container, String object, long position, long multiRangeChunkSize) {
        super(multiRangeChunkSize);
        this.mAccount = account;
        this.mContainerName = container;
        this.mObjectPath = object;
        this.mPos = position;
    }

    protected InputStream createStream(long startPos, long endPos) throws IOException {
        StoredObject storedObject = this.mAccount.getContainer(this.mContainerName).getObject(this.mObjectPath);
        DownloadInstructions downloadInstructions = new DownloadInstructions();
        downloadInstructions.setRange((AbstractRange)new MidPartLongRange(startPos, endPos - 1L));
        return storedObject.downloadObjectAsInputStream(downloadInstructions);
    }
}

