/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.cephfshadoop;

import alluxio.AlluxioURI;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.cephfshadoop.CephfsHadoopUnderFileSystem;
import alluxio.underfs.hdfs.HdfsUnderFileSystemFactory;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CephfsHadoopUnderFileSystemFactory
extends HdfsUnderFileSystemFactory {
    public UnderFileSystem create(String path, UnderFileSystemConfiguration conf) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        return CephfsHadoopUnderFileSystem.createInstance(new AlluxioURI(path), conf);
    }

    public boolean supportsPath(String path) {
        return path != null && path.startsWith("ceph://");
    }

    public boolean supportsPath(String path, UnderFileSystemConfiguration conf) {
        return this.supportsPath(path);
    }
}

