/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.table.command;

import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.table.command.AbstractTableCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.client.table.TableMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class TransformTableCommand
extends AbstractTableCommand {
    private static final Logger LOG = LoggerFactory.getLogger(TransformTableCommand.class);
    private static final String COMMAND_NAME = "transform";
    private static final Option DEFINITION_OPTION = Option.builder((String)"d").longOpt("definition").required(false).hasArg(true).numberOfArgs(1).build();

    public TransformTableCommand(AlluxioConfiguration conf, TableMasterClient client, FileSystemContext fsContext) {
        super(conf, client, fsContext);
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    public String getUsage() {
        return "transform <db name> <table name> [-d <definition>]";
    }

    public Options getOptions() {
        return new Options().addOption(DEFINITION_OPTION);
    }

    public String getDescription() {
        return "Transform files representing a structured table under an Alluxio directory.\n\nFiles are coalesced and converted to parquet format.\n";
    }

    @Override
    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)2);
    }

    @Override
    public int run(CommandLine cl) throws IOException, AlluxioException {
        String optDefinition;
        String[] args = cl.getArgs();
        String databaseName = args[0];
        String tableName = args[1];
        String definition = "";
        if (cl.hasOption(DEFINITION_OPTION.getLongOpt()) && (optDefinition = cl.getOptionValue(DEFINITION_OPTION.getLongOpt())) != null && !optDefinition.isEmpty()) {
            definition = optDefinition.trim();
        }
        long jobId = this.mClient.transformTable(databaseName, tableName, definition);
        System.out.println("Started transformation job with job ID " + jobId + ", you can monitor the status of the job with './bin/alluxio table transformStatus " + jobId + "'.");
        return 0;
    }
}

