/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.table.command;

import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.table.command.AbstractTableCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.client.table.TableMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.table.TransformJobInfo;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class TransformStatusCommand
extends AbstractTableCommand {
    private static final Logger LOG = LoggerFactory.getLogger(TransformStatusCommand.class);
    private static final String COMMAND_NAME = "transformStatus";

    public TransformStatusCommand(AlluxioConfiguration conf, TableMasterClient client, FileSystemContext fsContext) {
        super(conf, client, fsContext);
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    public String getUsage() {
        return "transformStatus [<job ID>]";
    }

    public String getDescription() {
        return "Check status of transformations.";
    }

    @Override
    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsNoMoreThan((Command)this, (CommandLine)cl, (int)1);
    }

    private String toString(TransformJobInfo info) {
        StringBuilder sb = new StringBuilder();
        sb.append("database: ").append(info.getDbName()).append("\n");
        sb.append("table: ").append(info.getTableName()).append("\n");
        sb.append("transformation: ").append(info.getDefinition()).append("\n");
        sb.append("job ID: ").append(info.getJobId()).append("\n");
        sb.append("job status: ").append(info.getJobStatus()).append("\n");
        if (!info.getJobError().isEmpty()) {
            sb.append("job error: ").append(info.getJobError());
        }
        return sb.toString();
    }

    @Override
    public int run(CommandLine cl) throws IOException, AlluxioException {
        String[] args = cl.getArgs();
        if (args.length == 0) {
            for (TransformJobInfo info : this.mClient.getAllTransformJobInfo()) {
                System.out.println(this.toString(info));
                System.out.println();
            }
        } else {
            long jobId = Long.parseLong(args[0]);
            TransformJobInfo info = this.mClient.getTransformJobInfo(jobId);
            System.out.println(this.toString(info));
        }
        return 0;
    }
}

