/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.table.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractDistributedJobCommand;
import alluxio.cli.fs.command.DistributedLoadUtils;
import alluxio.cli.table.command.AbstractTableCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.client.table.TableMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.table.common.CatalogPathUtils;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

@ThreadSafe
public class LoadTableCommand
extends AbstractTableCommand {
    public LoadTableCommand(AlluxioConfiguration conf, TableMasterClient client, FileSystemContext fsContext) {
        super(conf, client, fsContext);
    }

    public String getUsage() {
        return "load  " + DistributedLoadUtils.getDistLoadCommonUsage() + "<db name> <table name>";
    }

    @Override
    public String getCommandName() {
        return "load";
    }

    public String getDescription() {
        return "Loads table into Alluxio space. Currently only support hive table.";
    }

    public Options getOptions() {
        return DistributedLoadUtils.getDistLoadCommonOptions();
    }

    @Override
    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)2);
    }

    @Override
    public int run(CommandLine cl) throws AlluxioException, IOException {
        System.out.println("***Tips\uff1aLoad table command only support hive table for now.***");
        String[] args = cl.getArgs();
        String dbName = args[0];
        String tableName = args[1];
        if (!this.tableExists(dbName, tableName)) {
            System.out.printf("Failed to load table %s.%s: table is not exit.%n", dbName, tableName);
            return 0;
        }
        String udbType = "hive";
        AlluxioURI path = CatalogPathUtils.getTablePathUdb((String)dbName, (String)tableName, (String)udbType);
        System.out.printf("Loading table %s.%s...%n", dbName, tableName);
        return DistributedLoadUtils.distributedLoad((AbstractDistributedJobCommand)this, (CommandLine)cl, (String)path.getPath());
    }

    private boolean tableExists(String dbName, String tableName) {
        try {
            this.mClient.getTable(dbName, tableName);
            return true;
        }
        catch (AlluxioStatusException e) {
            return false;
        }
    }
}

