/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.table.command;

import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.table.TableShellUtils;
import alluxio.cli.table.command.AbstractTableCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.client.table.TableMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.table.SyncStatus;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachDatabaseCommand
extends AbstractTableCommand {
    private static final Logger LOG = LoggerFactory.getLogger(AttachDatabaseCommand.class);
    private static final int PRINT_MAX_ERRORS = 10;
    private static final String COMMAND_NAME = "attachdb";
    private static final Option OPTION_OPTION = Option.builder((String)"o").longOpt("option").required(false).hasArg(true).numberOfArgs(2).argName("key=value").valueSeparator('=').desc("options associated with this database or UDB").build();
    private static final Option DB_OPTION = Option.builder().longOpt("db").required(false).hasArg(true).numberOfArgs(1).argName("alluxio db name").desc("The name of the db in Alluxio. If unset, will use the udb db name.").build();
    private static final Option IGNORE_SYNC_ERRORS_OPTION = Option.builder().longOpt("ignore-sync-errors").required(false).hasArg(false).desc("Ignores sync errors, and keeps the database attached.").build();

    public AttachDatabaseCommand(AlluxioConfiguration conf, TableMasterClient client, FileSystemContext fsContext) {
        super(conf, client, fsContext);
    }

    public Options getOptions() {
        return new Options().addOption(OPTION_OPTION).addOption(DB_OPTION).addOption(IGNORE_SYNC_ERRORS_OPTION);
    }

    @Override
    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)3);
    }

    @Override
    public int run(CommandLine cl) throws AlluxioStatusException {
        String optDbName;
        String udbDbName;
        String[] args = cl.getArgs();
        String udbType = args[0];
        String udbConnectionUri = args[1];
        String dbName = udbDbName = args[2];
        if (cl.hasOption(DB_OPTION.getLongOpt()) && (optDbName = cl.getOptionValue(DB_OPTION.getLongOpt())) != null && !optDbName.isEmpty()) {
            dbName = optDbName;
        }
        Properties p = cl.getOptionProperties(OPTION_OPTION.getOpt());
        boolean ignoreSyncErrors = cl.hasOption(IGNORE_SYNC_ERRORS_OPTION.getLongOpt());
        SyncStatus status = this.mClient.attachDatabase(udbType, udbConnectionUri, udbDbName, dbName, (Map)Maps.fromProperties((Properties)p), ignoreSyncErrors);
        TableShellUtils.printSyncStatus(status, LOG, 10);
        if (!ignoreSyncErrors && status.getTablesErrorsCount() > 0) {
            System.out.println(String.format("%nDatabase is not attached. To keep it attached even with errors, please re-run '%s' with the '--%s' option.", COMMAND_NAME, IGNORE_SYNC_ERRORS_OPTION.getLongOpt()));
        }
        return 0;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    public String getDescription() {
        return "Attaches a database to the Alluxio catalog from an under DB";
    }

    public String getUsage() {
        return "attachdb [-o|--option <key=value>] [--db <alluxio db name>] [--ignore-sync-errors] <udb type> <udb connection uri> <udb db name>";
    }
}

