/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.table.command;

import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.table.command.AbstractTableCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.client.table.TableMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.table.Constraint;
import alluxio.grpc.table.TableInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;

public class ListDatabasesCommand
extends AbstractTableCommand {
    public ListDatabasesCommand(AlluxioConfiguration conf, TableMasterClient client, FileSystemContext fsContext) {
        super(conf, client, fsContext);
    }

    @Override
    public String getCommandName() {
        return "ls";
    }

    public String getDescription() {
        return "list information about attached databases";
    }

    public String getUsage() {
        return "ls [<db name> [<table name>]]";
    }

    @Override
    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsNoMoreThan((Command)this, (CommandLine)cl, (int)2);
    }

    @Override
    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        switch (args.length) {
            case 0: {
                return this.listDatabases();
            }
            case 1: {
                return this.listTables(args[0]);
            }
            case 2: {
                return this.listTable(args[0], args[1]);
            }
        }
        return 1;
    }

    public int listDatabases() throws AlluxioStatusException, IOException {
        this.sortAndPrint(new ArrayList<String>(this.mClient.getAllDatabases()));
        return 0;
    }

    public int listTables(String db) throws AlluxioStatusException {
        this.sortAndPrint(new ArrayList<String>(this.mClient.getAllTables(db)));
        return 0;
    }

    private void sortAndPrint(List<String> items) {
        items.sort(String::compareTo);
        items.forEach(System.out::println);
    }

    public int listTable(String db, String tableName) throws AlluxioStatusException {
        TableInfo table = this.mClient.getTable(db, tableName);
        System.out.println(table);
        List partitionList = this.mClient.readTable(db, tableName, Constraint.getDefaultInstance());
        partitionList.forEach(System.out::println);
        return 0;
    }
}

