/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.table.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.table.command.AbstractTableCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.client.table.TableMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.util.io.PathUtils;
import org.apache.commons.cli.CommandLine;

public class DetachDatabaseCommand
extends AbstractTableCommand {
    public DetachDatabaseCommand(AlluxioConfiguration conf, TableMasterClient client, FileSystemContext fsContext) {
        super(conf, client, fsContext);
    }

    @Override
    public void validateArgs(CommandLine cli) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cli, (int)1);
    }

    @Override
    public String getCommandName() {
        return "detachdb";
    }

    public String getUsage() {
        return "detachdb <db name>";
    }

    public String getDescription() {
        return "Detach a database with the given name from the Alluxio catalog master's namespace";
    }

    @Override
    public int run(CommandLine cli) throws AlluxioStatusException {
        String dbName = cli.getArgs()[0];
        if (this.mClient.detachDatabase(dbName)) {
            AlluxioURI path = new AlluxioURI(PathUtils.concatPath((Object)this.mConf.get(PropertyKey.TABLE_CATALOG_PATH), (Object)dbName));
            System.out.println("Successfully detached db " + dbName + ". Please unmount and clean up the alluxio location at " + path + " before attaching another database named " + dbName);
        }
        return 0;
    }
}

