/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.table;

import alluxio.grpc.table.SyncStatus;
import java.util.Map;
import org.slf4j.Logger;

public class TableShellUtils {
    private static final String SHELL_NAME = "table";

    private TableShellUtils() {
    }

    public static void printSyncStatus(SyncStatus status, Logger logger, int maxErrors) {
        System.out.println("# Tables ignored: " + status.getTablesIgnoredCount());
        System.out.println("# Tables unchanged: " + status.getTablesUnchangedCount());
        System.out.println("# Tables updated: " + status.getTablesUpdatedCount());
        System.out.println("# Tables removed: " + status.getTablesRemovedCount());
        System.out.println("# Tables with errors: " + status.getTablesErrorsCount());
        for (String table : status.getTablesIgnoredList()) {
            logger.info("Table ignored: {}", (Object)table);
        }
        for (String table : status.getTablesUnchangedList()) {
            logger.info("Table unchanged: {}", (Object)table);
        }
        for (String table : status.getTablesUpdatedList()) {
            logger.info("Table updated: {}", (Object)table);
        }
        for (String table : status.getTablesRemovedList()) {
            logger.info("Table removed: {}", (Object)table);
        }
        if (status.getTablesErrorsCount() > 0) {
            System.out.println("\nSync errors: ");
        }
        int count = 0;
        for (Map.Entry entry : status.getTablesErrorsMap().entrySet()) {
            String message = String.format("Table %s failed to sync: %s", entry.getKey(), entry.getValue());
            if (count < maxErrors) {
                System.out.println(message);
            } else if (count == maxErrors) {
                System.out.println("... (remaining can be found in the log)");
            }
            logger.error(message);
            ++count;
        }
    }
}

