/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.under.hive;

import alluxio.grpc.table.BinaryColumnStatsData;
import alluxio.grpc.table.BooleanColumnStatsData;
import alluxio.grpc.table.ColumnStatisticsInfo;
import alluxio.grpc.table.DoubleColumnStatsData;
import alluxio.table.under.hive.HiveUtils;
import alluxio.util.CommonUtils;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Date;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.junit.Assert;
import org.junit.Test;

public class HiveUtilsTest {
    private Random mRandom = ThreadLocalRandom.current();

    @Test
    public void protoColStatsNoData() {
        ColumnStatisticsObj hiveColStats = new ColumnStatisticsObj();
        hiveColStats.setColName("colName");
        hiveColStats.setColType("colType");
        this.verifyColumnStats(hiveColStats);
    }

    @Test
    public void protoColStatsWithBinaryData() {
        ColumnStatisticsObj hiveColStats = new ColumnStatisticsObj();
        hiveColStats.setColName("colName");
        hiveColStats.setColType("colType");
        ColumnStatisticsData data = new ColumnStatisticsData();
        org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData binaryData = new org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData();
        data.setBinaryStats(binaryData);
        hiveColStats.setStatsData(data);
        this.verifyColumnStats(hiveColStats);
        binaryData.setAvgColLen(this.mRandom.nextDouble());
        binaryData.setBitVectors(CommonUtils.randomAlphaNumString((int)5));
        binaryData.setMaxColLen(this.mRandom.nextLong());
        binaryData.setNumNulls(this.mRandom.nextLong());
        data.setBinaryStats(binaryData);
        hiveColStats.setStatsData(data);
        this.verifyColumnStats(hiveColStats);
    }

    @Test
    public void protoColStatsWithBooleanData() {
        ColumnStatisticsObj hiveColStats = new ColumnStatisticsObj();
        hiveColStats.setColName("colName");
        hiveColStats.setColType("colType");
        ColumnStatisticsData data = new ColumnStatisticsData();
        org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData booleanData = new org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData();
        data.setBooleanStats(booleanData);
        hiveColStats.setStatsData(data);
        this.verifyColumnStats(hiveColStats);
        booleanData.setBitVectors(CommonUtils.randomAlphaNumString((int)5));
        booleanData.setNumNulls(this.mRandom.nextLong());
        booleanData.setNumFalses(this.mRandom.nextLong());
        booleanData.setNumTrues(this.mRandom.nextLong());
        data.setBooleanStats(booleanData);
        hiveColStats.setStatsData(data);
        this.verifyColumnStats(hiveColStats);
    }

    @Test
    public void protoColStatsWithDateData() {
        ColumnStatisticsObj hiveColStats = new ColumnStatisticsObj();
        hiveColStats.setColName("colName");
        hiveColStats.setColType("colType");
        ColumnStatisticsData data = new ColumnStatisticsData();
        DateColumnStatsData dateData = new DateColumnStatsData();
        data.setDateStats(dateData);
        hiveColStats.setStatsData(data);
        this.verifyColumnStats(hiveColStats);
        dateData.setBitVectors(CommonUtils.randomAlphaNumString((int)5));
        dateData.setNumNulls(this.mRandom.nextLong());
        dateData.setHighValue(new Date(this.mRandom.nextLong()));
        dateData.setLowValue(new Date(this.mRandom.nextLong()));
        dateData.setNumDVs(this.mRandom.nextLong());
        data.setDateStats(dateData);
        hiveColStats.setStatsData(data);
        this.verifyColumnStats(hiveColStats);
        dateData.setHighValue(null);
        dateData.setLowValue(null);
        data.setDateStats(dateData);
        hiveColStats.setStatsData(data);
        this.verifyColumnStats(hiveColStats);
    }

    @Test
    public void protoColStatsWithDecimalData() {
        ColumnStatisticsObj hiveColStats = new ColumnStatisticsObj();
        hiveColStats.setColName("colName");
        hiveColStats.setColType("colType");
        ColumnStatisticsData data = new ColumnStatisticsData();
        DecimalColumnStatsData decimalData = new DecimalColumnStatsData();
        data.setDecimalStats(decimalData);
        hiveColStats.setStatsData(data);
        this.verifyColumnStats(hiveColStats);
        decimalData.setBitVectors(CommonUtils.randomAlphaNumString((int)5));
        decimalData.setNumNulls(this.mRandom.nextLong());
        decimalData.setHighValue(new Decimal(ByteBuffer.wrap(CommonUtils.randomBytes((int)5)), (short)this.mRandom.nextInt()));
        decimalData.setLowValue(new Decimal(ByteBuffer.wrap(CommonUtils.randomBytes((int)5)), (short)this.mRandom.nextInt()));
        decimalData.setNumDVs(this.mRandom.nextLong());
        data.setDecimalStats(decimalData);
        hiveColStats.setStatsData(data);
        this.verifyColumnStats(hiveColStats);
        decimalData.setHighValue(null);
        decimalData.setLowValue(null);
        data.setDecimalStats(decimalData);
        hiveColStats.setStatsData(data);
        this.verifyColumnStats(hiveColStats);
    }

    @Test
    public void protoColStatsWithDoubleData() {
        ColumnStatisticsObj hiveColStats = new ColumnStatisticsObj();
        hiveColStats.setColName("colName");
        hiveColStats.setColType("colType");
        ColumnStatisticsData data = new ColumnStatisticsData();
        org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData doubleData = new org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData();
        data.setDoubleStats(doubleData);
        hiveColStats.setStatsData(data);
        this.verifyColumnStats(hiveColStats);
        doubleData.setBitVectors(CommonUtils.randomAlphaNumString((int)5));
        doubleData.setNumNulls(this.mRandom.nextLong());
        doubleData.setHighValue(this.mRandom.nextDouble());
        doubleData.setLowValue(this.mRandom.nextDouble());
        doubleData.setNumDVs(this.mRandom.nextLong());
        data.setDoubleStats(doubleData);
        hiveColStats.setStatsData(data);
        this.verifyColumnStats(hiveColStats);
    }

    @Test
    public void protoColStatsWithLongData() {
        ColumnStatisticsObj hiveColStats = new ColumnStatisticsObj();
        hiveColStats.setColName("colName");
        hiveColStats.setColType("colType");
        ColumnStatisticsData data = new ColumnStatisticsData();
        LongColumnStatsData longData = new LongColumnStatsData();
        data.setLongStats(longData);
        hiveColStats.setStatsData(data);
        this.verifyColumnStats(hiveColStats);
        longData.setBitVectors(CommonUtils.randomAlphaNumString((int)5));
        longData.setNumNulls(this.mRandom.nextLong());
        longData.setHighValue(this.mRandom.nextLong());
        longData.setLowValue(this.mRandom.nextLong());
        longData.setNumDVs(this.mRandom.nextLong());
        data.setLongStats(longData);
        hiveColStats.setStatsData(data);
        this.verifyColumnStats(hiveColStats);
    }

    @Test
    public void protoColStatsWithStringData() {
        ColumnStatisticsObj hiveColStats = new ColumnStatisticsObj();
        hiveColStats.setColName("colName");
        hiveColStats.setColType("colType");
        ColumnStatisticsData data = new ColumnStatisticsData();
        StringColumnStatsData stringData = new StringColumnStatsData();
        data.setStringStats(stringData);
        hiveColStats.setStatsData(data);
        this.verifyColumnStats(hiveColStats);
        stringData.setBitVectors(CommonUtils.randomAlphaNumString((int)5));
        stringData.setNumNulls(this.mRandom.nextLong());
        stringData.setNumDVs(this.mRandom.nextLong());
        stringData.setAvgColLen(this.mRandom.nextDouble());
        stringData.setMaxColLen(this.mRandom.nextLong());
        data.setStringStats(stringData);
        hiveColStats.setStatsData(data);
        this.verifyColumnStats(hiveColStats);
    }

    private void verifyColumnStats(ColumnStatisticsObj hiveColStats) {
        ColumnStatisticsInfo colStats = HiveUtils.toProto((ColumnStatisticsObj)hiveColStats);
        Assert.assertEquals((Object)hiveColStats.getColName(), (Object)colStats.getColName());
        Assert.assertEquals((Object)hiveColStats.getColType(), (Object)colStats.getColType());
        Assert.assertEquals((Object)hiveColStats.isSetStatsData(), (Object)colStats.hasData());
        if (hiveColStats.isSetStatsData()) {
            DoubleColumnStatsData dbl;
            ColumnStatisticsData hiveData = hiveColStats.getStatsData();
            alluxio.grpc.table.ColumnStatisticsData data = colStats.getData();
            Assert.assertEquals((Object)hiveData.isSetBinaryStats(), (Object)data.hasBinaryStats());
            if (hiveData.isSetBinaryStats()) {
                org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData hiveBinary = hiveData.getBinaryStats();
                BinaryColumnStatsData binary = data.getBinaryStats();
                Assert.assertEquals((Object)hiveBinary.isSetBitVectors(), (Object)binary.hasBitVectors());
                if (hiveBinary.isSetBitVectors()) {
                    Assert.assertEquals((Object)hiveBinary.getBitVectors(), (Object)binary.getBitVectors());
                }
                Assert.assertEquals((double)hiveBinary.getAvgColLen(), (double)binary.getAvgColLen(), (double)0.01);
                Assert.assertEquals((long)hiveBinary.getMaxColLen(), (long)binary.getMaxColLen());
                Assert.assertEquals((long)hiveBinary.getNumNulls(), (long)binary.getNumNulls());
            }
            Assert.assertEquals((Object)hiveData.isSetBooleanStats(), (Object)data.hasBooleanStats());
            if (hiveData.isSetBooleanStats()) {
                org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData hiveBoolean = hiveData.getBooleanStats();
                BooleanColumnStatsData bool = data.getBooleanStats();
                Assert.assertEquals((Object)hiveBoolean.isSetBitVectors(), (Object)bool.hasBitVectors());
                if (hiveBoolean.isSetBitVectors()) {
                    Assert.assertEquals((Object)hiveBoolean.getBitVectors(), (Object)bool.getBitVectors());
                }
                Assert.assertEquals((long)hiveBoolean.getNumFalses(), (long)bool.getNumFalses());
                Assert.assertEquals((long)hiveBoolean.getNumTrues(), (long)bool.getNumTrues());
                Assert.assertEquals((long)hiveBoolean.getNumNulls(), (long)bool.getNumNulls());
            }
            Assert.assertEquals((Object)hiveData.isSetDateStats(), (Object)data.hasDateStats());
            if (hiveData.isSetDateStats()) {
                DateColumnStatsData hiveDate = hiveData.getDateStats();
                alluxio.grpc.table.DateColumnStatsData date = data.getDateStats();
                Assert.assertEquals((Object)hiveDate.isSetBitVectors(), (Object)date.hasBitVectors());
                if (hiveDate.isSetBitVectors()) {
                    Assert.assertEquals((Object)hiveDate.getBitVectors(), (Object)date.getBitVectors());
                }
                Assert.assertEquals((long)hiveDate.getNumNulls(), (long)date.getNumNulls());
                Assert.assertEquals((long)hiveDate.getNumDVs(), (long)date.getNumDistincts());
                Assert.assertEquals((Object)hiveDate.isSetHighValue(), (Object)date.hasHighValue());
                if (hiveDate.isSetHighValue()) {
                    Assert.assertEquals((long)hiveDate.getHighValue().getDaysSinceEpoch(), (long)date.getHighValue().getDaysSinceEpoch());
                }
                Assert.assertEquals((Object)hiveDate.isSetLowValue(), (Object)date.hasLowValue());
                if (hiveDate.isSetLowValue()) {
                    Assert.assertEquals((long)hiveDate.getLowValue().getDaysSinceEpoch(), (long)date.getLowValue().getDaysSinceEpoch());
                }
            }
            Assert.assertEquals((Object)hiveData.isSetDecimalStats(), (Object)data.hasDecimalStats());
            if (hiveData.isSetDecimalStats()) {
                DecimalColumnStatsData hiveDecimal = hiveData.getDecimalStats();
                alluxio.grpc.table.DecimalColumnStatsData decimal = data.getDecimalStats();
                Assert.assertEquals((Object)hiveDecimal.isSetBitVectors(), (Object)decimal.hasBitVectors());
                if (hiveDecimal.isSetBitVectors()) {
                    Assert.assertEquals((Object)hiveDecimal.getBitVectors(), (Object)decimal.getBitVectors());
                }
                Assert.assertEquals((long)hiveDecimal.getNumNulls(), (long)decimal.getNumNulls());
                Assert.assertEquals((long)hiveDecimal.getNumDVs(), (long)decimal.getNumDistincts());
                Assert.assertEquals((Object)hiveDecimal.isSetHighValue(), (Object)decimal.hasHighValue());
                if (hiveDecimal.isSetHighValue()) {
                    Assert.assertEquals((long)hiveDecimal.getHighValue().getScale(), (long)decimal.getHighValue().getScale());
                    Assert.assertArrayEquals((byte[])hiveDecimal.getHighValue().getUnscaled(), (byte[])decimal.getHighValue().getUnscaled().toByteArray());
                }
                Assert.assertEquals((Object)hiveDecimal.isSetLowValue(), (Object)decimal.hasLowValue());
                if (hiveDecimal.isSetLowValue()) {
                    Assert.assertEquals((long)hiveDecimal.getLowValue().getScale(), (long)decimal.getLowValue().getScale());
                    Assert.assertArrayEquals((byte[])hiveDecimal.getLowValue().getUnscaled(), (byte[])decimal.getLowValue().getUnscaled().toByteArray());
                }
            }
            Assert.assertEquals((Object)hiveData.isSetDoubleStats(), (Object)data.hasDoubleStats());
            if (hiveData.isSetDoubleStats()) {
                org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData hiveDouble = hiveData.getDoubleStats();
                dbl = data.getDoubleStats();
                Assert.assertEquals((Object)hiveDouble.isSetBitVectors(), (Object)dbl.hasBitVectors());
                if (hiveDouble.isSetBitVectors()) {
                    Assert.assertEquals((Object)hiveDouble.getBitVectors(), (Object)dbl.getBitVectors());
                }
                Assert.assertEquals((long)hiveDouble.getNumNulls(), (long)dbl.getNumNulls());
                Assert.assertEquals((long)hiveDouble.getNumDVs(), (long)dbl.getNumDistincts());
                Assert.assertEquals((Object)hiveDouble.isSetHighValue(), (Object)dbl.hasHighValue());
                if (hiveDouble.isSetHighValue()) {
                    Assert.assertEquals((double)hiveDouble.getHighValue(), (double)dbl.getHighValue(), (double)0.01);
                }
                Assert.assertEquals((Object)hiveDouble.isSetLowValue(), (Object)dbl.hasLowValue());
                if (hiveDouble.isSetLowValue()) {
                    Assert.assertEquals((double)hiveDouble.getLowValue(), (double)dbl.getLowValue(), (double)0.01);
                }
            }
            Assert.assertEquals((Object)hiveData.isSetLongStats(), (Object)data.hasLongStats());
            if (hiveData.isSetLongStats()) {
                LongColumnStatsData hiveLong = hiveData.getLongStats();
                dbl = data.getLongStats();
                Assert.assertEquals((Object)hiveLong.isSetBitVectors(), (Object)dbl.hasBitVectors());
                if (hiveLong.isSetBitVectors()) {
                    Assert.assertEquals((Object)hiveLong.getBitVectors(), (Object)dbl.getBitVectors());
                }
                Assert.assertEquals((long)hiveLong.getNumNulls(), (long)dbl.getNumNulls());
                Assert.assertEquals((long)hiveLong.getNumDVs(), (long)dbl.getNumDistincts());
                Assert.assertEquals((Object)hiveLong.isSetHighValue(), (Object)dbl.hasHighValue());
                if (hiveLong.isSetHighValue()) {
                    Assert.assertEquals((long)hiveLong.getHighValue(), (long)dbl.getHighValue());
                }
                Assert.assertEquals((Object)hiveLong.isSetLowValue(), (Object)dbl.hasLowValue());
                if (hiveLong.isSetLowValue()) {
                    Assert.assertEquals((long)hiveLong.getLowValue(), (long)dbl.getLowValue());
                }
            }
            Assert.assertEquals((Object)hiveData.isSetStringStats(), (Object)data.hasStringStats());
            if (hiveData.isSetStringStats()) {
                StringColumnStatsData hiveString = hiveData.getStringStats();
                alluxio.grpc.table.StringColumnStatsData string = data.getStringStats();
                Assert.assertEquals((Object)hiveString.isSetBitVectors(), (Object)string.hasBitVectors());
                if (hiveString.isSetBitVectors()) {
                    Assert.assertEquals((Object)hiveString.getBitVectors(), (Object)string.getBitVectors());
                }
                Assert.assertEquals((double)hiveString.getAvgColLen(), (double)string.getAvgColLen(), (double)0.01);
                Assert.assertEquals((long)hiveString.getMaxColLen(), (long)string.getMaxColLen());
                Assert.assertEquals((long)hiveString.getNumNulls(), (long)string.getNumNulls());
                Assert.assertEquals((long)hiveString.getNumDVs(), (long)string.getNumDistincts());
            }
        }
    }
}

