/*
 * Decompiled with CFR 0.152.
 */
package alluxio.table.under.hive;

import alluxio.table.common.udb.UdbConfiguration;
import alluxio.table.common.udb.UdbContext;
import alluxio.table.under.hive.HiveDatabase;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class HiveDatabaseTest {
    private static final String DB_NAME = "test";
    private static final Map<String, String> CONF = new HashMap<String, String>();
    @Rule
    public ExpectedException mExpection = ExpectedException.none();
    private UdbContext mUdbContext;
    private UdbConfiguration mUdbConf;

    @Before
    public void before() {
        this.mUdbContext = new UdbContext(null, null, "hive", "thrift://not_running:9083", DB_NAME, DB_NAME);
        this.mUdbConf = new UdbConfiguration(CONF);
    }

    @Test
    public void create() {
        Assert.assertEquals((Object)DB_NAME, (Object)HiveDatabase.create((UdbContext)this.mUdbContext, (UdbConfiguration)this.mUdbConf).getName());
    }

    @Test
    public void createEmptyName() {
        this.mExpection.expect(IllegalArgumentException.class);
        UdbContext udbContext = new UdbContext(null, null, "hive", "thrift://not_running:9083", "", DB_NAME);
        Assert.assertEquals((Object)DB_NAME, (Object)HiveDatabase.create((UdbContext)udbContext, (UdbConfiguration)new UdbConfiguration((Map)ImmutableMap.of())).getName());
    }

    @Test
    public void createNullName() {
        this.mExpection.expect(IllegalArgumentException.class);
        UdbContext udbContext = new UdbContext(null, null, "hive", "thrift://not_running:9083", null, DB_NAME);
        Assert.assertEquals((Object)DB_NAME, (Object)HiveDatabase.create((UdbContext)udbContext, (UdbConfiguration)new UdbConfiguration((Map)ImmutableMap.of())).getName());
    }

    @Test
    public void createEmptyConnectionUri() {
        this.mExpection.expect(IllegalArgumentException.class);
        UdbContext udbContext = new UdbContext(null, null, "hive", "", DB_NAME, DB_NAME);
        Assert.assertEquals((Object)DB_NAME, (Object)HiveDatabase.create((UdbContext)udbContext, (UdbConfiguration)new UdbConfiguration((Map)ImmutableMap.of())).getName());
    }

    @Test
    public void createNullConnectionUri() {
        this.mExpection.expect(IllegalArgumentException.class);
        UdbContext udbContext = new UdbContext(null, null, "hive", null, DB_NAME, DB_NAME);
        Assert.assertEquals((Object)DB_NAME, (Object)HiveDatabase.create((UdbContext)udbContext, (UdbConfiguration)new UdbConfiguration((Map)ImmutableMap.of())).getName());
    }

    @Test
    public void createWithProps() {
        ImmutableMap props = ImmutableMap.of((Object)"prop1", (Object)"value1", (Object)"prop2", (Object)"value2");
        Assert.assertEquals((Object)DB_NAME, (Object)HiveDatabase.create((UdbContext)this.mUdbContext, (UdbConfiguration)new UdbConfiguration((Map)props)).getName());
    }
}

