/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.hdfs;

import alluxio.cli.ApplicableUfsType;
import alluxio.cli.ValidationTaskResult;
import alluxio.cli.ValidationUtils;
import alluxio.cli.hdfs.HadoopConfigurationFileParser;
import alluxio.cli.hdfs.HdfsConfValidationTask;
import alluxio.conf.AlluxioConfiguration;
import alluxio.util.ExceptionUtils;
import alluxio.util.io.PathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.Option;

@ApplicableUfsType(value=ApplicableUfsType.Type.HDFS)
public class HdfsConfParityValidationTask
extends HdfsConfValidationTask {
    protected static final String HADOOP_CONF_DIR_ENV_VAR = "HADOOP_CONF_DIR";
    protected static final Option HADOOP_CONF_DIR_OPTION = Option.builder((String)"hadoopConfDir").required(false).hasArg(true).desc("path to server-side hadoop conf dir").build();

    public HdfsConfParityValidationTask(String path, AlluxioConfiguration conf) {
        super(path, conf);
    }

    @Override
    public String getName() {
        return "ValidateHdfsServerAndClientConf";
    }

    @Override
    public ValidationTaskResult validateImpl(Map<String, String> optionsMap) {
        if (!ValidationUtils.isHdfsScheme((String)this.mPath)) {
            this.mMsg.append(String.format("UFS path %s is not HDFS. Skipping validation for HDFS properties.%n", this.mPath));
            return new ValidationTaskResult(ValidationUtils.State.SKIPPED, this.getName(), this.mMsg.toString(), this.mAdvice.toString());
        }
        return this.validateHdfsSettingParity(optionsMap);
    }

    public List<Option> getOptionList() {
        ArrayList<Option> opts = new ArrayList<Option>();
        opts.add(HADOOP_CONF_DIR_OPTION);
        return opts;
    }

    private ValidationTaskResult validateHdfsSettingParity(Map<String, String> optionsMap) {
        String serverHadoopConfDirPath = optionsMap.containsKey(HADOOP_CONF_DIR_OPTION.getOpt()) ? optionsMap.get(HADOOP_CONF_DIR_OPTION.getOpt()) : System.getenv(HADOOP_CONF_DIR_ENV_VAR);
        if (serverHadoopConfDirPath == null) {
            this.mMsg.append("Path to server-side hadoop configuration unspecified, skipping validation for HDFS properties.");
            return new ValidationTaskResult(ValidationUtils.State.SKIPPED, this.getName(), this.mMsg.toString(), this.mAdvice.toString());
        }
        String serverCoreSiteFilePath = PathUtils.concatPath((Object)serverHadoopConfDirPath, (Object)"/core-site.xml");
        String serverHdfsSiteFilePath = PathUtils.concatPath((Object)serverHadoopConfDirPath, (Object)"/hdfs-site.xml");
        ValidationTaskResult loadConfig = this.loadHdfsConfig();
        if (loadConfig.getState() != ValidationUtils.State.OK) {
            return loadConfig;
        }
        boolean ok = this.compareConfigurations(serverCoreSiteFilePath, "core-site.xml", this.mCoreConf) && this.compareConfigurations(serverHdfsSiteFilePath, "hdfs-site.xml", this.mHdfsConf);
        return new ValidationTaskResult(ok ? ValidationUtils.State.OK : ValidationUtils.State.FAILED, this.getName(), this.mMsg.toString(), this.mAdvice.toString());
    }

    private boolean compareConfigurations(String serverConfigFilePath, String clientSiteName, Map<String, String> clientSiteProps) {
        Map<String, String> serverSiteProps;
        HadoopConfigurationFileParser parser = new HadoopConfigurationFileParser();
        try {
            serverSiteProps = parser.parseXmlConfiguration(serverConfigFilePath);
        }
        catch (Exception e) {
            this.mMsg.append(String.format("Failed to parse server-side %s.%n", serverConfigFilePath));
            this.mMsg.append(ExceptionUtils.asPlainText((Throwable)e));
            this.mAdvice.append(String.format("Please fix the parsing error in %s.%n", serverConfigFilePath));
            return false;
        }
        boolean matches = true;
        for (Map.Entry<String, String> prop : clientSiteProps.entrySet()) {
            if (!serverSiteProps.containsKey(prop.getKey())) {
                matches = false;
                this.mMsg.append(String.format("%s is configured in %s, but not configured in %s.%n", prop.getKey(), clientSiteName, serverConfigFilePath));
                this.mAdvice.append(String.format("Please configure property %s in %s.%n", prop.getKey(), serverConfigFilePath));
                continue;
            }
            if (prop.getValue().equals(serverSiteProps.get(prop.getKey()))) continue;
            matches = false;
            this.mMsg.append(String.format("%s is set to %s in %s, but to %s in %s.%n", prop.getKey(), prop.getValue(), clientSiteName, serverSiteProps.get(prop.getKey()), serverConfigFilePath));
            this.mAdvice.append(String.format("Please fix the inconsistency on property %s.%n", prop.getKey()));
        }
        if (!matches) {
            return false;
        }
        for (Map.Entry<String, String> prop : serverSiteProps.entrySet()) {
            if (!clientSiteProps.containsKey(prop.getKey())) {
                matches = false;
                this.mMsg.append(String.format("%s is configured in %s, but not configured in %s.%n", prop.getKey(), serverConfigFilePath, clientSiteName));
                this.mAdvice.append(String.format("Please configure %s in %s.%n", prop.getKey(), clientSiteName));
                continue;
            }
            if (prop.getValue().equals(clientSiteProps.get(prop.getKey()))) continue;
            matches = false;
            this.mMsg.append(String.format("%s is set to %s in %s, but to %s in %s.%n", prop.getKey(), prop.getValue(), prop.getValue(), clientSiteProps.get(prop.getKey()), clientSiteName));
            this.mAdvice.append(String.format("Please fix the inconsistency on property %s.%n", prop.getKey()));
        }
        return matches;
    }
}

