/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.cli.AbstractValidationTask;
import alluxio.cli.ClusterConfConsistencyValidationTask;
import alluxio.cli.NativeLibValidationTask;
import alluxio.cli.PortAvailabilityValidationTask;
import alluxio.cli.RamDiskMountPrivilegeValidationTask;
import alluxio.cli.SshValidationTask;
import alluxio.cli.StorageSpaceValidationTask;
import alluxio.cli.UfsDirectoryValidationTask;
import alluxio.cli.UfsSuperUserValidationTask;
import alluxio.cli.UfsVersionValidationTask;
import alluxio.cli.UserLimitValidationTask;
import alluxio.cli.ValidationTask;
import alluxio.cli.ValidationTaskResult;
import alluxio.cli.ValidationUtils;
import alluxio.cli.hdfs.HdfsConfParityValidationTask;
import alluxio.cli.hdfs.HdfsConfValidationTask;
import alluxio.cli.hdfs.HdfsProxyUserValidationTask;
import alluxio.cli.hdfs.HdfsVersionValidationTask;
import alluxio.cli.hdfs.SecureHdfsValidationTask;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.util.CommonUtils;
import alluxio.util.ConfigurationUtils;
import alluxio.util.network.NetworkAddressUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class ValidateEnv {
    private static final String USAGE = "validateEnv COMMAND [NAME] [OPTIONS]\n\nValidate environment for Alluxio.\n\nCOMMAND can be one of the following values:\nlocal:   run all validation tasks on local\nmaster:  run master validation tasks on local\nworker:  run worker validation tasks on local\nall:     run corresponding validation tasks on all master nodes and worker nodes\nmasters: run master validation tasks on all master nodes\nworkers: run worker validation tasks on all worker nodes\n\nlist:    list all validation tasks\n\nFor all commands except list:\nNAME can be any task full name or prefix.\nWhen NAME is given, only tasks with name starts with the prefix will run.\nFor example, specifying NAME \"master\" or \"ma\" will run both tasks named \"master.rpc.port.available\" and \"master.web.port.available\" but not \"worker.rpc.port.available\".\nIf NAME is not given, all tasks for the given TARGET will run.\n\nOPTIONS can be a list of command line options. Each option has the format \"-<optionName> [optionValue]\"\n";
    private static final String ALLUXIO_MASTER_CLASS = "alluxio.master.AlluxioMaster";
    private static final String ALLUXIO_WORKER_CLASS = "alluxio.worker.AlluxioWorker";
    private static final String ALLUXIO_PROXY_CLASS = "alluxio.proxy.AlluxioProxy";
    private static final Options OPTIONS = new Options();
    private final Map<ValidationTask, String> mTasks = new HashMap<ValidationTask, String>();
    private final Map<String, String> mTaskDescriptions = new HashMap<String, String>();
    private final List<ValidationTask> mCommonTasks = new ArrayList<ValidationTask>();
    private final List<ValidationTask> mClusterTasks = new ArrayList<ValidationTask>();
    private final List<ValidationTask> mMasterTasks = new ArrayList<ValidationTask>();
    private final List<ValidationTask> mWorkerTasks = new ArrayList<ValidationTask>();
    private final Map<String, Collection<ValidationTask>> mTargetTasks;
    private final AlluxioConfiguration mConf;
    private final String mPath;

    public ValidateEnv(String path, AlluxioConfiguration conf) {
        this.mPath = path;
        this.mConf = conf;
        this.registerTask("ufs.hdfs.config.correctness", "This validates HDFS configuration files like core-site.xml and hdfs-site.xml.", new HdfsConfValidationTask(this.mPath, this.mConf), this.mCommonTasks);
        this.registerTask("ufs.hdfs.config.parity", "If a Hadoop config directory is specified, this compares the Hadoop config directory with the HDFS configuration paths given to Alluxio, and see if they are consistent.", new HdfsConfParityValidationTask(this.mPath, this.mConf), this.mCommonTasks);
        this.registerTask("ufs.hdfs.config.proxyuser", "This validates proxy user configuration in HDFS for Alluxio. This is needed to enable impersonation for Alluxio.", new HdfsProxyUserValidationTask(this.mPath, this.mConf), this.mCommonTasks);
        this.registerTask("ufs.hdfs.config.version", "This validates version compatibility between Alluxio and HDFS.", new HdfsVersionValidationTask(this.mConf), this.mCommonTasks);
        this.registerTask("master.rpc.port.available", "validate master RPC port is available", new PortAvailabilityValidationTask(NetworkAddressUtils.ServiceType.MASTER_RPC, ALLUXIO_MASTER_CLASS, this.mConf), this.mMasterTasks);
        this.registerTask("master.web.port.available", "validate master web port is available", new PortAvailabilityValidationTask(NetworkAddressUtils.ServiceType.MASTER_WEB, ALLUXIO_MASTER_CLASS, this.mConf), this.mMasterTasks);
        this.registerTask("worker.rpc.port.available", "validate worker RPC port is available", new PortAvailabilityValidationTask(NetworkAddressUtils.ServiceType.WORKER_RPC, ALLUXIO_WORKER_CLASS, this.mConf), this.mWorkerTasks);
        this.registerTask("worker.web.port.available", "validate worker web port is available", new PortAvailabilityValidationTask(NetworkAddressUtils.ServiceType.WORKER_WEB, ALLUXIO_WORKER_CLASS, this.mConf), this.mWorkerTasks);
        this.registerTask("proxy.web.port.available", "validate proxy web port is available", new PortAvailabilityValidationTask(NetworkAddressUtils.ServiceType.PROXY_WEB, ALLUXIO_PROXY_CLASS, this.mConf), this.mCommonTasks);
        this.registerTask("master.ufs.hdfs.security.kerberos", "This validates kerberos security configurations for Alluxio masters.", new SecureHdfsValidationTask("master", this.mPath, this.mConf), this.mMasterTasks);
        this.registerTask("worker.ufs.hdfs.security.kerberos", "This validates kerberos security configurations for Alluxio workers.", new SecureHdfsValidationTask("worker", this.mPath, this.mConf), this.mWorkerTasks);
        this.registerTask("ssh.nodes.reachable", "validate SSH port on all Alluxio nodes are reachable", new SshValidationTask(this.mConf), this.mCommonTasks);
        this.registerTask("ufs.version", "This validates the a configured UFS library version is available on the system.", new UfsVersionValidationTask(this.mPath, this.mConf), this.mCommonTasks);
        this.registerTask("ufs.path.accessible", "This validates the under file system location is accessible to Alluxio.", new UfsDirectoryValidationTask(this.mPath, this.mConf), this.mCommonTasks);
        this.registerTask("ufs.path.superuser", "This validates Alluxio has super user privilege on the under file system.", new UfsSuperUserValidationTask(this.mPath, this.mConf), this.mCommonTasks);
        this.registerTask("worker.ramdisk.mount.privilege", "validate user has the correct privilege to mount ramdisk", new RamDiskMountPrivilegeValidationTask(this.mConf), this.mWorkerTasks);
        this.registerTask("ulimit.nofile", "validate ulimit for number of open files is set appropriately", UserLimitValidationTask.createOpenFilesLimitValidationTask(), this.mCommonTasks);
        this.registerTask("ulimit.nproc", "validate ulimit for number of processes is set appropriately", UserLimitValidationTask.createUserProcessesLimitValidationTask(), this.mCommonTasks);
        this.registerTask("worker.storage.space", "validate tiered storage locations have enough space", new StorageSpaceValidationTask(this.mConf), this.mWorkerTasks);
        this.registerTask("cluster.conf.consistent", "validate configuration consistency across the cluster", new ClusterConfConsistencyValidationTask(this.mConf), this.mClusterTasks);
        this.registerTask("java.native.libs", String.format("This validates if java native libraries defined at %s all exist.", "java.library.path"), new NativeLibValidationTask(), this.mCommonTasks);
        this.mTargetTasks = this.initializeTargetTasks();
    }

    private Map<String, Collection<ValidationTask>> initializeTargetTasks() {
        TreeMap<String, Collection<ValidationTask>> targetMap = new TreeMap<String, Collection<ValidationTask>>();
        ArrayList<ValidationTask> allMasterTasks = new ArrayList<ValidationTask>(this.mCommonTasks);
        allMasterTasks.addAll(this.mMasterTasks);
        targetMap.put("master", allMasterTasks);
        ArrayList<ValidationTask> allWorkerTasks = new ArrayList<ValidationTask>(this.mCommonTasks);
        allWorkerTasks.addAll(this.mWorkerTasks);
        targetMap.put("worker", allWorkerTasks);
        targetMap.put("local", this.mTasks.keySet());
        targetMap.put("cluster", new ArrayList<ValidationTask>(this.mClusterTasks));
        return targetMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationTask registerTask(String name, String description, AbstractValidationTask task, List<ValidationTask> tasks) {
        this.mTasks.put((ValidationTask)task, name);
        this.mTaskDescriptions.put(name, description);
        tasks.add((ValidationTask)task);
        List optList = task.getOptionList();
        Class<ValidateEnv> clazz = ValidateEnv.class;
        synchronized (ValidateEnv.class) {
            optList.forEach(opt -> OPTIONS.addOption(opt));
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return task;
        }
    }

    public Map<ValidationTask, String> getTasks() {
        return Collections.unmodifiableMap(this.mTasks);
    }

    public Map<String, String> getDescription() {
        return Collections.unmodifiableMap(this.mTaskDescriptions);
    }

    private boolean validateRemote(Collection<String> nodes, String target, String name, CommandLine cmd) throws InterruptedException {
        if (nodes == null) {
            return false;
        }
        boolean success = true;
        for (String node : nodes) {
            success &= this.validateRemote(node, target, name, cmd);
        }
        return success;
    }

    private boolean validateRemote(String node, String target, String name, CommandLine cmd) throws InterruptedException {
        System.out.format("Validating %s environment on %s...%n", target, node);
        if (!CommonUtils.isAddressReachable((String)node, (int)22, (int)30000)) {
            System.err.format("Unable to reach ssh port 22 on node %s.%n", node);
            return false;
        }
        String argStr = String.join((CharSequence)" ", cmd.getArgs());
        String homeDir = this.mConf.getString(PropertyKey.HOME);
        String remoteCommand = String.format("%s/bin/alluxio validateEnv %s %s %s", homeDir, target, name == null ? "" : name, argStr);
        String localCommand = String.format("ssh -o ConnectTimeout=5 -o StrictHostKeyChecking=no -tt %s \"bash %s\"", node, remoteCommand);
        String[] command = new String[]{"bash", "-c", localCommand};
        try {
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.redirectErrorStream(true);
            builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            builder.redirectInput(ProcessBuilder.Redirect.INHERIT);
            Process process = builder.start();
            process.waitFor();
            return process.exitValue() == 0;
        }
        catch (IOException e) {
            System.err.format("Unable to validate on node %s: %s.%n", node, e.getMessage());
            return false;
        }
    }

    private boolean validateLocal(String target, String name, CommandLine cmd) throws InterruptedException {
        int validationCount = 0;
        HashMap<ValidationUtils.State, Integer> results = new HashMap<ValidationUtils.State, Integer>();
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        for (Option opt : cmd.getOptions()) {
            optionsMap.put(opt.getOpt(), opt.getValue());
        }
        Collection<ValidationTask> tasks = this.mTargetTasks.get(target);
        System.out.format("Validating %s environment...%n", target);
        for (ValidationTask task : tasks) {
            String taskName = this.mTasks.get(task);
            if (name != null && !taskName.startsWith(name)) continue;
            System.out.format("Validating %s...%n", taskName);
            ValidationTaskResult result = task.validate(optionsMap);
            results.put(result.mState, results.getOrDefault(result.mState, 0) + 1);
            switch (result.mState) {
                case OK: {
                    System.out.print("\u001b[32m");
                    break;
                }
                case WARNING: {
                    System.out.print("\u001b[33m");
                    break;
                }
                case FAILED: {
                    System.out.print("\u001b[31m");
                    break;
                }
                case SKIPPED: {
                    System.out.print("\u001b[35m");
                    break;
                }
            }
            System.out.print(result.getName());
            System.out.println("\u001b[0m");
            ++validationCount;
        }
        if (results.containsKey(ValidationUtils.State.FAILED)) {
            System.err.format("%d failures ", results.get(ValidationUtils.State.FAILED));
        }
        if (results.containsKey(ValidationUtils.State.WARNING)) {
            System.err.format("%d warnings ", results.get(ValidationUtils.State.WARNING));
        }
        if (results.containsKey(ValidationUtils.State.SKIPPED)) {
            System.err.format("%d skipped ", results.get(ValidationUtils.State.SKIPPED));
        }
        System.err.println();
        if (validationCount == 0) {
            System.err.format("No validation task matched name \"%s\".%n", name);
            return false;
        }
        if (results.containsKey(ValidationUtils.State.FAILED)) {
            return false;
        }
        System.out.println("Validation succeeded.");
        return true;
    }

    private boolean validateWorkers(String name, CommandLine cmd) throws InterruptedException {
        return this.validateRemote(ConfigurationUtils.getWorkerHostnames((AlluxioConfiguration)this.mConf), "worker", name, cmd);
    }

    private boolean validateMasters(String name, CommandLine cmd) throws InterruptedException {
        return this.validateRemote(ConfigurationUtils.getMasterHostnames((AlluxioConfiguration)this.mConf), "master", name, cmd);
    }

    private void printTasks(String target) {
        System.out.format("The following tasks are available to run on %s:%n", target);
        Collection<ValidationTask> tasks = this.mTargetTasks.get(target);
        for (ValidationTask task : tasks) {
            String taskName = this.mTasks.get(task);
            System.out.printf("%s: %s%n", taskName, this.mTaskDescriptions.get(taskName));
        }
        System.out.println();
    }

    private void printTasks() {
        this.printTasks("master");
        this.printTasks("worker");
        this.printTasks("cluster");
    }

    private static int runTasks(String target, String name, CommandLine cmd) throws InterruptedException {
        boolean success;
        AlluxioConfiguration conf = Configuration.global();
        String rootPath = conf.getString(PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
        ValidateEnv validate = new ValidateEnv(rootPath, conf);
        switch (target) {
            case "local": 
            case "worker": 
            case "master": {
                success = validate.validateLocal(target, name, cmd);
                break;
            }
            case "all": {
                success = validate.validateMasters(name, cmd);
                success = validate.validateWorkers(name, cmd) && success;
                success = validate.validateLocal("cluster", name, cmd) && success;
                break;
            }
            case "workers": {
                success = validate.validateWorkers(name, cmd);
                break;
            }
            case "masters": {
                success = validate.validateMasters(name, cmd);
                break;
            }
            default: {
                ValidateEnv.printHelp("Invalid target.");
                return -2;
            }
        }
        return success ? 0 : -1;
    }

    public static void printHelp(String message) {
        System.err.println(message);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(USAGE, OPTIONS, true);
    }

    public static int validate(String ... argv) throws InterruptedException {
        CommandLine cmd;
        String[] args;
        int argsLength;
        if (argv.length < 1) {
            ValidateEnv.printHelp("Target not specified.");
            return -2;
        }
        String command = argv[0];
        String name = null;
        for (argsLength = 0; argsLength < argv.length && !argv[argsLength].startsWith("-"); ++argsLength) {
        }
        if (argsLength > 1) {
            name = argv[1];
            args = Arrays.copyOfRange(argv, 2, argv.length);
        } else {
            args = Arrays.copyOfRange(argv, 1, argv.length);
        }
        try {
            cmd = ValidateEnv.parseArgsAndOptions(OPTIONS, args);
        }
        catch (InvalidArgumentException e) {
            System.err.format("Invalid argument: %s.%n", e.getMessage());
            return -1;
        }
        if (command.equals("list")) {
            AlluxioConfiguration conf = Configuration.global();
            String rootPath = conf.getString(PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
            ValidateEnv task = new ValidateEnv(rootPath, conf);
            task.printTasks();
            return 0;
        }
        return ValidateEnv.runTasks(command, name, cmd);
    }

    public static void main(String[] args) throws InterruptedException {
        System.exit(ValidateEnv.validate(args));
    }

    private static CommandLine parseArgsAndOptions(Options options, String ... args) throws InvalidArgumentException {
        CommandLine cmd;
        DefaultParser parser = new DefaultParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            throw new InvalidArgumentException("Failed to parse args for validateEnv", (Throwable)e);
        }
        return cmd;
    }
}

