/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.cli.RelatedS3Operations;
import alluxio.cli.RunTestUtils;
import alluxio.cli.S3ASpecificOperations;
import alluxio.cli.UnderFileSystemCommonOperations;
import alluxio.cli.ValidationTaskResult;
import alluxio.cli.ValidationUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import alluxio.underfs.UfsFileStatus;
import alluxio.underfs.UfsStatus;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.UnderFileSystemFactoryRegistry;
import alluxio.underfs.options.DeleteOptions;
import alluxio.util.ExceptionUtils;
import alluxio.util.io.PathUtils;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.io.Closer;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UnderFileSystemContractTest {
    private static final Logger LOG = LoggerFactory.getLogger(UnderFileSystemContractTest.class);
    public static final String TASK_NAME = "ValidateUfsOperations";
    private static final String S3_IDENTIFIER = "s3";
    @Parameter(names={"--path"}, required=true, description="The under filesystem path to run tests against.")
    private String mUfsPath;
    @Parameter(names={"--test"}, required=false, description="Test name, this option can be passed multiple times to indicate multiply tests")
    private List<String> mTestList = new ArrayList<String>();
    @Parameter(names={"--help"}, help=true)
    private boolean mHelp = false;
    private InstancedConfiguration mConf = Configuration.modifiableGlobal();
    private UnderFileSystem mUfs;

    public void run() throws Exception {
        UnderFileSystemConfiguration ufsConf = this.getUfsConf();
        UnderFileSystemFactory factory = UnderFileSystemFactoryRegistry.find((String)this.mUfsPath, (UnderFileSystemConfiguration)ufsConf);
        if (factory == null || !factory.supportsPath(this.mUfsPath)) {
            System.out.printf("%s is not a valid path", this.mUfsPath);
            System.exit(1);
        }
        this.mConf.set(PropertyKey.UNDERFS_LISTING_LENGTH, (Object)50);
        this.mConf.set(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT, "512B");
        this.mConf.set(PropertyKey.MASTER_JOURNAL_FLUSH_BATCH_TIME_MS, "1sec");
        this.mUfs = UnderFileSystem.Factory.create((String)this.mUfsPath, (UnderFileSystemConfiguration)ufsConf);
        int failedCnt = this.runCommonOperations();
        if (this.mUfs.getUnderFSType().equals(S3_IDENTIFIER)) {
            failedCnt += this.runS3Operations();
        }
        System.out.printf("Tests completed with %d failed.%n", failedCnt);
        if (failedCnt > 0) {
            throw new RuntimeException(String.format("UFS contract test failed with %d failures", failedCnt));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationTaskResult runValidationTask() throws IOException {
        Closer closer = Closer.create();
        ByteArrayOutputStream msgBuf = new ByteArrayOutputStream();
        ByteArrayOutputStream adviceBuf = new ByteArrayOutputStream();
        PrintStream msgStream = new PrintStream(msgBuf, true);
        PrintStream adviceStream = new PrintStream(adviceBuf, true);
        closer.register((Closeable)msgStream);
        closer.register((Closeable)adviceStream);
        closer.register((Closeable)msgBuf);
        closer.register((Closeable)adviceBuf);
        try {
            ValidationUtils.State state;
            UnderFileSystemConfiguration ufsConf = this.getUfsConf();
            UnderFileSystemFactory factory = UnderFileSystemFactoryRegistry.find((String)this.mUfsPath, (UnderFileSystemConfiguration)ufsConf);
            if (factory == null || !factory.supportsPath(this.mUfsPath)) {
                msgStream.append(String.format("%s is not a valid path%n", this.mUfsPath));
                adviceStream.append(String.format("Please validate if %s is a correct path%n", this.mUfsPath));
                ValidationTaskResult validationTaskResult = new ValidationTaskResult(ValidationUtils.State.FAILED, TASK_NAME, msgBuf.toString(), adviceBuf.toString());
                return validationTaskResult;
            }
            this.mConf.set(PropertyKey.UNDERFS_LISTING_LENGTH, (Object)50);
            this.mConf.set(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT, "512B");
            this.mConf.set(PropertyKey.MASTER_JOURNAL_FLUSH_BATCH_TIME_MS, "1sec");
            this.mUfs = UnderFileSystem.Factory.create((String)this.mUfsPath, (UnderFileSystemConfiguration)ufsConf);
            int failedCnt = this.runCommonOperations(msgStream, adviceStream, System.err);
            if (this.mUfs.getUnderFSType().equals(S3_IDENTIFIER)) {
                failedCnt += this.runS3Operations(msgStream, adviceStream, System.err);
            }
            msgStream.append(String.format("Tests completed with %d failed.%n", failedCnt));
            ValidationUtils.State state2 = state = failedCnt == 0 ? ValidationUtils.State.OK : ValidationUtils.State.FAILED;
            if (failedCnt > 0) {
                adviceStream.append("Please check the failed UFS operations from the output.");
            }
            ValidationTaskResult validationTaskResult = new ValidationTaskResult(state, TASK_NAME, msgBuf.toString(), adviceBuf.toString());
            return validationTaskResult;
        }
        catch (Exception e) {
            msgStream.append(ExceptionUtils.asPlainText((Throwable)e));
            adviceStream.append("Please resolve the errors from failed UFS operations.");
            ValidationTaskResult validationTaskResult = new ValidationTaskResult(ValidationUtils.State.FAILED, TASK_NAME, msgBuf.toString(), adviceBuf.toString());
            return validationTaskResult;
        }
        finally {
            closer.close();
        }
    }

    private UnderFileSystemConfiguration getUfsConf() {
        return UnderFileSystemConfiguration.defaults((AlluxioConfiguration)this.mConf).createMountSpecificConf(this.mConf.getProperties().entrySet().stream().filter(entry -> this.mConf.getSource((PropertyKey)entry.getKey()) == Source.SYSTEM_PROPERTY).filter(entry -> this.mConf.isSet((PropertyKey)entry.getKey()) && (((PropertyKey)entry.getKey()).getType() != PropertyKey.PropertyType.STRING || !((String)entry.getValue()).isEmpty())).collect(Collectors.toMap(entry -> ((PropertyKey)entry.getKey()).getName(), Map.Entry::getValue)));
    }

    private int runCommonOperations() throws Exception {
        return this.runCommonOperations(System.out, System.out, System.err);
    }

    private int runCommonOperations(PrintStream msgStream, PrintStream adviceStream, PrintStream errStream) throws Exception {
        String testDir = this.createTestDirectory();
        return this.loadAndRunTests(new UnderFileSystemCommonOperations(this.mUfsPath, testDir, this.mUfs, this.mConf), testDir, msgStream, adviceStream, errStream);
    }

    private int runS3Operations() throws Exception {
        return this.runS3Operations(System.out, System.out, System.err);
    }

    private int runS3Operations(PrintStream msgStream, PrintStream adviceStream, PrintStream errStream) throws Exception {
        this.mConf.set(PropertyKey.UNDERFS_S3_LIST_OBJECTS_V1, (Object)true);
        this.mConf.set(PropertyKey.UNDERFS_S3_STREAMING_UPLOAD_ENABLED, (Object)true);
        this.mConf.set(PropertyKey.UNDERFS_S3_STREAMING_UPLOAD_PARTITION_SIZE, "5MB");
        this.mConf.set(PropertyKey.UNDERFS_S3_INTERMEDIATE_UPLOAD_CLEAN_AGE, "0");
        this.mUfs = UnderFileSystem.Factory.create((String)this.mUfsPath, (UnderFileSystemConfiguration)this.getUfsConf());
        String testDir = this.createTestDirectory();
        return this.loadAndRunTests(new S3ASpecificOperations(testDir, this.mUfs, this.mConf), testDir, msgStream, adviceStream, errStream);
    }

    private int loadAndRunTests(Object operations, String testDir) throws Exception {
        return this.loadAndRunTests(operations, testDir, System.out, System.out, System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int loadAndRunTests(Object operations, String testDir, PrintStream msgStream, PrintStream adviceStream, PrintStream errStream) throws Exception {
        int failedTestCnt = 0;
        try {
            Method[] tests;
            Field[] fields;
            Class<?> classToRun = operations.getClass();
            for (Field field : fields = classToRun.getDeclaredFields()) {
                field.setAccessible(true);
            }
            for (Method test : tests = classToRun.getDeclaredMethods()) {
                String testName = test.getName();
                if (!testName.endsWith("Test") || !this.mTestList.isEmpty() && !this.mTestList.contains(testName)) continue;
                msgStream.format("Running test: %s...%n", testName);
                boolean passed = false;
                try {
                    test.invoke(operations, new Object[0]);
                    passed = true;
                }
                catch (Exception e) {
                    if (this.mUfs.getUnderFSType().equals(S3_IDENTIFIER)) {
                        this.logRelatedS3Operations(test, msgStream);
                    }
                    msgStream.format("Operation %s failed%n", testName);
                    msgStream.format(ExceptionUtils.asPlainText((Throwable)e), new Object[0]);
                    errStream.format("Test %s.%s aborted%n%s%n", test.getClass(), test.getName(), e);
                }
                finally {
                    this.cleanupUfs(testDir);
                    RunTestUtils.printTestStatus((boolean)passed, (PrintStream)msgStream);
                    if (!passed) {
                        ++failedTestCnt;
                    }
                }
            }
            int n = failedTestCnt;
            return n;
        }
        finally {
            this.mUfs.deleteDirectory(testDir, DeleteOptions.defaults().setRecursive(true));
            this.mUfs.close();
        }
    }

    private String createTestDirectory() throws IOException {
        String testDir = PathUtils.concatPath((Object)this.mUfsPath, (Object)UUID.randomUUID());
        this.mUfs.mkdirs(testDir);
        return testDir;
    }

    private void cleanupUfs(String directory) throws IOException {
        UfsStatus[] statuses = this.mUfs.listStatus(directory);
        if (statuses == null) {
            LOG.error("Path {} is invalid.", (Object)directory);
            return;
        }
        for (UfsStatus status : statuses) {
            if (status instanceof UfsFileStatus) {
                this.mUfs.deleteFile(PathUtils.concatPath((Object)directory, (Object)status.getName()));
                continue;
            }
            this.mUfs.deleteDirectory(PathUtils.concatPath((Object)directory, (Object)status.getName()), DeleteOptions.defaults().setRecursive(true));
        }
    }

    private void logRelatedS3Operations(Method test, PrintStream stream) {
        CharSequence[] ops;
        RelatedS3Operations annotation = test.getAnnotation(RelatedS3Operations.class);
        if (annotation != null && (ops = annotation.operations()).length > 0) {
            stream.println("Related S3 operations: " + String.join((CharSequence)", ", ops));
        }
    }

    private static String getHelpMessage() {
        return "Test description:\nTest the integration between Alluxio and the under filesystem. If the given under filesystem is S3, this test can also be used as a S3 compatibility test to test if the target under filesystem can fulfill the minimum S3 compatibility requirements in order to work well with Alluxio through Alluxio's integration with S3. \nCommand line example: 'bin/alluxio runUfsTests --path s3://testPath -Ds3a.accessKeyId=<accessKeyId> -Ds3a.secretKeyId=<secretKeyId>-Dalluxio.underfs.s3.endpoint=<endpoint_url> -Dalluxio.underfs.s3.disable.dns.buckets=true'";
    }

    public static void main(String[] args) throws Exception {
        UnderFileSystemContractTest test = new UnderFileSystemContractTest();
        JCommander jc = new JCommander((Object)test);
        jc.setProgramName(UnderFileSystemContractTest.class.getName());
        try {
            jc.parse(args);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            jc.usage();
            System.out.println(UnderFileSystemContractTest.getHelpMessage());
            System.exit(1);
        }
        if (test.mHelp) {
            jc.usage();
            System.out.println(UnderFileSystemContractTest.getHelpMessage());
        } else {
            test.run();
        }
    }
}

