/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.cli.AbstractValidationTask;
import alluxio.cli.ApplicableUfsType;
import alluxio.cli.ValidationTaskResult;
import alluxio.cli.ValidationUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.underfs.UfsStatus;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.ExceptionUtils;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Map;

@ApplicableUfsType(value=ApplicableUfsType.Type.HDFS)
public final class UfsSuperUserValidationTask
extends AbstractValidationTask {
    private final AlluxioConfiguration mConf;
    private final String mPath;

    public UfsSuperUserValidationTask(String path, AlluxioConfiguration conf) {
        this.mPath = path;
        this.mConf = conf;
    }

    public String getName() {
        return "ValidateSuperUserPrivilege";
    }

    public ValidationTaskResult validateImpl(Map<String, String> optionsMap) {
        UfsStatus status;
        UnderFileSystem ufs;
        StringBuilder msg = new StringBuilder();
        StringBuilder advice = new StringBuilder();
        if (!ValidationUtils.isHdfsScheme((String)this.mPath)) {
            msg.append(String.format("Under file system is not HDFS. Skip validation. ", new Object[0]));
            return new ValidationTaskResult(ValidationUtils.State.SKIPPED, this.getName(), msg.toString(), advice.toString());
        }
        try {
            ufs = UnderFileSystem.Factory.create((String)this.mPath, (AlluxioConfiguration)this.mConf);
            status = ufs.getStatus(this.mPath);
            if (status == null) {
                msg.append(String.format("Unable to get status for under file system path %s. ", this.mPath));
                advice.append(String.format("Please check your path %s. ", this.mPath));
                return new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), msg.toString(), advice.toString());
            }
            if (Strings.isNullOrEmpty((String)status.getOwner()) && Strings.isNullOrEmpty((String)status.getGroup())) {
                msg.append(String.format("Cannot determine owner of under file system path %s. ", this.mPath));
                advice.append(String.format("Please check your path %s. ", this.mPath));
                return new ValidationTaskResult(ValidationUtils.State.WARNING, this.getName(), msg.toString(), advice.toString());
            }
        }
        catch (Exception e) {
            msg.append(String.format("Unable to access under file system path %s: %s.", this.mPath, e.getMessage()));
            msg.append(ExceptionUtils.asPlainText((Throwable)e));
            return new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), msg.toString(), advice.toString());
        }
        try {
            ufs.setOwner(this.mPath, status.getOwner(), status.getGroup());
            msg.append(String.format("User has superuser privilege to path %s.%n", this.mPath));
            return new ValidationTaskResult(ValidationUtils.State.OK, this.getName(), msg.toString(), advice.toString());
        }
        catch (IOException e) {
            msg.append(String.format("Unable to set owner of under file system path %s: %s. ", this.mPath, e.getMessage()));
            advice.append("Please check if Alluxio is super user on the file system. ");
            return new ValidationTaskResult(ValidationUtils.State.WARNING, this.getName(), msg.toString(), advice.toString());
        }
    }
}

