/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.AlluxioURI;
import alluxio.cli.AbstractValidationTask;
import alluxio.cli.ValidationTaskResult;
import alluxio.cli.ValidationUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.util.ExceptionUtils;
import alluxio.util.OSUtils;
import alluxio.util.ShellUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class RamDiskMountPrivilegeValidationTask
extends AbstractValidationTask {
    private final AlluxioConfiguration mConf;

    public RamDiskMountPrivilegeValidationTask(AlluxioConfiguration conf) {
        this.mConf = conf;
    }

    public String getName() {
        return "ValidateRamDiskMountPrivilege";
    }

    public ValidationTaskResult validateImpl(Map<String, String> optionsMap) throws InterruptedException {
        StringBuilder msg = new StringBuilder();
        StringBuilder advice = new StringBuilder();
        List paths = this.mConf.getList(PropertyKey.WORKER_TIERED_STORE_LEVEL0_DIRS_PATH);
        String alias = this.mConf.getString(PropertyKey.WORKER_TIERED_STORE_LEVEL0_ALIAS);
        if (!alias.equals("MEM")) {
            msg.append("Top tier storage is not memory, skip validation.");
            return new ValidationTaskResult(ValidationUtils.State.SKIPPED, this.getName(), msg.toString(), advice.toString());
        }
        if (!OSUtils.isLinux()) {
            msg.append("OS is not Linux, skip validation.");
            return new ValidationTaskResult(ValidationUtils.State.SKIPPED, this.getName(), msg.toString(), advice.toString());
        }
        if (paths.isEmpty()) {
            msg.append("Mount path is empty.%n");
            advice.append(String.format("Please check your configuration %s=%s.%n", PropertyKey.WORKER_TIERED_STORE_LEVEL0_DIRS_PATH, paths));
            return new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), msg.toString(), advice.toString());
        }
        if (paths.size() > 1) {
            msg.append("Multiple storage paths for memory tier found. Skip validation.");
            return new ValidationTaskResult(ValidationUtils.State.SKIPPED, this.getName(), msg.toString(), advice.toString());
        }
        String path = new AlluxioURI((String)paths.get(0)).getPath();
        try {
            File file = new File(path);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    msg.append(String.format("Path %s is not a directory.%n", path));
                    advice.append(String.format("Please check your path %s.%n", path));
                    return new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), msg.toString(), advice.toString());
                }
                if (ShellUtils.isMountingPoint((String)path, (String[])new String[]{"ramfs", "tmpfs"})) {
                    if (!file.canWrite()) {
                        msg.append(String.format("RAM disk at %s is not writable.%n", path));
                        advice.append("Please make sure the RAM disk path is writable");
                        return new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), msg.toString(), advice.toString());
                    }
                    msg.append(String.format("RAM disk is mounted at %s, skip validation.%n", path));
                    return new ValidationTaskResult(ValidationUtils.State.OK, this.getName(), msg.toString(), advice.toString());
                }
            }
            if (!this.checkSudoPrivilege()) {
                msg.append("No sudo privilege to mount ramfs. ");
                advice.append("If you would like to run Alluxio worker without sudo privilege, please visit https://docs.alluxio.io/os/user/stable/en/deploy/Running-Alluxio-Locally.html#can-i-still-try-alluxio-on-linux-without-sudo-privileges");
                return new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), msg.toString(), advice.toString());
            }
        }
        catch (IOException e) {
            msg.append(String.format("Failed to validate ram disk mounting privilege at %s: %s.%n", path, e.getMessage()));
            msg.append(ExceptionUtils.asPlainText((Throwable)e));
            ValidationTaskResult result = new ValidationTaskResult(ValidationUtils.State.FAILED, this.getName(), msg.toString(), advice.toString());
            return result;
        }
        msg.append("Worker has adequate privilege to mount RAM disk.");
        return new ValidationTaskResult(ValidationUtils.State.OK, this.getName(), msg.toString(), advice.toString());
    }

    private boolean checkSudoPrivilege() throws InterruptedException, IOException {
        Process process = Runtime.getRuntime().exec("sudo -v");
        int exitCode = process.waitFor();
        return exitCode == 0;
    }
}

