/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.cli.AbstractValidationTask;
import alluxio.cli.ApplicableUfsType;
import alluxio.cli.ValidationTaskResult;
import alluxio.cli.ValidationUtils;
import java.io.File;
import java.util.Map;
import java.util.StringTokenizer;

@ApplicableUfsType(value=ApplicableUfsType.Type.ALL)
public class NativeLibValidationTask
extends AbstractValidationTask {
    public static final String NATIVE_LIB_PATH = "java.library.path";
    public static final String NATIVE_LIB_PATH_SEPARATOR = ":";

    public String getName() {
        return "ValidateJavaNativeLibPaths";
    }

    private ValidationTaskResult accessNativeLib() {
        String nativeLibPath = System.getProperty(NATIVE_LIB_PATH);
        StringTokenizer parser = new StringTokenizer(nativeLibPath, NATIVE_LIB_PATH_SEPARATOR);
        ValidationUtils.State state = ValidationUtils.State.OK;
        StringBuilder msg = new StringBuilder();
        msg.append(String.format("java.library.path=%s. ", nativeLibPath));
        StringBuilder advice = new StringBuilder();
        while (parser.hasMoreTokens()) {
            String path = parser.nextToken();
            File f = new File(path);
            if (f.exists()) continue;
            state = ValidationUtils.State.WARNING;
            msg.append(String.format("Java native lib not found at %s.%n", path));
            advice.append(String.format("Please check your path %s.%n", path));
        }
        return new ValidationTaskResult(state, this.getName(), msg.toString(), advice.toString());
    }

    public ValidationTaskResult validateImpl(Map<String, String> optionMap) throws InterruptedException {
        return this.accessNativeLib();
    }
}

