/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.cli.ApplicableUfsType;
import alluxio.cli.ValidateEnv;
import alluxio.cli.ValidationTask;
import alluxio.cli.ValidationTaskResult;
import alluxio.cli.ValidationTool;
import alluxio.cli.ValidationUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.util.io.PathUtils;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class HdfsValidationTool
implements ValidationTool {
    private String mUfsPath;
    private UnderFileSystemConfiguration mUfsConf;

    public HdfsValidationTool(String ufsPath, UnderFileSystemConfiguration ufsConf) {
        this.mUfsPath = PathUtils.normalizePath((String)ufsPath, (String)"/");
        this.mUfsConf = ufsConf;
    }

    public Map<String, ValidationTask> getTasks() {
        ValidateEnv env = new ValidateEnv(this.mUfsPath, (AlluxioConfiguration)this.mUfsConf);
        HashMap<String, ValidationTask> tasks = new HashMap<String, ValidationTask>();
        for (Map.Entry<ValidationTask, String> entry : env.getTasks().entrySet()) {
            ApplicableUfsType type;
            ValidationTask task = entry.getKey();
            String taskName = entry.getValue();
            Class<?> clazz = task.getClass();
            if (!clazz.isAnnotationPresent(ApplicableUfsType.class) || (type = clazz.getAnnotation(ApplicableUfsType.class)).value() != ApplicableUfsType.Type.HDFS && type.value() != ApplicableUfsType.Type.ALL) continue;
            tasks.put(taskName, task);
        }
        return tasks;
    }

    protected List<ValidationTaskResult> validateUfs() throws InterruptedException {
        ImmutableMap validateOpts = ImmutableMap.of();
        Map<String, String> desc = new ValidateEnv(this.mUfsPath, (AlluxioConfiguration)this.mUfsConf).getDescription();
        LinkedList<ValidationTaskResult> results = new LinkedList<ValidationTaskResult>();
        for (Map.Entry<String, ValidationTask> entry : this.getTasks().entrySet()) {
            ValidationTaskResult result;
            ValidationTask task = entry.getValue();
            String taskName = entry.getKey();
            try {
                result = task.validate((Map)validateOpts);
            }
            catch (InterruptedException e) {
                result = new ValidationTaskResult(ValidationUtils.State.FAILED, task.getName(), "Task interrupted while running", "");
            }
            if (desc.containsKey(taskName)) {
                result.setDesc(desc.get(taskName));
            }
            results.add(result);
        }
        return results;
    }

    public List<ValidationTaskResult> runAllTests() throws InterruptedException {
        return this.validateUfs();
    }
}

