/*
 * Decompiled with CFR 0.152.
 */
package alluxio.hadoop;

import alluxio.AlluxioURI;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.hadoop.BaseHdfsFileInputStream;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.CanUnbuffer;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.StreamCapabilities;

@NotThreadSafe
public class HdfsFileInputStream
extends BaseHdfsFileInputStream
implements CanUnbuffer,
StreamCapabilities {
    public HdfsFileInputStream(FileSystem fs, AlluxioURI uri, FileSystem.Statistics stats) throws IOException {
        super(fs, uri, stats);
    }

    public HdfsFileInputStream(FileInStream inputStream, FileSystem.Statistics stats) {
        super(inputStream, stats);
    }

    public boolean hasCapability(String capability) {
        return StringUtils.equalsIgnoreCase((CharSequence)"in:unbuffer", (CharSequence)capability) || StringUtils.equalsIgnoreCase((CharSequence)"in:readbytebuffer", (CharSequence)capability);
    }

    public void unbuffer() {
        this.mInputStream.unbuffer();
    }
}

