/*
 * Decompiled with CFR 0.152.
 */
package alluxio.hadoop;

import alluxio.client.file.FileInStream;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.FSDataInputStream;

public class AlluxioHdfsInputStream
extends FileInStream {
    private final FSDataInputStream mInput;

    public AlluxioHdfsInputStream(FSDataInputStream input) {
        this.mInput = (FSDataInputStream)Preconditions.checkNotNull((Object)input, (Object)"null");
    }

    public int read(byte[] bytes) throws IOException {
        return this.mInput.read(bytes);
    }

    public int read(byte[] bytes, int offset, int length) throws IOException {
        return this.mInput.read(bytes, offset, length);
    }

    public int read() throws IOException {
        return this.mInput.read();
    }

    public int read(ByteBuffer buf) throws IOException {
        return this.mInput.read(buf);
    }

    public long skip(long length) throws IOException {
        return this.mInput.skip(length);
    }

    public int available() throws IOException {
        return this.mInput.available();
    }

    public void close() throws IOException {
        this.mInput.close();
    }

    public synchronized void mark(int limit) {
        this.mInput.mark(limit);
    }

    public synchronized void reset() throws IOException {
        this.mInput.reset();
    }

    public boolean markSupported() {
        return this.mInput.markSupported();
    }

    public void seek(long position) throws IOException {
        this.mInput.seek(position);
    }

    public long getPos() throws IOException {
        return this.mInput.getPos();
    }

    public long remaining() {
        throw new UnsupportedOperationException("Remaining is not supported");
    }

    public int positionedRead(long position, byte[] buffer, int offset, int length) throws IOException {
        return this.mInput.read(position, buffer, offset, length);
    }
}

