/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.maven.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.maven.plugin.InstallMojo;
import org.alfresco.maven.plugin.config.ModuleDependency;
import org.alfresco.maven.plugin.config.TomcatDependency;
import org.alfresco.maven.plugin.config.TomcatWebapp;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;
import org.zeroturnaround.zip.ZipUtil;

public abstract class AbstractRunMojo
extends AbstractMojo {
    public static final String MAVEN_DEPENDENCY_PLUGIN_VERSION = "2.10";
    public static final String MAVEN_INSTALL_PLUGIN_VERSION = "2.5.2";
    public static final String MAVEN_REPLACER_PLUGIN_VERSION = "1.5.3";
    public static final String MAVEN_RESOURCE_PLUGIN_VERSION = "2.7";
    public static final String MAVEN_TOMCAT7_PLUGIN_VERSION = "2.2";
    public static final String PLATFORM_WAR_PREFIX_NAME = "platform";
    public static final String SHARE_WAR_PREFIX_NAME = "share";
    @Component
    protected MavenProject project;
    @Component
    protected MavenSession session;
    @Component
    protected BuildPluginManager pluginManager;
    @Parameter(property="maven.alfresco.enablePlatform", defaultValue="true")
    protected boolean enablePlatform;
    @Parameter(property="maven.alfresco.copyHotswapAgentConfig", defaultValue="true")
    protected boolean copyHotswapAgentConfig;
    @Parameter(property="maven.alfresco.enableShare", defaultValue="true")
    protected boolean enableShare;
    @Parameter(property="maven.alfresco.shareContextPath", defaultValue="/share")
    protected String shareContextPath;
    @Parameter(property="maven.alfresco.useCustomShareLog4jConfig", defaultValue="true")
    protected boolean useCustomShareLog4jConfig;
    @Parameter(property="maven.alfresco.enableApiExplorer", defaultValue="false")
    protected boolean enableApiExplorer;
    @Parameter(property="maven.alfresco.enableTestProperties", defaultValue="true")
    protected boolean enableTestProperties;
    @Parameter(property="maven.alfresco.startTomcat", defaultValue="true")
    protected boolean startTomcat;
    @Parameter(property="maven.alfresco.testFolder", defaultValue="src/test/properties/${env}")
    protected String testFolder;
    @Parameter(property="maven.alfresco.testInclude", defaultValue="**")
    protected String testInclude;
    @Parameter(property="maven.alfresco.platform.modules", defaultValue="")
    protected List<ModuleDependency> platformModules;
    @Parameter(property="maven.alfresco.share.modules", defaultValue="")
    protected List<ModuleDependency> shareModules;
    @Parameter(property="maven.alfresco.tomcat.dependencies", defaultValue="")
    protected List<TomcatDependency> tomcatDependencies;
    @Parameter(property="maven.alfresco.tomcat.system.properties", defaultValue="")
    protected Map<String, String> tomcatSystemProperties;
    @Parameter(property="maven.alfresco.tomcat.custom.webapps", defaultValue="")
    protected List<TomcatWebapp> tomcatCustomWebapps;
    @Parameter(property="maven.alfresco.tomcat.port", defaultValue="8080")
    protected String tomcatPort;
    @Parameter(property="maven.tomcat.port", defaultValue="")
    protected String mavenTomcatPort;
    @Parameter(property="alfresco.groupId", defaultValue="org.alfresco")
    protected String alfrescoGroupId;
    @Parameter(property="alfresco.platform.war.artifactId", defaultValue="content-services-community")
    protected String alfrescoPlatformWarArtifactId;
    @Parameter(property="alfresco.share.war.artifactId", defaultValue="share")
    protected String alfrescoShareWarArtifactId;
    @Parameter(property="alfresco.api.explorer.artifactId", defaultValue="api-explorer")
    protected String alfrescoApiExplorerArtifactId;
    @Parameter(property="alfresco.platform.version", defaultValue="6.0.7-ga")
    protected String alfrescoPlatformVersion;
    @Parameter(property="alfresco.share.version", defaultValue="6.0.7-ga")
    protected String alfrescoShareVersion;
    @Parameter(property="alfresco.api.explorer.version", defaultValue="6.0.7-ga")
    protected String alfrescoApiExplorerVersion;
    private String runnerAlfrescoGroupId;
    private String runnerAlfrescoPlatformWarArtifactId;
    private String runnerAlfrescoShareWarArtifactId;
    private String runnerAlfrescoPlatformVersion;
    private String runnerAlfrescoShareVersion;
    protected MojoExecutor.ExecutionEnvironment execEnv;

    protected String getPort() {
        String port = this.tomcatPort;
        if (this.mavenTomcatPort != null) {
            port = this.mavenTomcatPort;
            this.getLog().info((CharSequence)"Tomcat Port overridden by property maven.tomcat.port");
        }
        return port;
    }

    protected boolean tomcatIsRunning() {
        CloseableHttpClient client = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            HttpGet httpget = new HttpGet("http://localhost:" + this.getPort() + "/alfresco");
            response = client.execute((HttpUriRequest)httpget);
            this.getLog().info((CharSequence)("Tomcat is running on port " + this.getPort()));
            return true;
        }
        catch (Exception ex) {
            this.getLog().info((CharSequence)("Tomcat is not running on port " + this.getPort()));
            return false;
        }
    }

    protected void copyAlfrescoGlobalProperties() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Copying and filtering alfresco-global.properties files to target/test-classes");
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-resources-plugin"), (String)MojoExecutor.version((String)MAVEN_RESOURCE_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"copy-resources"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)"${project.build.testOutputDirectory}"), MojoExecutor.element((String)MojoExecutor.name((String)"resources"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"resource"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"directory"), (String)this.testFolder), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)this.testInclude)}), MojoExecutor.element((String)MojoExecutor.name((String)"filtering"), (String)"true")})})}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"com.google.code.maven-replacer-plugin"), (String)MojoExecutor.artifactId((String)"replacer"), (String)MojoExecutor.version((String)MAVEN_REPLACER_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"replace"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"regex"), (String)"false"), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)"${project.build.testOutputDirectory}/*.properties")}), MojoExecutor.element((String)MojoExecutor.name((String)"replacements"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"replacement"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"token"), (String)"alfresco.port=8080"), MojoExecutor.element((String)MojoExecutor.name((String)"value"), (String)("alfresco.port=" + this.getPort()))}), MojoExecutor.element((String)MojoExecutor.name((String)"replacement"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"token"), (String)"share.port=8080"), MojoExecutor.element((String)MojoExecutor.name((String)"value"), (String)("share.port=" + this.getPort()))}), MojoExecutor.element((String)MojoExecutor.name((String)"replacement"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"token"), (String)"solr.port=8080"), MojoExecutor.element((String)MojoExecutor.name((String)"value"), (String)("solr.port=" + this.getPort()))})})}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
    }

    protected void copyAlfrescoLicense() throws MojoExecutionException {
        String warOutputDir = this.getWarOutputDir(PLATFORM_WAR_PREFIX_NAME);
        String licDestDir = warOutputDir + "/WEB-INF/classes/alfresco/extension/license";
        this.getLog().info((CharSequence)("Copying Alfresco Enterprise license to: " + licDestDir));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-resources-plugin"), (String)MojoExecutor.version((String)MAVEN_RESOURCE_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"copy-resources"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)licDestDir), MojoExecutor.element((String)MojoExecutor.name((String)"resources"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"resource"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"directory"), (String)"src/test/license"), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)"*.lic")}), MojoExecutor.element((String)MojoExecutor.name((String)"filtering"), (String)"false")})})}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
    }

    protected void copyShareConfigCustom() throws MojoExecutionException {
        String warOutputDir = this.getWarOutputDir(SHARE_WAR_PREFIX_NAME);
        String distDir = warOutputDir + "/WEB-INF/classes/alfresco/web-extension/";
        String repoUrl = this.project.getProperties().getProperty("alfresco.repo.url");
        if (repoUrl == null) {
            this.project.getProperties().setProperty("alfresco.repo.url", "http://localhost:" + this.getPort() + "/alfresco");
        }
        this.getLog().info((CharSequence)("Copying Share config custom to: " + distDir));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-resources-plugin"), (String)MojoExecutor.version((String)MAVEN_RESOURCE_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"copy-resources"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)distDir), MojoExecutor.element((String)MojoExecutor.name((String)"resources"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"resource"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"directory"), (String)"src/test/resources/share"), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)"*.xml")}), MojoExecutor.element((String)MojoExecutor.name((String)"filtering"), (String)"true")})})}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
    }

    protected void copyShareLog4jConfig() throws MojoExecutionException {
        if (!this.useCustomShareLog4jConfig) {
            this.getLog().info((CharSequence)"NOT overriding share/WEB-INF/classes/log4j2.properties");
            return;
        }
        String warOutputDir = this.getWarOutputDir(SHARE_WAR_PREFIX_NAME);
        String logConfDestDir = warOutputDir + "/WEB-INF/classes";
        this.getLog().info((CharSequence)("Copying Share log4j2.properties to: " + logConfDestDir));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-resources-plugin"), (String)MojoExecutor.version((String)MAVEN_RESOURCE_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"copy-resources"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)logConfDestDir), MojoExecutor.element((String)MojoExecutor.name((String)"resources"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"resource"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"directory"), (String)"src/test/resources/share"), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)"log4j2.properties")}), MojoExecutor.element((String)MojoExecutor.name((String)"filtering"), (String)"true")})})}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
    }

    protected void copyHotswapAgentProperties(String warPrefix) throws MojoExecutionException {
        if (!this.copyHotswapAgentConfig) {
            return;
        }
        String warOutputDir = this.getWarOutputDir(warPrefix) + "/WEB-INF/classes/";
        this.getLog().info((CharSequence)("Copying " + warPrefix + "-hotswap-agent.properties to " + warOutputDir));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"com.coderplus.maven.plugins"), (String)MojoExecutor.artifactId((String)"copy-rename-maven-plugin"), (String)MojoExecutor.version((String)"1.0")), (String)MojoExecutor.goal((String)"rename"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"sourceFile"), (String)(this.project.getBuild().getTestOutputDirectory() + "/" + warPrefix + "-hotswap-agent.properties")), MojoExecutor.element((String)MojoExecutor.name((String)"destinationFile"), (String)(warOutputDir + "hotswap-agent.properties"))}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
    }

    protected void buildPlatformWar() throws MojoExecutionException {
        this.buildCustomWarInDir(PLATFORM_WAR_PREFIX_NAME, this.platformModules, this.alfrescoGroupId, this.alfrescoPlatformWarArtifactId, this.alfrescoPlatformVersion);
        this.copyAlfrescoLicense();
        this.copyHotswapAgentProperties(PLATFORM_WAR_PREFIX_NAME);
        String platformWarArtifactId = this.packageAndInstallCustomWar(PLATFORM_WAR_PREFIX_NAME);
        this.runnerAlfrescoGroupId = "${project.groupId}";
        this.runnerAlfrescoPlatformWarArtifactId = platformWarArtifactId;
        this.runnerAlfrescoPlatformVersion = "${project.version}";
    }

    protected void buildShareWar() throws MojoExecutionException {
        this.buildCustomWarInDir(SHARE_WAR_PREFIX_NAME, this.shareModules, this.alfrescoGroupId, this.alfrescoShareWarArtifactId, this.alfrescoShareVersion);
        this.copyShareLog4jConfig();
        this.copyShareConfigCustom();
        this.copyHotswapAgentProperties(SHARE_WAR_PREFIX_NAME);
        String shareWarArtifactId = this.packageAndInstallCustomWar(SHARE_WAR_PREFIX_NAME);
        this.runnerAlfrescoGroupId = "${project.groupId}";
        this.runnerAlfrescoShareWarArtifactId = shareWarArtifactId;
        this.runnerAlfrescoShareVersion = "${project.version}";
    }

    protected void buildCustomWarInDir(String warName, List<ModuleDependency> modules, String originalWarGroupId, String originalWarArtifactId, String originalWarVersion) throws MojoExecutionException {
        String warOutputDir = this.getWarOutputDir(warName);
        String ampsModuleDir = "modules/" + warName + "/amps";
        String ampsOutputDir = "${project.build.directory}/" + ampsModuleDir;
        ArrayList<MojoExecutor.Element> ampModules = new ArrayList<MojoExecutor.Element>();
        ArrayList<MojoExecutor.Element> jarModules = new ArrayList<MojoExecutor.Element>();
        if (modules != null && modules.size() > 0) {
            for (ModuleDependency moduleDep : modules) {
                MojoExecutor.Element el = MojoExecutor.element((String)MojoExecutor.name((String)"artifactItem"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"groupId"), (String)moduleDep.getGroupId()), MojoExecutor.element((String)MojoExecutor.name((String)"artifactId"), (String)moduleDep.getArtifactId()), MojoExecutor.element((String)MojoExecutor.name((String)"version"), (String)moduleDep.getVersion()), MojoExecutor.element((String)MojoExecutor.name((String)"classifier"), (String)moduleDep.getClassifier()), MojoExecutor.element((String)MojoExecutor.name((String)"type"), (String)moduleDep.getType()), MojoExecutor.element((String)MojoExecutor.name((String)"overWrite"), (String)"true")});
                if (moduleDep.getArtifactId().equalsIgnoreCase("alfresco-share-services") && !this.isPlatformVersionGtOrEqTo51()) {
                    this.getLog().info((CharSequence)"Skipping alfresco-share-services, only needed for 5.1+");
                    continue;
                }
                if (moduleDep.isAmp()) {
                    ampModules.add(el);
                    continue;
                }
                if (moduleDep.isJar()) {
                    jarModules.add(el);
                    continue;
                }
                throw new MojoExecutionException("Unknown module type: " + moduleDep.getType() + " when building custom " + warName + " war, only 'jar' and 'amp' types are allowed");
            }
        }
        MojoExecutor.Element[] ampModuleArray = new MojoExecutor.Element[ampModules.size()];
        ampModules.toArray(ampModuleArray);
        MojoExecutor.Element[] jarModuleArray = new MojoExecutor.Element[jarModules.size()];
        jarModules.toArray(jarModuleArray);
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)MAVEN_DEPENDENCY_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"unpack"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)warOutputDir), MojoExecutor.element((String)MojoExecutor.name((String)"artifactItems"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"artifactItem"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"groupId"), (String)originalWarGroupId), MojoExecutor.element((String)MojoExecutor.name((String)"artifactId"), (String)originalWarArtifactId), MojoExecutor.element((String)MojoExecutor.name((String)"version"), (String)originalWarVersion), MojoExecutor.element((String)MojoExecutor.name((String)"type"), (String)"war")})})}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
        if (ampModuleArray.length > 0) {
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)MAVEN_DEPENDENCY_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"copy"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)ampsOutputDir), MojoExecutor.element((String)MojoExecutor.name((String)"artifactItems"), (MojoExecutor.Element[])ampModuleArray)}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
            String ampsLocation = this.project.getBuild().getDirectory() + "/" + ampsModuleDir;
            String warLocation = this.project.getBuild().getDirectory() + "/" + this.getWarName(warName);
            InstallMojo installMojo = new InstallMojo();
            installMojo.setAmpLocation(new File(ampsLocation));
            installMojo.setWarLocation(new File(warLocation));
            installMojo.setForce(true);
            try {
                installMojo.execute();
            }
            catch (MojoFailureException e) {
                e.printStackTrace();
            }
        }
        if (jarModuleArray.length > 0) {
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)MAVEN_DEPENDENCY_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"copy"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)(warOutputDir + "/WEB-INF/lib")), MojoExecutor.element((String)MojoExecutor.name((String)"artifactItems"), (MojoExecutor.Element[])jarModuleArray)}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
        }
    }

    protected String packageAndInstallCustomWar(String warName) throws MojoExecutionException {
        String warArtifactId = "${project.artifactId}-" + warName;
        String warSourceDir = this.getWarOutputDir(warName);
        String warPath = this.project.getBuild().getDirectory() + "/" + warName + ".war";
        ZipUtil.pack((File)new File(warSourceDir), (File)new File(warPath));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-install-plugin"), (String)MojoExecutor.version((String)MAVEN_INSTALL_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"install-file"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"file"), (String)warPath), MojoExecutor.element((String)MojoExecutor.name((String)"groupId"), (String)"${project.groupId}"), MojoExecutor.element((String)MojoExecutor.name((String)"artifactId"), (String)warArtifactId), MojoExecutor.element((String)MojoExecutor.name((String)"version"), (String)"${project.version}"), MojoExecutor.element((String)MojoExecutor.name((String)"packaging"), (String)"war")}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
        return warArtifactId;
    }

    protected void startTomcat(boolean fork) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Starting Tomcat, fork = " + fork));
        ArrayList<Dependency> tomcatPluginDependencies = new ArrayList<Dependency>();
        ArrayList<MojoExecutor.Element> webapps2Deploy = new ArrayList<MojoExecutor.Element>();
        tomcatPluginDependencies.add(MojoExecutor.dependency((String)"org.codehaus.plexus", (String)"plexus-archiver", (String)"2.3"));
        tomcatPluginDependencies.add(MojoExecutor.dependency((String)"javax.servlet", (String)"javax.servlet-api", (String)"3.0.1"));
        if (this.tomcatDependencies != null && this.tomcatDependencies.size() > 0) {
            for (TomcatDependency tomcatDep : this.tomcatDependencies) {
                tomcatPluginDependencies.add(MojoExecutor.dependency((String)tomcatDep.getGroupId(), (String)tomcatDep.getArtifactId(), (String)tomcatDep.getVersion()));
            }
        }
        tomcatPluginDependencies.add(MojoExecutor.dependency((String)"mysql", (String)"mysql-connector-java", (String)"5.1.32"));
        tomcatPluginDependencies.add(MojoExecutor.dependency((String)"org.postgresql", (String)"postgresql", (String)"9.4-1201-jdbc41"));
        if (this.enablePlatform) {
            webapps2Deploy.add(this.createWebAppElement(this.runnerAlfrescoGroupId, this.runnerAlfrescoPlatformWarArtifactId, this.runnerAlfrescoPlatformVersion, "/alfresco", null));
        }
        if (this.enableShare) {
            webapps2Deploy.add(this.createWebAppElement(this.runnerAlfrescoGroupId, this.runnerAlfrescoShareWarArtifactId, this.runnerAlfrescoShareVersion, this.shareContextPath, null));
        }
        if (this.enableApiExplorer) {
            webapps2Deploy.add(this.createWebAppElement(this.alfrescoGroupId, this.alfrescoApiExplorerArtifactId, this.alfrescoApiExplorerVersion, "/api-explorer", null));
        }
        if (this.tomcatCustomWebapps != null && !this.tomcatCustomWebapps.isEmpty()) {
            for (TomcatWebapp customWebapp : this.tomcatCustomWebapps) {
                webapps2Deploy.add(this.createWebAppElement(customWebapp.getGroupId(), customWebapp.getArtifactId(), customWebapp.getVersion(), customWebapp.getContextPath(), customWebapp.getContextFile()));
            }
        }
        MojoExecutor.Element[] webapps = new MojoExecutor.Element[webapps2Deploy.size()];
        webapps2Deploy.toArray(webapps);
        ArrayList<MojoExecutor.Element> systemProps = new ArrayList<MojoExecutor.Element>();
        if (this.tomcatSystemProperties != null && !this.tomcatSystemProperties.isEmpty()) {
            for (Map.Entry<String, String> sysProp : this.tomcatSystemProperties.entrySet()) {
                systemProps.add(MojoExecutor.element((String)MojoExecutor.name((String)sysProp.getKey()), (String)sysProp.getValue()));
            }
        }
        MojoExecutor.Element[] systemPropArray = new MojoExecutor.Element[systemProps.size()];
        systemProps.toArray(systemPropArray);
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.tomcat.maven"), (String)MojoExecutor.artifactId((String)"tomcat7-maven-plugin"), (String)MojoExecutor.version((String)MAVEN_TOMCAT7_PLUGIN_VERSION), tomcatPluginDependencies), (String)MojoExecutor.goal((String)"run"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"fork"), (String)(fork ? "true" : "false")), MojoExecutor.element((String)MojoExecutor.name((String)"path"), (String)"/"), MojoExecutor.element((String)MojoExecutor.name((String)"port"), (String)this.getPort()), MojoExecutor.element((String)MojoExecutor.name((String)"ignorePackaging"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"useSeparateTomcatClassLoader"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"useTestClasspath"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"systemProperties"), (MojoExecutor.Element[])systemPropArray), MojoExecutor.element((String)MojoExecutor.name((String)"delegate"), (String)"false"), MojoExecutor.element((String)MojoExecutor.name((String)"uriEncoding"), (String)"UTF-8"), MojoExecutor.element((String)MojoExecutor.name((String)"webapps"), (MojoExecutor.Element[])webapps)}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
    }

    private MojoExecutor.Element createWebAppElement(String groupId, String artifactId, String version, String contextPath, String contextFile) {
        String errorStr = "cannot be null when creating webapp element for Tomcat 7 plugin";
        if (StringUtils.isBlank((String)groupId)) {
            this.getLog().error((CharSequence)("Maven Group Id " + errorStr));
        }
        if (StringUtils.isBlank((String)artifactId)) {
            this.getLog().error((CharSequence)("Maven Artifact Id " + errorStr));
        }
        if (StringUtils.isBlank((String)version)) {
            this.getLog().error((CharSequence)("Maven Version number " + errorStr));
        }
        MojoExecutor.Element groupIdEl = MojoExecutor.element((String)MojoExecutor.name((String)"groupId"), (String)groupId);
        MojoExecutor.Element artifactIdEl = MojoExecutor.element((String)MojoExecutor.name((String)"artifactId"), (String)artifactId);
        MojoExecutor.Element versionEl = MojoExecutor.element((String)MojoExecutor.name((String)"version"), (String)version);
        MojoExecutor.Element typeEl = MojoExecutor.element((String)MojoExecutor.name((String)"type"), (String)"war");
        MojoExecutor.Element asWebappEl = MojoExecutor.element((String)MojoExecutor.name((String)"asWebapp"), (String)"true");
        MojoExecutor.Element contextPathEl = MojoExecutor.element((String)MojoExecutor.name((String)"contextPath"), (String)contextPath);
        MojoExecutor.Element e = StringUtils.isNotBlank((String)contextFile) ? MojoExecutor.element((String)MojoExecutor.name((String)"webapp"), (MojoExecutor.Element[])new MojoExecutor.Element[]{groupIdEl, artifactIdEl, versionEl, typeEl, asWebappEl, contextPathEl, MojoExecutor.element((String)MojoExecutor.name((String)"contextFile"), (String)contextFile)}) : MojoExecutor.element((String)MojoExecutor.name((String)"webapp"), (MojoExecutor.Element[])new MojoExecutor.Element[]{groupIdEl, artifactIdEl, versionEl, typeEl, asWebappEl, contextPathEl});
        this.getLog().info((CharSequence)e.toDom().toUnescapedString());
        return e;
    }

    private boolean isPlatformVersionGtOrEqTo51() {
        return this.getPlatformVersionNumber() >= 51;
    }

    private boolean isPlatformVersionLtOrEqTo42() {
        return this.getPlatformVersionNumber() <= 42;
    }

    private int getPlatformVersionNumber() {
        return Integer.parseInt(this.alfrescoPlatformVersion.replaceAll("[^0-9]", "").substring(0, 2));
    }

    private String getWarOutputDir(String baseWarName) {
        return this.project.getBuild().getDirectory() + "/" + this.getWarName(baseWarName);
    }

    private String getWarName(String baseWarName) {
        return baseWarName + "-war";
    }
}

