/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.maven.plugin;

import java.util.List;
import java.util.Properties;
import org.alfresco.maven.plugin.AbstractRunMojo;
import org.alfresco.maven.plugin.config.ModuleDependency;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="it", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, aggregator=true, requiresDependencyResolution=ResolutionScope.TEST)
public class IntegrationTestMojo
extends AbstractRunMojo {
    public void execute() throws MojoExecutionException {
        boolean skipThisMojo;
        this.execEnv = MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager);
        Properties sysProperties = this.execEnv.getMavenSession().getSystemProperties();
        boolean bl = skipThisMojo = sysProperties.containsKey("skipTests") || sysProperties.containsKey("skipITs") || sysProperties.containsKey("maven.test.skip");
        if (skipThisMojo) {
            this.getLog().info((CharSequence)"Skipping integration testing.");
            return;
        }
        List goals = this.execEnv.getMavenSession().getGoals();
        if (goals.contains("alfresco:run")) {
            sysProperties.put("skipTests", "true");
            this.getLog().info((CharSequence)"Skipping integration testing as alfresco:run is active.");
            return;
        }
        this.getLog().info((CharSequence)"Checking if Tomcat is already running on port ");
        if (!this.tomcatIsRunning()) {
            if (this.enableSolr) {
                this.unpackSolrConfig();
                this.fixSolrHomePath();
                this.replaceSolrConfigProperties();
                this.installSolr10InLocalRepo();
            }
            if (this.enableTestProperties && this.enablePlatform) {
                this.copyAlfrescoGlobalProperties();
                this.renameAlfrescoGlobalProperties();
            }
            Object testJarArtifactId = null;
            if (this.enablePlatform) {
                this.platformModules.add(new ModuleDependency("org.alfresco.maven", "alfresco-rad", "${alfresco.sdk.version}", "jar"));
                this.buildPlatformWar();
            }
            if (this.enableShare) {
                this.buildShareWar();
            }
            if (this.enableActivitiApp) {
                this.buildActivitiAppWar();
            }
            if (this.startTomcat) {
                boolean fork = true;
                this.startTomcat(fork);
            }
        }
    }
}

