/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.maven.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.maven.plugin.InstallMojo;
import org.alfresco.maven.plugin.config.ModuleDependency;
import org.alfresco.maven.plugin.config.TomcatDependency;
import org.alfresco.maven.plugin.config.TomcatWebapp;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;
import org.zeroturnaround.zip.ZipUtil;

public abstract class AbstractRunMojo
extends AbstractMojo {
    public static final String MAVEN_DEPENDENCY_PLUGIN_VERSION = "2.10";
    public static final String MAVEN_INSTALL_PLUGIN_VERSION = "2.5.2";
    public static final String MAVEN_REPLACER_PLUGIN_VERSION = "1.5.3";
    public static final String MAVEN_RESOURCE_PLUGIN_VERSION = "2.7";
    public static final String MAVEN_TOMCAT7_PLUGIN_VERSION = "2.2";
    public static final String MAVEN_BUILD_HELPER_PLUGIN_VERSION = "1.12";
    public static final String PLATFORM_WAR_PREFIX_NAME = "platform";
    public static final String SHARE_WAR_PREFIX_NAME = "share";
    public static final String ACTIVITI_APP_WAR_PREFIX_NAME = "activitiApp";
    public static final String ALFRESCO_ENTERPRISE_EDITION = "enterprise";
    public static final String ALFRESCO_COMMUNITY_EDITION = "community";
    @Component
    protected MavenProject project;
    @Component
    protected MavenSession session;
    @Component
    protected BuildPluginManager pluginManager;
    @Parameter(property="reactorProjects", required=true, readonly=true)
    protected List<MavenProject> reactorProjects;
    @Parameter(property="maven.alfresco.enableSolr", defaultValue="true")
    protected boolean enableSolr;
    @Parameter(property="maven.alfresco.enableH2", defaultValue="false")
    protected boolean enableH2;
    @Parameter(property="maven.alfresco.enableMySQL", defaultValue="false")
    protected boolean enableMySQL;
    @Parameter(property="maven.alfresco.enablePostgreSQL", defaultValue="false")
    protected boolean enablePostgreSQL;
    @Parameter(property="maven.alfresco.enableEnterpriseDb", defaultValue="false")
    protected boolean enableEnterpriseDb;
    @Parameter(property="maven.alfresco.enablePlatform", defaultValue="true")
    protected boolean enablePlatform;
    @Parameter(property="maven.alfresco.copyHotswapAgentConfig", defaultValue="true")
    protected boolean copyHotswapAgentConfig;
    @Parameter(property="maven.alfresco.enableShare", defaultValue="true")
    protected boolean enableShare;
    @Parameter(property="maven.alfresco.shareContextPath", defaultValue="/share")
    protected String shareContextPath;
    @Parameter(property="maven.alfresco.useCustomShareLog4jConfig", defaultValue="true")
    protected boolean useCustomShareLog4jConfig;
    @Parameter(property="maven.alfresco.enableApiExplorer", defaultValue="false")
    protected boolean enableApiExplorer;
    @Parameter(property="maven.alfresco.enableActivitiApp", defaultValue="false")
    protected boolean enableActivitiApp;
    @Parameter(property="maven.alfresco.enableActivitiAdmin", defaultValue="false")
    protected boolean enableActivitiAdmin;
    @Parameter(property="maven.alfresco.enableTestProperties", defaultValue="true")
    protected boolean enableTestProperties;
    @Parameter(property="maven.alfresco.startTomcat", defaultValue="true")
    protected boolean startTomcat;
    @Parameter(property="maven.alfresco.testFolder", defaultValue="src/test/properties/${env}")
    protected String testFolder;
    @Parameter(property="maven.alfresco.testInclude", defaultValue="**")
    protected String testInclude;
    @Parameter(property="maven.alfresco.platform.modules", defaultValue="")
    protected List<ModuleDependency> platformModules;
    @Parameter(property="maven.alfresco.share.modules", defaultValue="")
    protected List<ModuleDependency> shareModules;
    @Parameter(property="maven.activiti.modules", defaultValue="")
    protected List<ModuleDependency> activitiModules;
    @Parameter(property="maven.alfresco.edition", defaultValue="community")
    protected String alfrescoEdition;
    @Parameter(property="maven.alfresco.tomcat.dependencies", defaultValue="")
    protected List<TomcatDependency> tomcatDependencies;
    @Parameter(property="maven.alfresco.tomcat.system.properties", defaultValue="")
    protected Map<String, String> tomcatSystemProperties;
    @Parameter(property="maven.alfresco.tomcat.custom.webapps", defaultValue="")
    protected List<TomcatWebapp> tomcatCustomWebapps;
    @Parameter(property="maven.alfresco.tomcat.port", defaultValue="8080")
    protected String tomcatPort;
    @Parameter(property="maven.tomcat.port", defaultValue="")
    protected String mavenTomcatPort;
    @Parameter(property="alfresco.groupId", defaultValue="org.alfresco")
    protected String alfrescoGroupId;
    @Parameter(property="activiti.groupId", defaultValue="com.activiti")
    protected String activitiGroupId;
    @Parameter(property="alfresco.platform.war.artifactId", defaultValue="alfresco-platform")
    protected String alfrescoPlatformWarArtifactId;
    @Parameter(property="alfresco.share.war.artifactId", defaultValue="share")
    protected String alfrescoShareWarArtifactId;
    @Parameter(property="alfresco.solr.artifactId", defaultValue="alfresco-solr4")
    protected String alfrescoSolrArtifactId;
    @Parameter(property="alfresco.api.explorer.artifactId", defaultValue="api-explorer")
    protected String alfrescoApiExplorerArtifactId;
    @Parameter(property="activiti.app.war.artifactId", defaultValue="activiti-app")
    protected String activitiAppWarArtifactId;
    @Parameter(property="activiti.admin.war.artifactId", defaultValue="activiti-admin")
    protected String activitiAdminWarArtifactId;
    @Parameter(property="alfresco.platform.version", defaultValue="5.2.f")
    protected String alfrescoPlatformVersion;
    @Parameter(property="alfresco.share.version", defaultValue="5.2.e")
    protected String alfrescoShareVersion;
    @Parameter(property="alfresco.api.explorer.version", defaultValue="5.2.e")
    protected String alfrescoApiExplorerVersion;
    @Parameter(property="activiti.version", defaultValue="1.5.3")
    protected String activitiVersion;
    @Parameter(property="solr.home", defaultValue="${project.basedir}/${alfresco.data.location}/solr")
    protected String solrHome;
    private String runnerAlfrescoGroupId;
    private String runnerAlfrescoPlatformWarArtifactId;
    private String runnerAlfrescoShareWarArtifactId;
    private String runnerAlfrescoPlatformVersion;
    private String runnerAlfrescoShareVersion;
    private String runnerActivitiAppGroupId;
    private String runnerActivitiAppWarArtifactId;
    private String runnerActivitiAppVersion;
    protected MojoExecutor.ExecutionEnvironment execEnv;

    protected String getPort() {
        String port = this.tomcatPort;
        if (this.mavenTomcatPort != null) {
            port = this.mavenTomcatPort;
            this.getLog().info((CharSequence)"Tomcat Port overridden by property maven.tomcat.port");
        }
        return port;
    }

    protected boolean tomcatIsRunning() {
        CloseableHttpClient client = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            HttpGet httpget = new HttpGet("http://localhost:" + this.getPort() + "/alfresco");
            response = client.execute((HttpUriRequest)httpget);
            this.getLog().info((CharSequence)("Tomcat is running on port " + this.getPort()));
            return true;
        }
        catch (Exception ex) {
            this.getLog().info((CharSequence)("Tomcat is not running on port " + this.getPort()));
            return false;
        }
    }

    protected void unpackSolrConfig() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Unpacking Solr config");
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)MAVEN_DEPENDENCY_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"unpack"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)this.solrHome), MojoExecutor.element((String)MojoExecutor.name((String)"artifactItems"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"artifactItem"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"groupId"), (String)this.alfrescoGroupId), MojoExecutor.element((String)MojoExecutor.name((String)"artifactId"), (String)this.getSolrArtifactId()), MojoExecutor.element((String)MojoExecutor.name((String)"version"), (String)this.alfrescoPlatformVersion), this.isPlatformVersionLtOrEqTo42() ? MojoExecutor.element((String)MojoExecutor.name((String)"classifier"), (String)"") : MojoExecutor.element((String)MojoExecutor.name((String)"classifier"), (String)"config"), MojoExecutor.element((String)MojoExecutor.name((String)"type"), (String)"zip")})})}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
    }

    protected void fixSolrHomePath() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Fix Solr Home Path to work in Windows");
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.codehaus.mojo"), (String)MojoExecutor.artifactId((String)"build-helper-maven-plugin"), (String)MojoExecutor.version((String)MAVEN_BUILD_HELPER_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"regex-property"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"name"), (String)"solrDataDir"), MojoExecutor.element((String)MojoExecutor.name((String)"value"), (String)this.solrHome), MojoExecutor.element((String)MojoExecutor.name((String)"regex"), (String)"\\\\"), MojoExecutor.element((String)MojoExecutor.name((String)"replacement"), (String)"/"), MojoExecutor.element((String)MojoExecutor.name((String)"failIfNoMatch"), (String)"false")}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
    }

    protected void replaceSolrConfigProperties() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Replacing Solr config properties");
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"com.google.code.maven-replacer-plugin"), (String)MojoExecutor.artifactId((String)"replacer"), (String)MojoExecutor.version((String)MAVEN_REPLACER_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"replace"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"regex"), (String)"false"), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)(this.solrHome + "/archive-SpacesStore/conf/solrcore.properties")), MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)(this.solrHome + "/workspace-SpacesStore/conf/solrcore.properties"))}), MojoExecutor.element((String)MojoExecutor.name((String)"replacements"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"replacement"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"token"), (String)"@@ALFRESCO_SOLR4_DATA_DIR@@"), MojoExecutor.element((String)MojoExecutor.name((String)"value"), (String)"${solrDataDir}/index")}), MojoExecutor.element((String)MojoExecutor.name((String)"replacement"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"token"), (String)"@@ALFRESCO_SOLR_DIR@@"), MojoExecutor.element((String)MojoExecutor.name((String)"value"), (String)"${solrDataDir}/index")}), MojoExecutor.element((String)MojoExecutor.name((String)"replacement"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"token"), (String)"alfresco.port=8080"), MojoExecutor.element((String)MojoExecutor.name((String)"value"), (String)("alfresco.port=" + this.getPort()))}), MojoExecutor.element((String)MojoExecutor.name((String)"replacement"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"token"), (String)"alfresco.secureComms=https"), MojoExecutor.element((String)MojoExecutor.name((String)"value"), (String)"alfresco.secureComms=none")})})}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
    }

    protected void installSolr10InLocalRepo() throws MojoExecutionException {
        if (this.isPlatformVersionLtOrEqTo42()) {
            this.getLog().info((CharSequence)"Installing Solr 1.0 WAR in local Maven repo");
            File solrWarSource = new File(this.solrHome + "/apache-solr-1.4.1.war");
            File outputDir = new File(this.project.getBuild().getDirectory() + "/solr");
            if (outputDir.exists()) {
                this.getLog().info((CharSequence)("Solr build dir: " + outputDir + " already exists, not rebuilding"));
                return;
            }
            ZipUtil.unpack((File)solrWarSource, (File)outputDir);
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"com.google.code.maven-replacer-plugin"), (String)MojoExecutor.artifactId((String)"replacer"), (String)MojoExecutor.version((String)MAVEN_REPLACER_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"replace"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"regex"), (String)"false"), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)(outputDir + "/WEB-INF/web.xml"))}), MojoExecutor.element((String)MojoExecutor.name((String)"replacements"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"replacement"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"token"), (String)"<!-- <security-constraint>"), MojoExecutor.element((String)MojoExecutor.name((String)"value"), (String)"<security-constraint>")}), MojoExecutor.element((String)MojoExecutor.name((String)"replacement"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"token"), (String)"</security-role> -->"), MojoExecutor.element((String)MojoExecutor.name((String)"value"), (String)"</security-role>")}), MojoExecutor.element((String)MojoExecutor.name((String)"replacement"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"token"), (String)"<security-constraint>"), MojoExecutor.element((String)MojoExecutor.name((String)"value"), (String)"<!-- <security-constraint>")}), MojoExecutor.element((String)MojoExecutor.name((String)"replacement"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"token"), (String)"</security-role>"), MojoExecutor.element((String)MojoExecutor.name((String)"value"), (String)"</security-role> -->")})})}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"com.coderplus.maven.plugins"), (String)MojoExecutor.artifactId((String)"copy-rename-maven-plugin"), (String)MojoExecutor.version((String)"1.0")), (String)MojoExecutor.goal((String)"copy"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"sourceFile"), (String)(this.solrHome + "/log4j-solr.properties")), MojoExecutor.element((String)MojoExecutor.name((String)"destinationFile"), (String)(outputDir + "/WEB-INF/classes/log4j.properties"))}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-resources-plugin"), (String)MojoExecutor.version((String)MAVEN_RESOURCE_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"copy-resources"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)(outputDir + "/WEB-INF/lib")), MojoExecutor.element((String)MojoExecutor.name((String)"resources"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"resource"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"directory"), (String)(this.solrHome + "/lib")), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)"*org.springframework*")}), MojoExecutor.element((String)MojoExecutor.name((String)"filtering"), (String)"false")})})}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
            ZipUtil.pack((File)outputDir, (File)new File(this.solrHome + "/apache-solr-1.4.1.war"));
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-install-plugin"), (String)MojoExecutor.version((String)MAVEN_INSTALL_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"install-file"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"file"), (String)(this.solrHome + "/apache-solr-1.4.1.war")), MojoExecutor.element((String)MojoExecutor.name((String)"groupId"), (String)"${project.groupId}"), MojoExecutor.element((String)MojoExecutor.name((String)"artifactId"), (String)this.getSolrArtifactId()), MojoExecutor.element((String)MojoExecutor.name((String)"version"), (String)"${project.version}"), MojoExecutor.element((String)MojoExecutor.name((String)"packaging"), (String)"war")}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
        }
    }

    protected void commentOutSecureCommsInPlatformWebXml() throws MojoExecutionException {
        if (this.isPlatformVersionGtOrEqTo51()) {
            return;
        }
        String webInfPath = this.getWarOutputDir(PLATFORM_WAR_PREFIX_NAME) + "/WEB-INF/";
        String webXmlFilePath = webInfPath + "web.xml";
        this.getLog().info((CharSequence)("Commenting out the security-constraints in " + webXmlFilePath));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"com.google.code.maven-replacer-plugin"), (String)MojoExecutor.artifactId((String)"replacer"), (String)MojoExecutor.version((String)MAVEN_REPLACER_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"replace"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"ignoreErrors"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"file"), (String)webXmlFilePath), MojoExecutor.element((String)MojoExecutor.name((String)"outputDir"), (String)webInfPath), MojoExecutor.element((String)MojoExecutor.name((String)"preserveDir"), (String)"false"), MojoExecutor.element((String)MojoExecutor.name((String)"replacements"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"replacement"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"token"), (String)"<!-- Toggle securecomms placeholder start -->"), MojoExecutor.element((String)MojoExecutor.name((String)"value"), (String)"<!-- ")}), MojoExecutor.element((String)MojoExecutor.name((String)"replacement"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"token"), (String)"<!-- Toggle securecomms placeholder end -->"), MojoExecutor.element((String)MojoExecutor.name((String)"value"), (String)" -->")})})}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
    }

    protected void copyAlfrescoGlobalProperties() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Copying and filtering alfresco-global-*.properties files to target/test-classes");
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-resources-plugin"), (String)MojoExecutor.version((String)MAVEN_RESOURCE_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"copy-resources"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)"${project.build.testOutputDirectory}"), MojoExecutor.element((String)MojoExecutor.name((String)"resources"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"resource"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"directory"), (String)this.testFolder), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)this.testInclude)}), MojoExecutor.element((String)MojoExecutor.name((String)"filtering"), (String)"true")})})}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"com.google.code.maven-replacer-plugin"), (String)MojoExecutor.artifactId((String)"replacer"), (String)MojoExecutor.version((String)MAVEN_REPLACER_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"replace"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"regex"), (String)"false"), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)"${project.build.testOutputDirectory}/*.properties")}), MojoExecutor.element((String)MojoExecutor.name((String)"replacements"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"replacement"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"token"), (String)"alfresco.port=8080"), MojoExecutor.element((String)MojoExecutor.name((String)"value"), (String)("alfresco.port=" + this.getPort()))}), MojoExecutor.element((String)MojoExecutor.name((String)"replacement"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"token"), (String)"share.port=8080"), MojoExecutor.element((String)MojoExecutor.name((String)"value"), (String)("share.port=" + this.getPort()))}), MojoExecutor.element((String)MojoExecutor.name((String)"replacement"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"token"), (String)"solr.port=8080"), MojoExecutor.element((String)MojoExecutor.name((String)"value"), (String)("solr.port=" + this.getPort()))})})}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
        if (this.isPlatformVersionLtOrEqTo42() && this.enableSolr) {
            this.getLog().info((CharSequence)"Platform is 4.2 and Solr is enabled, setting 'index.subsystem.name=solr' in alfresco-global.properties");
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"com.google.code.maven-replacer-plugin"), (String)MojoExecutor.artifactId((String)"replacer"), (String)MojoExecutor.version((String)MAVEN_REPLACER_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"replace"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"regex"), (String)"false"), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)"${project.build.testOutputDirectory}/*.properties")}), MojoExecutor.element((String)MojoExecutor.name((String)"replacements"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"replacement"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"token"), (String)"index.subsystem.name=solr4"), MojoExecutor.element((String)MojoExecutor.name((String)"value"), (String)"index.subsystem.name=solr")}), MojoExecutor.element((String)MojoExecutor.name((String)"replacement"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"token"), (String)"index.subsystem.name=lucene"), MojoExecutor.element((String)MojoExecutor.name((String)"value"), (String)"index.subsystem.name=solr")})})}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
        }
    }

    protected void renameAlfrescoGlobalProperties() throws MojoExecutionException {
        String alfrescoGlobalFilePath = this.project.getBuild().getTestOutputDirectory() + "/alfresco-global-";
        if (this.enableH2) {
            alfrescoGlobalFilePath = alfrescoGlobalFilePath + "h2.properties";
            this.getLog().info((CharSequence)"Renaming alfresco-global-h2.properties to alfresco-global.properties");
        } else if (this.enableMySQL) {
            alfrescoGlobalFilePath = alfrescoGlobalFilePath + "mysql.properties";
            this.getLog().info((CharSequence)"Renaming alfresco-global-mysql.properties to alfresco-global.properties");
        } else if (this.enablePostgreSQL) {
            alfrescoGlobalFilePath = alfrescoGlobalFilePath + "postgresql.properties";
            this.getLog().info((CharSequence)"Renaming alfresco-global-postgresql.properties to alfresco-global.properties");
        } else if (this.enableEnterpriseDb) {
            alfrescoGlobalFilePath = alfrescoGlobalFilePath + "enterprise.properties";
            this.getLog().info((CharSequence)"Renaming alfresco-global-enterprise.properties to alfresco-global.properties");
        } else {
            throw new MojoExecutionException("Invalid database configuration, use enableH2, enableMySQL, enablePostgreSQL, or enabaleEnterpriseDb");
        }
        if (!FileUtils.fileExists((String)alfrescoGlobalFilePath)) {
            throw new MojoExecutionException("Missing file: " + alfrescoGlobalFilePath + ", when converting from older " + "SDK versions generate an SDK 3 AIO or Platform JAR project and copy " + "alfresco-global-*.properties files from it. Then configure any custom settings from old SDK " + "project repo/src/main/properties/local/alfresco-global.properties file in the new " + "alfresco-global-h2.properties file, or other config file corresponding to the database you are using.");
        }
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"com.coderplus.maven.plugins"), (String)MojoExecutor.artifactId((String)"copy-rename-maven-plugin"), (String)MojoExecutor.version((String)"1.0")), (String)MojoExecutor.goal((String)"rename"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"sourceFile"), (String)alfrescoGlobalFilePath), MojoExecutor.element((String)MojoExecutor.name((String)"destinationFile"), (String)"${project.build.testOutputDirectory}/alfresco-global.properties")}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
    }

    protected void copyAlfrescoLicense() throws MojoExecutionException {
        if (this.alfrescoEdition.equals(ALFRESCO_COMMUNITY_EDITION)) {
            this.getLog().info((CharSequence)"NOT copying Alfresco Enterprise license, running Community edition");
            return;
        }
        String warOutputDir = this.getWarOutputDir(PLATFORM_WAR_PREFIX_NAME);
        String licDestDir = warOutputDir + "/WEB-INF/classes/alfresco/extension/license";
        this.getLog().info((CharSequence)("Copying Alfresco Enterprise license to: " + licDestDir));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-resources-plugin"), (String)MojoExecutor.version((String)MAVEN_RESOURCE_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"copy-resources"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)licDestDir), MojoExecutor.element((String)MojoExecutor.name((String)"resources"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"resource"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"directory"), (String)"src/test/license"), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)"*.lic")}), MojoExecutor.element((String)MojoExecutor.name((String)"filtering"), (String)"false")})})}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
    }

    protected void copyActivitiLog4JDevConfig() throws MojoExecutionException {
        String warOutputDir = this.getWarOutputDir(ACTIVITI_APP_WAR_PREFIX_NAME);
        String logConfDestDir = warOutputDir + "/WEB-INF/classes";
        this.getLog().info((CharSequence)("Copying Activiti log4j-dev.properties to: " + logConfDestDir));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-resources-plugin"), (String)MojoExecutor.version((String)MAVEN_RESOURCE_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"copy-resources"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)logConfDestDir), MojoExecutor.element((String)MojoExecutor.name((String)"resources"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"resource"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"directory"), (String)"src/test/resources"), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)"log4j-dev.properties")}), MojoExecutor.element((String)MojoExecutor.name((String)"filtering"), (String)"true")})})}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
    }

    protected void copyShareConfigCustom() throws MojoExecutionException {
        String warOutputDir = this.getWarOutputDir(SHARE_WAR_PREFIX_NAME);
        String distDir = warOutputDir + "/WEB-INF/classes/alfresco/web-extension/";
        String repoUrl = this.project.getProperties().getProperty("alfresco.repo.url");
        if (repoUrl == null) {
            this.project.getProperties().setProperty("alfresco.repo.url", "http://localhost:" + this.getPort() + "/alfresco");
        }
        this.getLog().info((CharSequence)("Copying Share config custom to: " + distDir));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-resources-plugin"), (String)MojoExecutor.version((String)MAVEN_RESOURCE_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"copy-resources"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)distDir), MojoExecutor.element((String)MojoExecutor.name((String)"resources"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"resource"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"directory"), (String)"src/test/resources/share"), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)"*.xml")}), MojoExecutor.element((String)MojoExecutor.name((String)"filtering"), (String)"true")})})}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
    }

    protected void copyShareLog4jConfig() throws MojoExecutionException {
        if (!this.useCustomShareLog4jConfig) {
            this.getLog().info((CharSequence)"NOT overriding share/WEB-INF/classes/log4j.properties");
            return;
        }
        String warOutputDir = this.getWarOutputDir(SHARE_WAR_PREFIX_NAME);
        String logConfDestDir = warOutputDir + "/WEB-INF/classes";
        this.getLog().info((CharSequence)("Copying Share log4j.properties to: " + logConfDestDir));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-resources-plugin"), (String)MojoExecutor.version((String)MAVEN_RESOURCE_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"copy-resources"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)logConfDestDir), MojoExecutor.element((String)MojoExecutor.name((String)"resources"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"resource"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"directory"), (String)"src/test/resources/share"), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)"log4j.properties")}), MojoExecutor.element((String)MojoExecutor.name((String)"filtering"), (String)"true")})})}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
    }

    protected void copyHotswapAgentProperties(String warPrefix) throws MojoExecutionException {
        if (!this.copyHotswapAgentConfig) {
            return;
        }
        String warOutputDir = this.getWarOutputDir(warPrefix) + "/WEB-INF/classes/";
        this.getLog().info((CharSequence)("Copying " + warPrefix + "-hotswap-agent.properties to " + warOutputDir));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"com.coderplus.maven.plugins"), (String)MojoExecutor.artifactId((String)"copy-rename-maven-plugin"), (String)MojoExecutor.version((String)"1.0")), (String)MojoExecutor.goal((String)"rename"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"sourceFile"), (String)(this.project.getBuild().getTestOutputDirectory() + "/" + warPrefix + "-hotswap-agent.properties")), MojoExecutor.element((String)MojoExecutor.name((String)"destinationFile"), (String)(warOutputDir + "hotswap-agent.properties"))}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
    }

    protected void buildPlatformWar() throws MojoExecutionException {
        this.buildCustomWarInDir(PLATFORM_WAR_PREFIX_NAME, this.platformModules, this.alfrescoGroupId, this.getPlatformWarArtifactId(), this.alfrescoPlatformVersion);
        this.commentOutSecureCommsInPlatformWebXml();
        this.copyAlfrescoLicense();
        this.copyHotswapAgentProperties(PLATFORM_WAR_PREFIX_NAME);
        String platformWarArtifactId = this.packageAndInstallCustomWar(PLATFORM_WAR_PREFIX_NAME);
        this.runnerAlfrescoGroupId = "${project.groupId}";
        this.runnerAlfrescoPlatformWarArtifactId = platformWarArtifactId;
        this.runnerAlfrescoPlatformVersion = "${project.version}";
    }

    protected void buildShareWar() throws MojoExecutionException {
        this.buildCustomWarInDir(SHARE_WAR_PREFIX_NAME, this.shareModules, this.alfrescoGroupId, this.alfrescoShareWarArtifactId, this.alfrescoShareVersion);
        this.copyShareLog4jConfig();
        this.copyShareConfigCustom();
        this.copyHotswapAgentProperties(SHARE_WAR_PREFIX_NAME);
        String shareWarArtifactId = this.packageAndInstallCustomWar(SHARE_WAR_PREFIX_NAME);
        this.runnerAlfrescoGroupId = "${project.groupId}";
        this.runnerAlfrescoShareWarArtifactId = shareWarArtifactId;
        this.runnerAlfrescoShareVersion = "${project.version}";
    }

    protected void buildActivitiAppWar() throws MojoExecutionException {
        this.buildCustomWarInDir(ACTIVITI_APP_WAR_PREFIX_NAME, this.activitiModules, this.activitiGroupId, this.activitiAppWarArtifactId, this.activitiVersion);
        this.copyActivitiLog4JDevConfig();
        String activitiAppWarArtifactId = this.packageAndInstallCustomWar(ACTIVITI_APP_WAR_PREFIX_NAME);
        this.runnerActivitiAppGroupId = "${project.groupId}";
        this.runnerActivitiAppWarArtifactId = activitiAppWarArtifactId;
        this.runnerActivitiAppVersion = "${project.version}";
    }

    protected void buildCustomWarInDir(String warName, List<ModuleDependency> modules, String originalWarGroupId, String originalWarArtifactId, String originalWarVersion) throws MojoExecutionException {
        String warOutputDir = this.getWarOutputDir(warName);
        String ampsModuleDir = "modules/" + warName + "/amps";
        String ampsOutputDir = "${project.build.directory}/" + ampsModuleDir;
        ArrayList<MojoExecutor.Element> ampModules = new ArrayList<MojoExecutor.Element>();
        ArrayList<MojoExecutor.Element> jarModules = new ArrayList<MojoExecutor.Element>();
        if (modules != null && modules.size() > 0) {
            for (ModuleDependency moduleDep : modules) {
                MojoExecutor.Element el = MojoExecutor.element((String)MojoExecutor.name((String)"artifactItem"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"groupId"), (String)moduleDep.getGroupId()), MojoExecutor.element((String)MojoExecutor.name((String)"artifactId"), (String)moduleDep.getArtifactId()), MojoExecutor.element((String)MojoExecutor.name((String)"version"), (String)moduleDep.getVersion()), MojoExecutor.element((String)MojoExecutor.name((String)"classifier"), (String)moduleDep.getClassifier()), MojoExecutor.element((String)MojoExecutor.name((String)"type"), (String)moduleDep.getType()), MojoExecutor.element((String)MojoExecutor.name((String)"overWrite"), (String)"true")});
                if (moduleDep.getArtifactId().equalsIgnoreCase("alfresco-share-services") && !this.isPlatformVersionGtOrEqTo51()) {
                    this.getLog().info((CharSequence)"Skipping alfresco-share-services, only needed for 5.1+");
                    continue;
                }
                if (moduleDep.isAmp()) {
                    ampModules.add(el);
                    continue;
                }
                if (moduleDep.isJar()) {
                    jarModules.add(el);
                    continue;
                }
                throw new MojoExecutionException("Unknown module type: " + moduleDep.getType() + " when building custom " + warName + " war, only 'jar' and 'amp' types are allowed");
            }
        }
        MojoExecutor.Element[] ampModuleArray = new MojoExecutor.Element[ampModules.size()];
        ampModules.toArray(ampModuleArray);
        MojoExecutor.Element[] jarModuleArray = new MojoExecutor.Element[jarModules.size()];
        jarModules.toArray(jarModuleArray);
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)MAVEN_DEPENDENCY_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"unpack"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)warOutputDir), MojoExecutor.element((String)MojoExecutor.name((String)"artifactItems"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"artifactItem"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"groupId"), (String)originalWarGroupId), MojoExecutor.element((String)MojoExecutor.name((String)"artifactId"), (String)originalWarArtifactId), MojoExecutor.element((String)MojoExecutor.name((String)"version"), (String)originalWarVersion), MojoExecutor.element((String)MojoExecutor.name((String)"type"), (String)"war")})})}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
        if (ampModuleArray.length > 0) {
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)MAVEN_DEPENDENCY_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"copy"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)ampsOutputDir), MojoExecutor.element((String)MojoExecutor.name((String)"artifactItems"), (MojoExecutor.Element[])ampModuleArray)}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
            String ampsLocation = this.project.getBuild().getDirectory() + "/" + ampsModuleDir;
            String warLocation = this.project.getBuild().getDirectory() + "/" + this.getWarName(warName);
            InstallMojo installMojo = new InstallMojo();
            installMojo.setAmpLocation(new File(ampsLocation));
            installMojo.setWarLocation(new File(warLocation));
            installMojo.setForce(true);
            try {
                installMojo.execute();
            }
            catch (MojoFailureException e) {
                e.printStackTrace();
            }
        }
        if (jarModuleArray.length > 0) {
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)MAVEN_DEPENDENCY_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"copy"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)(warOutputDir + "/WEB-INF/lib")), MojoExecutor.element((String)MojoExecutor.name((String)"artifactItems"), (MojoExecutor.Element[])jarModuleArray)}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
        }
    }

    protected String packageAndInstallCustomWar(String warName) throws MojoExecutionException {
        String warArtifactId = "${project.artifactId}-" + warName;
        String warSourceDir = this.getWarOutputDir(warName);
        String warPath = this.project.getBuild().getDirectory() + "/" + warName + ".war";
        ZipUtil.pack((File)new File(warSourceDir), (File)new File(warPath));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-install-plugin"), (String)MojoExecutor.version((String)MAVEN_INSTALL_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"install-file"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"file"), (String)warPath), MojoExecutor.element((String)MojoExecutor.name((String)"groupId"), (String)"${project.groupId}"), MojoExecutor.element((String)MojoExecutor.name((String)"artifactId"), (String)warArtifactId), MojoExecutor.element((String)MojoExecutor.name((String)"version"), (String)"${project.version}"), MojoExecutor.element((String)MojoExecutor.name((String)"packaging"), (String)"war")}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
        return warArtifactId;
    }

    protected void checkDatabaseConfig() throws MojoExecutionException {
        if (this.enablePlatform || this.enableActivitiApp) {
            if (this.enableH2 && !this.enableMySQL && !this.enablePostgreSQL) {
                return;
            }
            if (!this.enableH2 && this.enableMySQL && !this.enablePostgreSQL) {
                return;
            }
            if (!this.enableH2 && !this.enableMySQL && this.enablePostgreSQL) {
                return;
            }
            if (!(this.enableH2 || this.enableMySQL || this.enablePostgreSQL)) {
                return;
            }
            throw new MojoExecutionException("Invalid database configuration, should be enableH2 or enableMySQL or enablePostgreSQL or none (i.e. config via Tomcat Dependencies)");
        }
    }

    protected void startTomcat(boolean fork) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Starting Tomcat, fork = " + fork));
        ArrayList<Dependency> tomcatPluginDependencies = new ArrayList<Dependency>();
        ArrayList<MojoExecutor.Element> webapps2Deploy = new ArrayList<MojoExecutor.Element>();
        tomcatPluginDependencies.add(MojoExecutor.dependency((String)"org.codehaus.plexus", (String)"plexus-archiver", (String)"2.3"));
        tomcatPluginDependencies.add(MojoExecutor.dependency((String)"javax.servlet", (String)"javax.servlet-api", (String)"3.0.1"));
        if (this.tomcatDependencies != null && this.tomcatDependencies.size() > 0) {
            for (TomcatDependency tomcatDep : this.tomcatDependencies) {
                tomcatPluginDependencies.add(MojoExecutor.dependency((String)tomcatDep.getGroupId(), (String)tomcatDep.getArtifactId(), (String)tomcatDep.getVersion()));
            }
        }
        if (this.enableH2) {
            tomcatPluginDependencies.add(MojoExecutor.dependency((String)"com.h2database", (String)"h2", (String)"1.4.190"));
            if (this.enablePlatform) {
                this.copyH2Dialect();
            }
        } else if (this.enableMySQL) {
            tomcatPluginDependencies.add(MojoExecutor.dependency((String)"mysql", (String)"mysql-connector-java", (String)"5.1.32"));
        } else if (this.enablePostgreSQL) {
            tomcatPluginDependencies.add(MojoExecutor.dependency((String)"org.postgresql", (String)"postgresql", (String)"9.4-1201-jdbc41"));
        }
        if (this.enablePlatform) {
            webapps2Deploy.add(this.createWebAppElement(this.runnerAlfrescoGroupId, this.runnerAlfrescoPlatformWarArtifactId, this.runnerAlfrescoPlatformVersion, "/alfresco", null));
        }
        if (this.enableShare) {
            webapps2Deploy.add(this.createWebAppElement(this.runnerAlfrescoGroupId, this.runnerAlfrescoShareWarArtifactId, this.runnerAlfrescoShareVersion, this.shareContextPath, null));
        }
        if (this.enableSolr) {
            webapps2Deploy.add(this.getSolrWebappElement());
        }
        if (this.enableApiExplorer) {
            webapps2Deploy.add(this.createWebAppElement(this.alfrescoGroupId, this.alfrescoApiExplorerArtifactId, this.alfrescoApiExplorerVersion, "/api-explorer", null));
        }
        if (this.enableActivitiApp) {
            webapps2Deploy.add(this.createWebAppElement(this.runnerActivitiAppGroupId, this.runnerActivitiAppWarArtifactId, this.runnerActivitiAppVersion, "/activiti-app", null));
        }
        if (this.enableActivitiAdmin) {
            webapps2Deploy.add(this.createWebAppElement(this.activitiGroupId, this.activitiAdminWarArtifactId, this.activitiVersion, "/activiti-admin", null));
        }
        if (this.tomcatCustomWebapps != null && !this.tomcatCustomWebapps.isEmpty()) {
            for (TomcatWebapp customWebapp : this.tomcatCustomWebapps) {
                webapps2Deploy.add(this.createWebAppElement(customWebapp.getGroupId(), customWebapp.getArtifactId(), customWebapp.getVersion(), customWebapp.getContextPath(), customWebapp.getContextFile()));
            }
        }
        MojoExecutor.Element[] webapps = new MojoExecutor.Element[webapps2Deploy.size()];
        webapps2Deploy.toArray(webapps);
        ArrayList<MojoExecutor.Element> systemProps = new ArrayList<MojoExecutor.Element>();
        if (this.enableSolr) {
            systemProps.add(MojoExecutor.element((String)MojoExecutor.name((String)"solr.solr.home"), (String)(this.solrHome + "/")));
        }
        if (this.enableActivitiApp) {
            systemProps.add(MojoExecutor.element((String)MojoExecutor.name((String)"log4j.configuration"), (String)"log4j-dev.properties"));
        }
        if (this.tomcatSystemProperties != null && !this.tomcatSystemProperties.isEmpty()) {
            for (Map.Entry<String, String> sysProp : this.tomcatSystemProperties.entrySet()) {
                systemProps.add(MojoExecutor.element((String)MojoExecutor.name((String)sysProp.getKey()), (String)sysProp.getValue()));
            }
        }
        MojoExecutor.Element[] systemPropArray = new MojoExecutor.Element[systemProps.size()];
        systemProps.toArray(systemPropArray);
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.tomcat.maven"), (String)MojoExecutor.artifactId((String)"tomcat7-maven-plugin"), (String)MojoExecutor.version((String)MAVEN_TOMCAT7_PLUGIN_VERSION), tomcatPluginDependencies), (String)MojoExecutor.goal((String)"run"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"fork"), (String)(fork ? "true" : "false")), MojoExecutor.element((String)MojoExecutor.name((String)"path"), (String)"/"), MojoExecutor.element((String)MojoExecutor.name((String)"port"), (String)this.getPort()), MojoExecutor.element((String)MojoExecutor.name((String)"ignorePackaging"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"useSeparateTomcatClassLoader"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"useTestClasspath"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"systemProperties"), (MojoExecutor.Element[])systemPropArray), MojoExecutor.element((String)MojoExecutor.name((String)"delegate"), (String)"false"), MojoExecutor.element((String)MojoExecutor.name((String)"uriEncoding"), (String)"UTF-8"), MojoExecutor.element((String)MojoExecutor.name((String)"webapps"), (MojoExecutor.Element[])webapps)}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
    }

    private MojoExecutor.Element createWebAppElement(String groupId, String artifactId, String version, String contextPath, String contextFile) {
        String errorStr = "cannot be null when creating webapp element for Tomcat 7 plugin";
        if (StringUtils.isBlank((String)groupId)) {
            this.getLog().error((CharSequence)("Maven Group Id " + errorStr));
        }
        if (StringUtils.isBlank((String)artifactId)) {
            this.getLog().error((CharSequence)("Maven Artifact Id " + errorStr));
        }
        if (StringUtils.isBlank((String)version)) {
            this.getLog().error((CharSequence)("Maven Version number " + errorStr));
        }
        MojoExecutor.Element groupIdEl = MojoExecutor.element((String)MojoExecutor.name((String)"groupId"), (String)groupId);
        MojoExecutor.Element artifactIdEl = MojoExecutor.element((String)MojoExecutor.name((String)"artifactId"), (String)artifactId);
        MojoExecutor.Element versionEl = MojoExecutor.element((String)MojoExecutor.name((String)"version"), (String)version);
        MojoExecutor.Element typeEl = MojoExecutor.element((String)MojoExecutor.name((String)"type"), (String)"war");
        MojoExecutor.Element asWebappEl = MojoExecutor.element((String)MojoExecutor.name((String)"asWebapp"), (String)"true");
        MojoExecutor.Element contextPathEl = MojoExecutor.element((String)MojoExecutor.name((String)"contextPath"), (String)contextPath);
        MojoExecutor.Element e = StringUtils.isNotBlank((String)contextFile) ? MojoExecutor.element((String)MojoExecutor.name((String)"webapp"), (MojoExecutor.Element[])new MojoExecutor.Element[]{groupIdEl, artifactIdEl, versionEl, typeEl, asWebappEl, contextPathEl, MojoExecutor.element((String)MojoExecutor.name((String)"contextFile"), (String)contextFile)}) : MojoExecutor.element((String)MojoExecutor.name((String)"webapp"), (MojoExecutor.Element[])new MojoExecutor.Element[]{groupIdEl, artifactIdEl, versionEl, typeEl, asWebappEl, contextPathEl});
        this.getLog().info((CharSequence)e.toDom().toUnescapedString());
        return e;
    }

    private boolean isPlatformVersionGtOrEqTo51() {
        return this.getPlatformVersionNumber() >= 51;
    }

    private boolean isPlatformVersionLtOrEqTo42() {
        return this.getPlatformVersionNumber() <= 42;
    }

    private int getPlatformVersionNumber() {
        return Integer.parseInt(this.alfrescoPlatformVersion.replaceAll("[^0-9]", "").substring(0, 2));
    }

    private String getSolrArtifactId() {
        if (this.isPlatformVersionLtOrEqTo42()) {
            this.alfrescoSolrArtifactId = "alfresco-solr";
        }
        return this.alfrescoSolrArtifactId;
    }

    private String getPlatformWarArtifactId() {
        if (!this.isPlatformVersionGtOrEqTo51() && this.alfrescoEdition.equals(ALFRESCO_COMMUNITY_EDITION)) {
            this.alfrescoPlatformWarArtifactId = "alfresco";
        }
        if (this.isPlatformVersionLtOrEqTo42() && this.alfrescoEdition.equals(ALFRESCO_ENTERPRISE_EDITION)) {
            this.alfrescoPlatformWarArtifactId = "alfresco";
        }
        if (this.getPlatformVersionNumber() == 50 && this.alfrescoEdition.equals(ALFRESCO_ENTERPRISE_EDITION)) {
            this.alfrescoPlatformWarArtifactId = "alfresco-enterprise";
        }
        if (this.isPlatformVersionGtOrEqTo51() && this.alfrescoEdition.equals(ALFRESCO_COMMUNITY_EDITION)) {
            this.alfrescoPlatformWarArtifactId = "alfresco-platform";
        }
        if (this.isPlatformVersionGtOrEqTo51() && this.alfrescoEdition.equals(ALFRESCO_ENTERPRISE_EDITION)) {
            this.alfrescoPlatformWarArtifactId = "alfresco-platform-enterprise";
        }
        return this.alfrescoPlatformWarArtifactId;
    }

    private MojoExecutor.Element getSolrWebappElement() {
        MojoExecutor.Element webappElement = null;
        webappElement = this.isPlatformVersionLtOrEqTo42() ? this.createWebAppElement("${project.groupId}", this.getSolrArtifactId(), "${project.version}", "/solr", "${project.build.testOutputDirectory}/tomcat/context-solr.xml") : this.createWebAppElement(this.alfrescoGroupId, this.getSolrArtifactId(), this.alfrescoPlatformVersion, "/solr4", "${project.build.testOutputDirectory}/tomcat/context-solr.xml");
        return webappElement;
    }

    private void copyH2Dialect() throws MojoExecutionException {
        String h2SourceDir;
        if (!this.isPlatformVersionLtOrEqTo42()) {
            this.getLog().info((CharSequence)"Unpacking DB Dialects and ibatis files from alfresco-repository artifact");
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)MAVEN_DEPENDENCY_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"unpack"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)"${project.build.testOutputDirectory}"), MojoExecutor.element((String)MojoExecutor.name((String)"artifactItems"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"artifactItem"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"groupId"), (String)this.alfrescoGroupId), MojoExecutor.element((String)MojoExecutor.name((String)"artifactId"), (String)"alfresco-repository"), MojoExecutor.element((String)MojoExecutor.name((String)"version"), (String)this.alfrescoPlatformVersion), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (String)"alfresco/dbscripts/create/org.hibernate.dialect.PostgreSQLDialect/*,alfresco/dbscripts/upgrade/*/org.hibernate.dialect.PostgreSQLDialect/*,alfresco/ibatis/org.hibernate.dialect.PostgreSQLDialect/*")})})}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
            if (this.alfrescoEdition.equals(ALFRESCO_ENTERPRISE_EDITION)) {
                MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)MAVEN_DEPENDENCY_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"unpack"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)"${project.build.testOutputDirectory}"), MojoExecutor.element((String)MojoExecutor.name((String)"artifactItems"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"artifactItem"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"groupId"), (String)this.alfrescoGroupId), MojoExecutor.element((String)MojoExecutor.name((String)"artifactId"), (String)"alfresco-enterprise-repository"), MojoExecutor.element((String)MojoExecutor.name((String)"version"), (String)this.alfrescoPlatformVersion), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (String)"alfresco/dbscripts/create/org.hibernate.dialect.PostgreSQLDialect/*,alfresco/dbscripts/upgrade/*/org.hibernate.dialect.PostgreSQLDialect/*,alfresco/ibatis/org.hibernate.dialect.PostgreSQLDialect/*")})})}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
            }
            h2SourceDir = this.project.getBuild().getTestOutputDirectory();
        } else {
            h2SourceDir = this.getWarOutputDir(PLATFORM_WAR_PREFIX_NAME) + "/WEB-INF/classes";
        }
        this.getLog().info((CharSequence)"Copying H2 Dialect SQL create files into target/test-classes");
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-resources-plugin"), (String)MojoExecutor.version((String)MAVEN_RESOURCE_PLUGIN_VERSION)), (String)MojoExecutor.goal((String)"copy-resources"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)"${project.build.testOutputDirectory}"), MojoExecutor.element((String)MojoExecutor.name((String)"resources"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"resource"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"directory"), (String)(h2SourceDir + "/alfresco/dbscripts/create/org.hibernate.dialect.PostgreSQLDialect")), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)"*")}), MojoExecutor.element((String)MojoExecutor.name((String)"targetPath"), (String)"alfresco/dbscripts/create/org.hibernate.dialect.H2Dialect")}), MojoExecutor.element((String)MojoExecutor.name((String)"resource"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"directory"), (String)(h2SourceDir + "/alfresco/ibatis/org.hibernate.dialect.PostgreSQLDialect")), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)"*")}), MojoExecutor.element((String)MojoExecutor.name((String)"targetPath"), (String)"alfresco/ibatis/org.hibernate.dialect.H2Dialect")})})}), (MojoExecutor.ExecutionEnvironment)this.execEnv);
    }

    private String getWarOutputDir(String baseWarName) {
        return this.project.getBuild().getDirectory() + "/" + this.getWarName(baseWarName);
    }

    private String getWarName(String baseWarName) {
        return baseWarName + "-war";
    }
}

