/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.maven.plugin;

import java.io.Closeable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractRefreshWebappMojo
extends AbstractMojo {
    @Component
    protected MavenProject project;
    @Parameter(property="maven.alfresco.refresh.mode", defaultValue="auto")
    protected String refreshMode;
    @Parameter(property="maven.alfresco.refresh.host", defaultValue="localhost")
    protected String refreshHost;
    @Parameter(property="maven.alfresco.refresh.port", defaultValue="${maven.tomcat.port}")
    private String refreshPort;
    @Parameter(property="maven.alfresco.refresh.username", defaultValue="admin")
    private String refreshUsername;
    @Parameter(property="maven.alfresco.refresh.password", defaultValue="admin")
    protected String refreshPassword;
    @Parameter(property="maven.alfresco.refresh.repoUrl", defaultValue="/alfresco/service/index")
    protected String refreshRepoUrl;
    @Parameter(property="maven.alfresco.refresh.shareUrl", defaultValue="/share/page/index")
    protected String refreshShareUrl;
    @Parameter(property="maven.alfresco.refresh.clearCacheShareUrl", defaultValue="/share/page/caches/dependency/clear")
    protected String clearCacheShareUrl;
    protected String refreshWebappName;
    @Parameter(defaultValue="${app.amp.client.war.artifactId}")
    protected String alfrescoClientWar;

    public void execute() throws MojoExecutionException {
        if (StringUtils.isBlank((String)this.refreshPort)) {
            this.refreshPort = "8080";
        }
        if (!this.ping()) {
            this.getLog().warn((CharSequence)("Connection failed to " + this.refreshHost + ":" + this.refreshPort + ", " + this.getAbortedMsg()));
            return;
        }
        this.executeRefresh();
    }

    protected abstract void executeRefresh();

    protected void _refreshRepo() {
        this.refreshWebappName = "Alfresco Repository";
        this.refreshWebScripts(this.refreshRepoUrl);
    }

    protected void _refreshShare() {
        this.refreshWebappName = "Alfresco Share";
        this.refreshWebScripts(this.refreshShareUrl);
        this.clearDependencyCaches(this.clearCacheShareUrl);
    }

    protected void refreshWebScripts(String url) {
        URL alfrescoTomcatUrl = this.buildFinalUrl(url);
        if (alfrescoTomcatUrl == null) {
            this.getLog().error((CharSequence)("Could not build refresh URL for " + this.refreshWebappName + ", " + this.getAbortedMsg()));
        }
        ArrayList<NameValuePair> postData = new ArrayList<NameValuePair>();
        postData.add((NameValuePair)new BasicNameValuePair("reset", "on"));
        postData.add((NameValuePair)new BasicNameValuePair("submit", "Refresh Web Scripts"));
        this.makePostCall(alfrescoTomcatUrl, postData, "Refresh Web Scripts");
    }

    protected void clearDependencyCaches(String url) {
        URL alfrescoTomcatUrl = this.buildFinalUrl(url);
        if (alfrescoTomcatUrl == null) {
            this.getLog().error((CharSequence)("Could not build clear dependency caches URL for " + this.refreshWebappName + ", " + this.getAbortedMsg()));
        }
        this.makePostCall(alfrescoTomcatUrl, null, "Clear Dependency Caches");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makePostCall(URL alfrescoTomcatUrl, List<NameValuePair> postData, String operation) {
        CloseableHttpResponse response;
        CloseableHttpClient client;
        block8: {
            client = null;
            response = null;
            HttpHost targetHost = new HttpHost(alfrescoTomcatUrl.getHost(), alfrescoTomcatUrl.getPort(), alfrescoTomcatUrl.getProtocol());
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(this.refreshUsername, this.refreshPassword));
            client = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(targetHost, (AuthScheme)basicAuth);
            HttpClientContext localContext = HttpClientContext.create();
            localContext.setAuthCache((AuthCache)authCache);
            HttpPost httpPost = new HttpPost(alfrescoTomcatUrl.toURI());
            response = client.execute((HttpUriRequest)httpPost);
            if (postData != null) {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(postData, "UTF-8");
                httpPost.setEntity((HttpEntity)entity);
            }
            httpPost.setHeader("Accept-Charset", "iso-8859-1,utf-8");
            httpPost.setHeader("Accept-Language", "en-us");
            response = client.execute((HttpUriRequest)httpPost);
            if (response != null) break block8;
            this.getLog().error((CharSequence)("POST request failed to " + alfrescoTomcatUrl.toString() + ", " + this.getAbortedMsg()));
            this.closeQuietly((Closeable)response);
            this.closeQuietly((Closeable)client);
            return;
        }
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                this.getLog().info((CharSequence)("Successfull " + operation + " for " + this.refreshWebappName));
            } else {
                String reasonPhrase = response.getStatusLine().getReasonPhrase();
                this.getLog().warn((CharSequence)("Failed to " + operation + " for " + this.refreshWebappName + ". Response status: " + statusCode + ", message: " + reasonPhrase));
            }
            this.closeQuietly((Closeable)response);
            this.closeQuietly((Closeable)client);
        }
        catch (Exception ex) {
            try {
                this.getLog().error((CharSequence)("POST request failed to " + alfrescoTomcatUrl.toString() + ", " + this.getAbortedMsg()));
                this.getLog().error((CharSequence)("Exception Msg: " + ex.getMessage()));
                this.closeQuietly((Closeable)response);
                this.closeQuietly((Closeable)client);
            }
            catch (Throwable throwable) {
                this.closeQuietly((Closeable)response);
                this.closeQuietly((Closeable)client);
                throw throwable;
            }
        }
    }

    private URL buildFinalUrl(String specificRefreshUrlPath) {
        try {
            return new URL("http://" + this.refreshHost + ":" + this.refreshPort + specificRefreshUrlPath);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean ping() {
        try {
            URL alfrescoTomcatUrl = this.buildFinalUrl("");
            TelnetClient telnetClient = new TelnetClient();
            telnetClient.setDefaultTimeout(500);
            telnetClient.connect(alfrescoTomcatUrl.getHost(), alfrescoTomcatUrl.getPort());
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getAbortedMsg() {
        return this.refreshWebappName + " webapp refresh aborted";
    }
}

