/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.alfresco.maven.plugin.AmpModel;
import org.alfresco.maven.plugin.archiver.AmpArchiver;
import org.apache.commons.io.FileUtils;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.jar.JarArchiver;

public class AmpMojo
extends AbstractMojo {
    protected String ampFinalName;
    protected File ampBuildDirectory;
    protected String classifier;
    protected boolean includeDependencies;
    protected boolean includeWebResources;
    protected boolean attachClasses;
    protected boolean attachConfig;
    protected File ampFinalDir;
    protected File classesDirectory;
    protected MavenProject project;
    protected MavenSession session;
    protected MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    protected MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException {
        if (this.includeDependencies) {
            this.gatherDependencies();
        }
        File jarFile = this.createJarArchive();
        if (this.attachClasses) {
            this.projectHelper.attachArtifact(this.project, "jar", "classes", jarFile);
        }
        File ampFile = this.createArchive();
        if (this.classifier != null) {
            this.projectHelper.attachArtifact(this.project, "amp", this.classifier, ampFile);
        } else {
            this.project.getArtifact().setFile(ampFile);
        }
        if (this.attachConfig) {
            File configFile = this.createConfigArchive();
            this.projectHelper.attachArtifact(this.project, "jar", "config", configFile);
        }
    }

    protected File createJarArchive() throws MojoExecutionException {
        File jarFile = AmpMojo.getFile(new File(this.ampBuildDirectory, "lib"), this.ampFinalName, this.classifier, "jar");
        MavenArchiver jarArchiver = new MavenArchiver();
        jarArchiver.setArchiver(new JarArchiver());
        jarArchiver.setOutputFile(jarFile);
        try {
            jarArchiver.getArchiver().addDirectory(this.classesDirectory, new String[0], new String[0]);
            jarArchiver.createArchive(this.session, this.project, this.archive);
            return jarFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error creating JAR", e);
        }
    }

    private String[] getResourcesExcludes() {
        if (!this.includeWebResources) {
            return new String[]{"web/**"};
        }
        return new String[0];
    }

    protected File createArchive() throws MojoExecutionException {
        File ampFile = AmpMojo.getFile(this.ampFinalDir, this.ampFinalName, this.classifier, "amp");
        MavenArchiver ampArchiver = new MavenArchiver();
        ampArchiver.setArchiver((JarArchiver)new AmpArchiver());
        ampArchiver.setOutputFile(ampFile);
        if (!this.ampBuildDirectory.exists()) {
            this.getLog().warn((CharSequence)"ampBuildDirectory does not exist - AMP will be empty");
        } else {
            try {
                ampArchiver.getArchiver().addDirectory(this.ampBuildDirectory, new String[]{"**"}, this.getResourcesExcludes());
                ampArchiver.createArchive(this.session, this.project, this.archive);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error creating AMP", e);
            }
        }
        return ampFile;
    }

    protected File createConfigArchive() throws MojoExecutionException {
        File configFile = AmpMojo.getFile(new File(this.project.getBuild().getDirectory()), this.ampFinalName, this.classifier, "jar");
        MavenArchiver configArchiver = new MavenArchiver();
        configArchiver.setArchiver(new JarArchiver());
        configArchiver.setOutputFile(configFile);
        try {
            configArchiver.getArchiver().addDirectory(new File(this.ampBuildDirectory, "config"), new String[0], new String[]{"**/*.class"});
            configArchiver.createArchive(this.session, this.project, this.archive);
            return configFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error creating config artifact", e);
        }
    }

    protected static File getFile(File basedir, String finalName, String classifier, String extension) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + "." + extension);
    }

    protected void gatherDependencies() throws MojoExecutionException {
        Set dependencies = null;
        dependencies = this.project.getArtifacts();
        ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
        for (Artifact artifact : dependencies) {
            String type;
            if (artifact.isOptional() || !filter.include(artifact) || !AmpModel.EXTENSION_LIST.contains(type = artifact.getType())) continue;
            File targetFile = new File(this.ampBuildDirectory + File.separator + "lib" + File.separator + artifact.getFile().getName());
            String targetFilePath = targetFile.getPath();
            try {
                FileUtils.copyFile((File)artifact.getFile(), (File)targetFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying transitive dependency " + artifact.getId() + " to file: " + targetFilePath);
            }
        }
    }
}

