/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.maven.plugin.archiver;

import java.io.File;
import org.alfresco.repo.module.tool.ModuleManagementTool;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.AbstractZipUnArchiver;
import org.codehaus.plexus.component.annotations.Requirement;

public class AmpUnArchiver
extends AbstractZipUnArchiver {
    @Requirement
    private LegacySupport legacySupport;

    public File getDestDirectory() {
        MavenSession session = this.legacySupport.getSession();
        MavenProject project = session.getCurrentProject();
        return new File(project.getBuild().getDirectory() + File.separator + project.getBuild().getFinalName());
    }

    protected void execute() throws ArchiverException {
        try {
            ModuleManagementTool mmt = new ModuleManagementTool();
            mmt.setVerbose(false);
            this.getLogger().info("getDestFile ():" + this.getDestFile());
            this.getLogger().info("getDestFile ():" + this.getDestFile());
            this.getLogger().info("getDestDirectory ():" + this.getDestDirectory());
            File destLocation = this.getDestFile() == null || !this.getDestFile().exists() ? this.getDestDirectory() : this.getDestFile();
            this.getLogger().info("Installing " + this.getSourceFile() + " into " + destLocation);
            try {
                mmt.installModule(this.getSourceFile().getAbsolutePath(), destLocation.getAbsolutePath(), false, true, false);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Problems while installing " + this.getSourceFile().getAbsolutePath() + " onto " + destLocation.getAbsolutePath(), e);
            }
            this.getLogger().debug("MMT invocation for " + this.getSourceFile().getAbsolutePath() + "complete");
        }
        catch (Exception e) {
            throw new ArchiverException("Error while expanding " + this.getSourceFile().getAbsolutePath(), (Throwable)e);
        }
    }
}

