/*
 * Decompiled with CFR 0.152.
 */
package org.alfasoftware.morf.jdbc.nuodb;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.alfasoftware.morf.jdbc.DatabaseMetaDataProvider;
import org.alfasoftware.morf.jdbc.RuntimeSqlException;
import org.alfasoftware.morf.metadata.Column;
import org.alfasoftware.morf.metadata.DataType;
import org.alfasoftware.morf.metadata.Index;
import org.alfasoftware.morf.metadata.SchemaUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class NuoDBMetaDataProvider
extends DatabaseMetaDataProvider {
    private static final Log log = LogFactory.getLog(NuoDBMetaDataProvider.class);
    private Multimap<String, SchemaUtils.ColumnBuilder> columnMetaData;
    private ArrayListMultimap<String, Index> indexMetaData;
    private ArrayListMultimap<String, String> primaryKeyMetaData;

    private static DataType dataTypeFromDeclaredType(String typeName) {
        switch (typeName.toUpperCase()) {
            case "INTEGER": {
                return DataType.INTEGER;
            }
            case "BIGINT": {
                return DataType.BIG_INTEGER;
            }
            case "NUMERIC": 
            case "DECIMAL": {
                return DataType.DECIMAL;
            }
            case "CHARACTER VARYING": 
            case "CHAR": 
            case "VARCHAR": {
                return DataType.STRING;
            }
            case "SMALLINT": 
            case "BOOLEAN": {
                return DataType.BOOLEAN;
            }
            case "DATE": {
                return DataType.DATE;
            }
            case "BLOB": {
                return DataType.BLOB;
            }
            case "CLOB": {
                return DataType.CLOB;
            }
        }
        throw new IllegalArgumentException("Unknown SQL data type [" + typeName + "]");
    }

    public NuoDBMetaDataProvider(Connection connection, String schemaName) {
        super(connection, schemaName);
    }

    protected Map<DatabaseMetaDataProvider.AName, Integer> loadTablePrimaryKey(DatabaseMetaDataProvider.RealName tableName) {
        List<String> primaryKey = this.getPrimaryKeys(tableName.getDbName());
        PrimitiveIterator.OfInt numberer = IntStream.rangeClosed(1, primaryKey.size()).iterator();
        return Maps.toMap(primaryKey.stream().map(k -> NuoDBMetaDataProvider.named((String)k)).iterator(), k -> (Integer)numberer.next());
    }

    protected List<String> getPrimaryKeys(String tableName) {
        if (this.primaryKeyMetaData == null) {
            log.info((Object)("Initialising index metadata cache for schema [" + this.schemaName + "]"));
            this.retrieveIndexMetaData(this.connection, this.schemaName);
        }
        return this.primaryKeyMetaData.get((Object)tableName);
    }

    protected List<Index> loadTableIndexes(DatabaseMetaDataProvider.RealName tableName) {
        if (this.indexMetaData == null) {
            log.info((Object)("Initialising index metadata cache for schema [" + this.schemaName + "]"));
            this.retrieveIndexMetaData(this.connection, this.schemaName);
        }
        return this.indexMetaData.get((Object)tableName.getDbName());
    }

    protected List<Column> loadTableColumns(DatabaseMetaDataProvider.RealName tableName, Map<DatabaseMetaDataProvider.AName, Integer> primaryKey) {
        if (this.columnMetaData == null) {
            log.info((Object)("Initialising column metadata cache for schema [" + this.schemaName + "]"));
            this.columnMetaData = this.retrieveColumnMetaData(this.connection, this.schemaName);
        }
        Collection originalColumns = this.columnMetaData.get((Object)tableName.getDbName());
        return NuoDBMetaDataProvider.createColumnsFrom((Collection)originalColumns, primaryKey);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Multimap<String, SchemaUtils.ColumnBuilder> retrieveColumnMetaData(Connection connection, String schemaName) {
        String columnQuery = "SELECT F.TABLENAME, F.FIELD, F.DECLARED_TYPE, F.GENERATOR_SEQUENCE, F.SCALE, F.PRECISION, F.FLAGS FROM SYSTEM.FIELDS AS F, SYSTEM.TABLES AS T WHERE T.TABLENAME = F.TABLENAME AND T.TYPE = 'TABLE' AND T.SCHEMA = F.SCHEMA AND F.SCHEMA = ?";
        try (PreparedStatement createStatement = connection.prepareStatement(columnQuery);){
            ArrayListMultimap arrayListMultimap;
            block19: {
                createStatement.setString(1, schemaName);
                ResultSet columnQueryResult = createStatement.executeQuery();
                try {
                    ArrayListMultimap multimap = ArrayListMultimap.create();
                    while (columnQueryResult.next()) {
                        String tablename = columnQueryResult.getString("TABLENAME");
                        String fieldName = columnQueryResult.getString("FIELD");
                        String declaredDataType = columnQueryResult.getString("DECLARED_TYPE");
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Fetched metadata for [" + tablename + "." + fieldName + "] type [" + declaredDataType + "]"));
                        }
                        if (declaredDataType == null) {
                            throw new IllegalStateException("Null declared type for [" + tablename + "].[" + fieldName + "]");
                        }
                        DataType dataType = NuoDBMetaDataProvider.dataTypeFromDeclaredType(declaredDataType.replaceFirst("^([a-z ]+).*$", "$1"));
                        SchemaUtils.ColumnBuilder nuoDBFieldMetaData = SchemaUtils.column((String)fieldName, (DataType)dataType, (int)columnQueryResult.getInt("PRECISION"), (int)columnQueryResult.getInt("SCALE"));
                        nuoDBFieldMetaData = nuoDBFieldMetaData.defaultValue("version".equalsIgnoreCase(fieldName) ? "0" : "");
                        SchemaUtils.ColumnBuilder columnBuilder = nuoDBFieldMetaData = columnQueryResult.getInt("FLAGS") == 0 ? nuoDBFieldMetaData.nullable() : nuoDBFieldMetaData;
                        if (StringUtils.isNotBlank((CharSequence)columnQueryResult.getString("GENERATOR_SEQUENCE"))) {
                            nuoDBFieldMetaData = nuoDBFieldMetaData.autoNumbered(this.fetchAutoNumber(columnQueryResult.getString("GENERATOR_SEQUENCE")));
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Caching metadata for schema [" + schemaName + "], table [" + tablename + "], column [" + fieldName + "]"));
                        }
                        multimap.put((Object)tablename, (Object)nuoDBFieldMetaData);
                    }
                    arrayListMultimap = multimap;
                    if (columnQueryResult == null) break block19;
                }
                catch (Throwable throwable) {
                    if (columnQueryResult != null) {
                        try {
                            columnQueryResult.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                columnQueryResult.close();
            }
            return arrayListMultimap;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isPrimaryKeyIndex(DatabaseMetaDataProvider.RealName indexName) {
        return indexName.getDbName().endsWith("..PRIMARY_KEY");
    }

    protected boolean isIgnoredTable(DatabaseMetaDataProvider.RealName tableName) {
        return tableName.getDbName().startsWith("TEMP_");
    }

    private int fetchAutoNumber(String generatorSequence) {
        try {
            return Integer.parseInt(generatorSequence.substring(generatorSequence.lastIndexOf(95) + 1));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Cannot determine AutoNumber start from Generator_Sequence [" + generatorSequence + "]", e);
        }
    }

    private void retrieveIndexMetaData(Connection connection, String schemaName) {
        String indexQuery = "SELECT I.INDEXNAME, I.TABLENAME, I.INDEXTYPE, FI.FIELD, FI.POSITION, I.FIELDCOUNT FROM SYSTEM.INDEXES AS I, SYSTEM.INDEXFIELDS AS FI WHERE I.INDEXNAME = FI.INDEXNAME AND I.TABLENAME = FI.TABLENAME AND I.SCHEMA = FI.SCHEMA AND I.SCHEMA = ?";
        HashMap<String, Map<IndexTuple, String[]>> tableIndexMap = new HashMap<String, Map<IndexTuple, String[]>>();
        try (PreparedStatement createStatement = connection.prepareStatement(indexQuery);){
            createStatement.setString(1, schemaName);
            try (ResultSet columnQueryResult = createStatement.executeQuery();){
                while (columnQueryResult.next()) {
                    String indexName = columnQueryResult.getString("INDEXNAME");
                    String tableName = columnQueryResult.getString("TABLENAME");
                    String columnName = columnQueryResult.getString("FIELD");
                    int indexType = columnQueryResult.getInt("INDEXTYPE");
                    int fieldsOnIndex = columnQueryResult.getInt("FIELDCOUNT");
                    int positionInIndex = columnQueryResult.getInt("POSITION");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Fetched index metadata for [" + tableName + "], index name [" + indexName + "] and column [" + columnName + "] in position [" + positionInIndex + "]"));
                    }
                    Map indexesOnTable = tableIndexMap.computeIfAbsent(tableName, k -> new HashMap());
                    IndexTuple indexTuple = new IndexTuple(indexName, indexType);
                    String[] orderedcolumnsForIndex = indexesOnTable.computeIfAbsent(indexTuple, k -> new String[fieldsOnIndex]);
                    orderedcolumnsForIndex[positionInIndex] = columnName;
                    indexesOnTable.put(indexTuple, orderedcolumnsForIndex);
                    tableIndexMap.put(tableName, indexesOnTable);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Caching index metadata for schema [" + schemaName + "]"));
        }
        this.cacheIndexesAndPrimaryKeyColumns(tableIndexMap);
    }

    private void cacheIndexesAndPrimaryKeyColumns(Map<String, Map<IndexTuple, String[]>> tableIndexMap) {
        ArrayListMultimap indexes = ArrayListMultimap.create();
        ArrayListMultimap primaryKeys = ArrayListMultimap.create();
        tableIndexMap.entrySet().stream().forEach(e -> {
            primaryKeys.putAll((Object)((String)e.getKey()), this.primaryKeyBuilder((Map.Entry<String, Map<IndexTuple, String[]>>)e));
            indexes.putAll((Object)((String)e.getKey()), this.indexBuilder((Map.Entry<String, Map<IndexTuple, String[]>>)e));
        });
        this.indexMetaData = indexes;
        this.primaryKeyMetaData = primaryKeys;
    }

    private List<Index> indexBuilder(Map.Entry<String, Map<IndexTuple, String[]>> entry) {
        return entry.getValue().entrySet().stream().filter(p -> ((IndexTuple)p.getKey()).indexType != 0).map(p -> this.createIndex(((IndexTuple)p.getKey()).indexName, ((IndexTuple)p.getKey()).indexType == 1, (String[])p.getValue())).collect(Collectors.toList());
    }

    private Index createIndex(String indexName, boolean isUnique, String[] columnNames) {
        SchemaUtils.IndexBuilder index = SchemaUtils.index((String)indexName).columns(columnNames);
        return isUnique ? index.unique() : index;
    }

    private List<String> primaryKeyBuilder(Map.Entry<String, Map<IndexTuple, String[]>> entry) {
        return entry.getValue().entrySet().stream().filter(p -> ((IndexTuple)p.getKey()).indexType == 0).flatMap(p -> Arrays.stream((String[])p.getValue())).collect(Collectors.toList());
    }

    private static final class IndexTuple {
        String indexName;
        int indexType;

        IndexTuple(String indexName, int indexType) {
            this.indexName = indexName;
            this.indexType = indexType;
        }

        public int hashCode() {
            return Objects.hash(this.indexName, this.indexType);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexTuple other = (IndexTuple)obj;
            return Objects.equals(this.indexName, other.indexName) && Objects.equals(this.indexType, other.indexType);
        }
    }
}

