/*
 * Decompiled with CFR 0.152.
 */
package org.alfasoftware.morf.jdbc.nuodb;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.alfasoftware.morf.jdbc.DatabaseType;
import org.alfasoftware.morf.jdbc.NamedParameterPreparedStatement;
import org.alfasoftware.morf.jdbc.SqlDialect;
import org.alfasoftware.morf.metadata.Column;
import org.alfasoftware.morf.metadata.DataType;
import org.alfasoftware.morf.metadata.Index;
import org.alfasoftware.morf.metadata.SchemaUtils;
import org.alfasoftware.morf.metadata.Table;
import org.alfasoftware.morf.sql.ExceptSetOperator;
import org.alfasoftware.morf.sql.Hint;
import org.alfasoftware.morf.sql.MergeStatement;
import org.alfasoftware.morf.sql.SelectStatement;
import org.alfasoftware.morf.sql.SqlUtils;
import org.alfasoftware.morf.sql.UseImplicitJoinOrder;
import org.alfasoftware.morf.sql.UseIndex;
import org.alfasoftware.morf.sql.element.AliasedField;
import org.alfasoftware.morf.sql.element.FieldLiteral;
import org.alfasoftware.morf.sql.element.FieldReference;
import org.alfasoftware.morf.sql.element.Function;
import org.alfasoftware.morf.sql.element.NullValueHandling;
import org.alfasoftware.morf.sql.element.SqlParameter;
import org.alfasoftware.morf.sql.element.TableReference;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;

class NuoDBDialect
extends SqlDialect {
    static final String TEMPORARY_TABLE_PREFIX = "TEMP_";
    static final Set<String> TEMPORARY_TABLES = new HashSet<String>();

    public NuoDBDialect(String schemaName) {
        super(schemaName);
    }

    protected String schemaNamePrefix(Table table) {
        if (table.isTemporary()) {
            return "";
        }
        return this.schemaNamePrefix().toUpperCase();
    }

    public Collection<String> tableDeploymentStatements(Table table) {
        ImmutableList.Builder statements = ImmutableList.builder();
        statements.addAll(this.internalTableDeploymentStatements(table));
        for (Index index : table.indexes()) {
            statements.add((Object)this.optionalDropIndexStatement(table, index));
            statements.addAll(this.indexDeploymentStatements(table, index));
        }
        return statements.build();
    }

    public Collection<String> internalTableDeploymentStatements(Table table) {
        ArrayList<String> statements = new ArrayList<String>();
        StringBuilder createTableStatement = new StringBuilder();
        createTableStatement.append("CREATE ");
        if (table.isTemporary()) {
            createTableStatement.append("TEMPORARY ");
            TEMPORARY_TABLES.add(table.getName());
        }
        createTableStatement.append("TABLE ");
        createTableStatement.append(this.qualifiedTableName(table));
        createTableStatement.append(" (");
        ArrayList<String> primaryKeys = new ArrayList<String>();
        boolean first = true;
        Column autoNumbered = null;
        for (Column column : table.columns()) {
            if (!first) {
                createTableStatement.append(", ");
            }
            createTableStatement.append(column.getName() + " ");
            createTableStatement.append(this.sqlRepresentationOfColumnType(column));
            if (column.isAutoNumbered()) {
                autoNumbered = column;
                int autoNumberStart = autoNumbered.getAutoNumberStart() == -1 ? 1 : autoNumbered.getAutoNumberStart();
                statements.add("DROP SEQUENCE IF EXISTS " + this.schemaNamePrefix() + this.createNuoDBGeneratorSequenceName(table, column));
                statements.add("CREATE SEQUENCE " + this.schemaNamePrefix() + this.createNuoDBGeneratorSequenceName(table, autoNumbered) + " START WITH " + autoNumberStart);
                createTableStatement.append(" GENERATED BY DEFAULT AS IDENTITY(" + this.createNuoDBGeneratorSequenceName(table, autoNumbered) + ")");
            }
            if (column.isPrimaryKey()) {
                primaryKeys.add(column.getName());
            }
            first = false;
        }
        if (!primaryKeys.isEmpty()) {
            createTableStatement.append(", PRIMARY KEY (");
            createTableStatement.append(Joiner.on((String)", ").join(primaryKeys));
            createTableStatement.append(")");
        }
        createTableStatement.append(")");
        statements.add(createTableStatement.toString());
        return statements;
    }

    private String createNuoDBGeneratorSequenceName(Table table, Column column) {
        return table.getName() + "_IDS_" + column.getAutoNumberStart();
    }

    public Collection<String> dropStatements(Table table) {
        if (table.isTemporary()) {
            TEMPORARY_TABLES.remove(table.getName());
        }
        ArrayList<String> dropList = new ArrayList<String>();
        dropList.add("drop table " + this.qualifiedTableName(table));
        for (Column column : table.columns()) {
            if (!column.isAutoNumbered()) continue;
            dropList.add("DROP SEQUENCE IF EXISTS " + this.schemaNamePrefix() + this.createNuoDBGeneratorSequenceName(table, column));
        }
        for (Index index : table.indexes()) {
            dropList.add(this.optionalDropIndexStatement(table, index));
        }
        return dropList;
    }

    protected String getColumnRepresentation(DataType dataType, int width, int scale) {
        switch (dataType) {
            case STRING: {
                return String.format("VARCHAR(%d)", width);
            }
            case DECIMAL: {
                return String.format("DECIMAL(%d,%d)", width, scale);
            }
            case DATE: {
                return "DATE";
            }
            case BOOLEAN: {
                return "SMALLINT";
            }
            case BIG_INTEGER: {
                return "BIGINT";
            }
            case INTEGER: {
                return "INTEGER";
            }
            case BLOB: {
                return "BLOB";
            }
            case CLOB: {
                return "CLOB";
            }
        }
        throw new UnsupportedOperationException("Cannot map column with type [" + dataType + "]");
    }

    protected void prepareBooleanParameter(NamedParameterPreparedStatement statement, Boolean boolVal, SqlParameter parameter) throws SQLException {
        Integer intValue = boolVal == null ? null : Integer.valueOf(boolVal != false ? 1 : 0);
        super.prepareIntegerParameter(statement, intValue, (SqlParameter)SqlUtils.parameter((String)parameter.getImpliedName()).type(DataType.INTEGER));
    }

    public int fetchSizeForBulkSelects() {
        return 1000;
    }

    protected String getFromDummyTable() {
        return " FROM dual ";
    }

    public String connectionTestStatement() {
        return "select 1 from dual";
    }

    public DatabaseType getDatabaseType() {
        return DatabaseType.Registry.findByIdentifier((String)"NUODB");
    }

    protected String getSqlFrom(LocalDate literalValue) {
        return String.format("DATE('%s')", literalValue.toString("yyyy-MM-dd"));
    }

    protected String getSqlFrom(FieldLiteral field) {
        switch (field.getDataType()) {
            case DATE: {
                return String.format("DATE('%s')", field.getValue());
            }
        }
        return super.getSqlFrom(field);
    }

    public Collection<String> alterTableAddColumnStatements(Table table, Column column) {
        ImmutableList.Builder statements = ImmutableList.builder();
        statements.add((Object)("ALTER TABLE " + this.qualifiedTableName(table) + " ADD COLUMN " + column.getName() + ' ' + this.sqlRepresentationOfColumnType(column, true)));
        if (StringUtils.isNotBlank((CharSequence)column.getDefaultValue()) && column.isNullable()) {
            statements.add((Object)("UPDATE " + table.getName() + " SET " + column.getName() + " = " + this.getSqlFrom(new FieldLiteral(column.getDefaultValue(), column.getType()))));
        }
        return statements.build();
    }

    public Collection<String> alterTableChangeColumnStatements(Table table, Column oldColumn, Column newColumn) {
        ArrayList<String> result = new ArrayList<String>();
        List<Index> indexesToRebuild = this.indexesToDropWhenModifyingColumn(table, oldColumn);
        for (Index index : indexesToRebuild) {
            result.addAll(this.indexDropStatements(table, index));
        }
        if (oldColumn.isPrimaryKey()) {
            result.add(this.dropPrimaryKeyConstraintStatement(table));
        }
        if (!newColumn.getName().equals(oldColumn.getName())) {
            result.add("ALTER TABLE " + this.qualifiedTableName(table) + " RENAME COLUMN " + oldColumn.getName() + " TO " + newColumn.getName());
        }
        if (oldColumn.getType() != newColumn.getType() || oldColumn.getScale() != newColumn.getScale() || oldColumn.getWidth() != newColumn.getWidth()) {
            result.add("ALTER TABLE " + this.qualifiedTableName(table) + " ALTER COLUMN " + newColumn.getName() + " TYPE " + this.sqlRepresentationOfColumnType(newColumn, false, false, true));
        }
        result.addAll(this.changeColumnNullability(table, oldColumn, newColumn));
        if (oldColumn.isAutoNumbered() != newColumn.isAutoNumbered()) {
            result.addAll(this.alterTableDropColumnStatements(table, oldColumn));
            result.addAll(this.alterTableAddColumnStatements(table, newColumn));
        }
        List primaryKeys = SchemaUtils.primaryKeysForTable((Table)table);
        if ((newColumn.isPrimaryKey() || oldColumn.isPrimaryKey()) && !primaryKeys.isEmpty()) {
            result.add(this.addPrimaryKeyConstraintStatement(table, SchemaUtils.namesOfColumns((List)primaryKeys)));
        }
        for (Index index : indexesToRebuild) {
            result.addAll(this.indexDeploymentStatements(table, index));
        }
        return result;
    }

    private List<String> changeColumnNullability(Table table, Column oldColumn, Column newColumn) {
        ArrayList<String> result = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)newColumn.getDefaultValue())) {
            result.add("ALTER TABLE " + this.qualifiedTableName(table) + " ALTER COLUMN " + newColumn.getName() + " NOT NULL DEFAULT " + this.sqlForDefaultClauseLiteral(newColumn));
        } else if (!StringUtils.equals((CharSequence)oldColumn.getDefaultValue(), (CharSequence)newColumn.getDefaultValue())) {
            result.add("ALTER TABLE " + this.qualifiedTableName(table) + " ALTER COLUMN " + newColumn.getName() + " DROP DEFAULT");
            result.add("ALTER TABLE " + this.qualifiedTableName(table) + " ALTER COLUMN " + newColumn.getName() + " " + (newColumn.isNullable() ? "NULL" : "NOT NULL"));
        } else if (oldColumn.isNullable() != newColumn.isNullable()) {
            result.add("ALTER TABLE " + this.qualifiedTableName(table) + " ALTER COLUMN " + newColumn.getName() + " " + (newColumn.isNullable() ? "NULL" : "NOT NULL DEFAULT 0"));
            result.add("ALTER TABLE " + this.qualifiedTableName(table) + " ALTER COLUMN " + newColumn.getName() + " DROP DEFAULT");
        }
        return result;
    }

    private List<Index> indexesToDropWhenModifyingColumn(Table table, final Column column) {
        return FluentIterable.from((Iterable)table.indexes()).filter((Predicate)new Predicate<Index>(){

            public boolean apply(Index input) {
                return input.columnNames().contains(column.getName());
            }
        }).toList();
    }

    public Collection<String> alterTableDropColumnStatements(Table table, Column column) {
        ArrayList<String> result = new ArrayList<String>();
        if (column.isPrimaryKey()) {
            result.add(this.dropPrimaryKeyConstraintStatement(table));
        }
        StringBuilder statement = new StringBuilder().append("ALTER TABLE ").append(this.qualifiedTableName(table)).append(" DROP COLUMN ").append(column.getName());
        result.add(statement.toString());
        result.add("DROP SEQUENCE IF EXISTS " + this.schemaNamePrefix() + this.createNuoDBGeneratorSequenceName(table, column));
        return result;
    }

    public Collection<String> changePrimaryKeyColumns(Table table, List<String> oldPrimaryKeyColumns, List<String> newPrimaryKeyColumns) {
        ArrayList<String> result = new ArrayList<String>();
        if (!oldPrimaryKeyColumns.isEmpty()) {
            result.add(this.dropPrimaryKeyConstraintStatement(table));
        }
        if (!newPrimaryKeyColumns.isEmpty()) {
            result.add(this.addPrimaryKeyConstraintStatement(table, newPrimaryKeyColumns));
        }
        return result;
    }

    private String addPrimaryKeyConstraintStatement(Table table, List<String> primaryKeyColumnNames) {
        return "ALTER TABLE " + this.qualifiedTableName(table) + " ADD PRIMARY KEY (" + Joiner.on((String)", ").join(primaryKeyColumnNames) + ")";
    }

    private String dropPrimaryKeyConstraintStatement(Table table) {
        return "DROP INDEX IF EXISTS " + this.schemaNamePrefix(table) + "\"" + table.getName().toUpperCase() + "..PRIMARY_KEY\"";
    }

    public Collection<String> addIndexStatements(Table table, Index index) {
        return ImmutableList.builder().add((Object)this.optionalDropIndexStatement(table, index)).addAll(this.indexDeploymentStatements(table, index)).build();
    }

    protected Collection<String> indexDeploymentStatements(Table table, Index index) {
        StringBuilder statement = new StringBuilder();
        statement.append("CREATE ");
        if (index.isUnique()) {
            statement.append("UNIQUE ");
        }
        return Collections.singletonList(statement.append("INDEX ").append(index.getName()).append(" ON ").append(this.qualifiedTableName(table)).append(" (").append(Joiner.on((char)',').join((Iterable)index.columnNames())).append(")").toString());
    }

    public Collection<String> indexDropStatements(Table table, Index indexToBeRemoved) {
        return Arrays.asList("DROP INDEX " + this.schemaNamePrefix(table) + indexToBeRemoved.getName());
    }

    private String optionalDropIndexStatement(Table table, Index indexToBeRemoved) {
        return "DROP INDEX IF EXISTS " + this.schemaNamePrefix(table) + indexToBeRemoved.getName();
    }

    public Collection<String> renameIndexStatements(Table table, final String fromIndexName, final String toIndexName) {
        Index existingIndex;
        Index newIndex;
        try {
            newIndex = (Index)Iterables.find((Iterable)table.indexes(), (Predicate)new Predicate<Index>(){

                public boolean apply(Index input) {
                    return input.getName().equals(toIndexName);
                }
            });
            existingIndex = newIndex.isUnique() ? SchemaUtils.index((String)fromIndexName).columns((Iterable)newIndex.columnNames()).unique() : SchemaUtils.index((String)fromIndexName).columns((Iterable)newIndex.columnNames());
        }
        catch (NoSuchElementException nsee) {
            existingIndex = (Index)Iterables.find((Iterable)table.indexes(), (Predicate)new Predicate<Index>(){

                public boolean apply(Index input) {
                    return input.getName().equals(fromIndexName);
                }
            });
            newIndex = existingIndex.isUnique() ? SchemaUtils.index((String)toIndexName).columns((Iterable)existingIndex.columnNames()).unique() : SchemaUtils.index((String)toIndexName).columns((Iterable)existingIndex.columnNames());
        }
        return ImmutableList.builder().addAll(this.indexDropStatements(table, existingIndex)).addAll(this.indexDeploymentStatements(table, newIndex)).build();
    }

    protected String getSqlForOrderByField(FieldReference orderByField) {
        switch (orderByField.getNullValueHandling().isPresent() ? (NullValueHandling)orderByField.getNullValueHandling().get() : NullValueHandling.NONE) {
            case FIRST: {
                return this.getSqlFrom((AliasedField)orderByField) + " IS NOT NULL, " + super.getSqlForOrderByField(orderByField);
            }
            case LAST: {
                return this.getSqlFrom((AliasedField)orderByField) + " IS NULL, " + super.getSqlForOrderByField(orderByField);
            }
        }
        return super.getSqlForOrderByField(orderByField);
    }

    protected String getSqlForOrderByFieldNullValueHandling(FieldReference orderByField) {
        return "";
    }

    protected String escapeSql(String literalValue) {
        String escaped = super.escapeSql(literalValue);
        return StringUtils.replace((String)escaped, (String)"\\'", (String)"'||TRIM('\\ ')||''");
    }

    public String decorateTemporaryTableName(String undecoratedName) {
        return TEMPORARY_TABLE_PREFIX + undecoratedName;
    }

    protected String getSqlForYYYYMMDDToDate(Function function) {
        AliasedField field = (AliasedField)function.getArguments().get(0);
        return "DATE_FROM_STR(" + this.getSqlFrom(field) + ", 'yyyyMMdd')";
    }

    protected String getSqlForDateToYyyymmdd(Function function) {
        String sqlExpression = this.getSqlFrom((AliasedField)function.getArguments().get(0));
        return String.format("CAST(DATE_TO_STR(%1$s, 'yyyyMMdd') AS DECIMAL(8))", sqlExpression);
    }

    protected String getSqlForDateToYyyymmddHHmmss(Function function) {
        String sqlExpression = this.getSqlFrom((AliasedField)function.getArguments().get(0));
        return String.format("CAST(DATE_TO_STR(%1$s, 'yyyyMMddHHmmss') AS DECIMAL(14))", sqlExpression);
    }

    protected String getSqlForNow(Function function) {
        return "CURRENT_TIMESTAMP()";
    }

    protected String getSqlForDaysBetween(AliasedField toDate, AliasedField fromDate) {
        String fromDateSql = String.format("DATE_TO_STR(%1$s, 'yyyy-MM-dd')", this.getSqlFrom(fromDate));
        String toDateSql = String.format("DATE_TO_STR(%1$s, 'yyyy-MM-dd')", this.getSqlFrom(toDate));
        return "DATEDIFF(DAY," + fromDateSql + ", " + toDateSql + ")";
    }

    protected String getSqlForMonthsBetween(AliasedField toDate, AliasedField fromDate) {
        String toDateStr = this.getSqlFrom(toDate);
        String fromDateStr = this.getSqlFrom(fromDate);
        return "(EXTRACT(YEAR FROM " + toDateStr + ") - EXTRACT(YEAR FROM " + fromDateStr + ")) * 12+ (EXTRACT(MONTH FROM " + toDateStr + ") - EXTRACT(MONTH FROM " + fromDateStr + "))+ CASE WHEN " + toDateStr + " > " + fromDateStr + " THEN CASE WHEN EXTRACT(DAY FROM " + toDateStr + ") >= EXTRACT(DAY FROM " + fromDateStr + ") THEN 0 WHEN EXTRACT(MONTH FROM " + toDateStr + ") <> EXTRACT(MONTH FROM " + toDateStr + " + 1) THEN 0 ELSE -1 END ELSE CASE WHEN EXTRACT(MONTH FROM " + fromDateStr + ") <> EXTRACT(MONTH FROM " + fromDateStr + " + 1) THEN 0 WHEN EXTRACT(DAY FROM " + fromDateStr + ") >= EXTRACT(DAY FROM " + toDateStr + ") THEN 0 ELSE 1 END END\n";
    }

    protected String getSqlForAddDays(Function function) {
        return String.format("DATE_ADD(%s, INTERVAL %s DAY)", this.getSqlFrom((AliasedField)function.getArguments().get(0)), this.getSqlFrom((AliasedField)function.getArguments().get(1)));
    }

    protected String getSqlForAddMonths(Function function) {
        return String.format("DATE_ADD(%s, INTERVAL %s MONTH)", this.getSqlFrom((AliasedField)function.getArguments().get(0)), this.getSqlFrom((AliasedField)function.getArguments().get(1)));
    }

    public Collection<String> renameTableStatements(Table from, Table to) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (!SchemaUtils.primaryKeysForTable((Table)from).isEmpty()) {
            builder.add((Object)this.dropPrimaryKeyConstraintStatement(from));
        }
        builder.add((Object)("ALTER TABLE " + this.qualifiedTableName(from) + " RENAME TO " + this.qualifiedTableName(to)));
        if (!SchemaUtils.primaryKeysForTable((Table)to).isEmpty()) {
            builder.add((Object)this.addPrimaryKeyConstraintStatement(to, SchemaUtils.namesOfColumns((List)SchemaUtils.primaryKeysForTable((Table)to))));
        }
        return builder.build();
    }

    protected String getSqlFrom(MergeStatement statement) {
        if (StringUtils.isBlank((CharSequence)statement.getTable().getName())) {
            throw new IllegalArgumentException("Cannot create SQL for a blank table");
        }
        this.checkSelectStatementHasNoHints(statement.getSelectStatement(), "MERGE may not be used with SELECT statement hints");
        String destinationTableName = statement.getTable().getName();
        StringBuilder sqlBuilder = new StringBuilder("INSERT INTO ");
        sqlBuilder.append(this.tableNameWithSchemaName(statement.getTable()));
        sqlBuilder.append("(");
        Iterable intoFields = Iterables.transform((Iterable)statement.getSelectStatement().getFields(), AliasedField::getImpliedName);
        sqlBuilder.append(Joiner.on((String)", ").join(intoFields));
        sqlBuilder.append(") ");
        sqlBuilder.append(this.getSqlFrom(statement.getSelectStatement()));
        if (this.getNonKeyFieldsFromMergeStatement(statement).iterator().hasNext()) {
            sqlBuilder.append(" ON DUPLICATE KEY UPDATE ");
            Iterable updateExpressions = this.getMergeStatementUpdateExpressions(statement);
            String updateExpressionsSql = this.getMergeStatementAssignmentsSql(updateExpressions);
            sqlBuilder.append(updateExpressionsSql);
        } else {
            sqlBuilder.append(" ON DUPLICATE KEY SKIP");
        }
        return sqlBuilder.toString();
    }

    protected String getSqlFrom(MergeStatement.InputField field) {
        return "values(" + field.getName() + ")";
    }

    protected String getSqlForRandomString(Function function) {
        return String.format("SUBSTRING(CAST(RAND() AS STRING), 3, %s)", this.getSqlFrom((AliasedField)function.getArguments().get(0)));
    }

    protected String getSqlForLeftPad(AliasedField field, AliasedField length, AliasedField character) {
        String paddingSql = "REPLACE('                    ', ' ', " + this.getSqlFrom(character) + ")";
        String padlengthSql = this.getSqlFrom(length) + " - LENGTH(CAST(" + this.getSqlFrom(field) + " AS STRING))";
        String padjoinSql = "SUBSTRING(" + paddingSql + ", 1, " + padlengthSql + ") || " + this.getSqlFrom(field);
        String padtrimSql = "SUBSTRING(" + this.getSqlFrom(field) + ", 1, " + this.getSqlFrom(length) + ")";
        return "CASE WHEN " + padlengthSql + " > 0 THEN " + padjoinSql + " ELSE " + padtrimSql + " END";
    }

    protected String likeEscapeSuffix() {
        return "";
    }

    protected String getSqlForLastDayOfMonth(AliasedField date) {
        return "DATE_SUB(DATE_ADD(DATE_SUB(" + this.getSqlFrom(date) + ", INTERVAL DAY(" + this.getSqlFrom(date) + ")-1 DAY), INTERVAL 1 MONTH), INTERVAL 1 DAY)";
    }

    private String qualifiedTableName(Table table) {
        if (table.isTemporary()) {
            return table.getName();
        }
        return this.schemaNamePrefix() + table.getName();
    }

    private String qualifiedTableName(TableReference table) {
        if (StringUtils.isBlank((CharSequence)table.getSchemaName())) {
            return this.schemaNamePrefix() + table.getName();
        }
        return table.getSchemaName() + "." + table.getName();
    }

    protected String selectStatementPreFieldDirectives(SelectStatement selectStatement) {
        if (selectStatement.getHints().isEmpty()) {
            return super.selectStatementPreFieldDirectives(selectStatement);
        }
        ArrayList hintTexts = Lists.newArrayList();
        for (Hint hint : selectStatement.getHints()) {
            if (hint instanceof UseIndex) {
                UseIndex useIndex = (UseIndex)hint;
                TableReference table = useIndex.getTable();
                hintTexts.add(String.format("USE_INDEX(%s, %s)", StringUtils.isEmpty((CharSequence)table.getAlias()) ? this.qualifiedTableName(table) : table.getAlias(), useIndex.getIndexName()));
            }
            if (!(hint instanceof UseImplicitJoinOrder)) continue;
            hintTexts.add("ORDERED");
        }
        return hintTexts.isEmpty() ? "" : "/*+ " + Joiner.on((String)", ").join((Iterable)hintTexts) + " */ ";
    }

    protected Optional<String> getDeleteLimitSuffix(int limit) {
        return Optional.of("LIMIT " + limit);
    }

    protected String tableNameWithSchemaName(TableReference tableRef) {
        if (!StringUtils.isEmpty((CharSequence)tableRef.getDblink())) {
            throw new IllegalStateException("DB Links are not supported in the Nuo dialect. Found dbLink=" + tableRef.getDblink() + " for tableNameWithSchemaName=" + super.tableNameWithSchemaName(tableRef));
        }
        if (StringUtils.isEmpty((CharSequence)tableRef.getSchemaName())) {
            if (TEMPORARY_TABLES.contains(tableRef.getName())) {
                return tableRef.getName();
            }
            return this.schemaNamePrefix() + tableRef.getName();
        }
        return tableRef.getSchemaName().toUpperCase() + "." + tableRef.getName();
    }

    protected String getSqlFrom(ExceptSetOperator operator) {
        throw new IllegalStateException("EXCEPT set operator is not supported in the Nuo dialect");
    }
}

