/*
 * Decompiled with CFR 0.152.
 */
package org.alfasoftware.morf.jdbc.nuodb;

import com.google.common.collect.ImmutableSortedMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.alfasoftware.morf.jdbc.AbstractConnectionResources;
import org.alfasoftware.morf.jdbc.ApplicationConnectionResources;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NuoDBDataSourceBuilder {
    private static final Log log = LogFactory.getLog(NuoDBDataSourceBuilder.class);

    public static DataSource build(ApplicationConnectionResources applicationConnectionResources, AbstractConnectionResources connectionDetails) {
        Properties p = new Properties();
        String jdbcUrl = connectionDetails.getJdbcUrl();
        p.setProperty("url", jdbcUrl);
        p.setProperty("maxActive", Integer.toString(applicationConnectionResources.getConnectionPoolSize()));
        p.setProperty("maxStatements", Integer.toString(connectionDetails.getStatementPoolingMaxStatements()));
        p.setProperty("maxStatementsPerConnection", Integer.toString(connectionDetails.getStatementPoolingMaxStatements()));
        p.setProperty("initialSize", "1");
        p.setProperty("minIdle", "1");
        p.setProperty("maxAge", "300000");
        p.setProperty("testOnReturn", "true");
        p.setProperty("validationQuery", "SELECT 1 from dual;");
        p.setProperty("defaultAutoCommit", "false");
        p.setProperty("user", connectionDetails.getUserName());
        p.setProperty("password", connectionDetails.getPassword());
        log.info((Object)("Building NuoDB DataSource with properties [" + ImmutableSortedMap.copyOf((Map)p) + "]"));
        try {
            Class<?> clazz = Class.forName("com.nuodb.jdbc.DataSource");
            Constructor<?> constructor = clazz.getConstructor(Properties.class);
            return (DataSource)constructor.newInstance(p);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

