/*
 * Decompiled with CFR 0.152.
 */
package org.alfasoftware.morf.jdbc.nuodb;

import java.sql.Connection;
import java.util.Optional;
import javax.sql.XADataSource;
import org.alfasoftware.morf.jdbc.AbstractDatabaseType;
import org.alfasoftware.morf.jdbc.JdbcUrlElements;
import org.alfasoftware.morf.jdbc.SqlDialect;
import org.alfasoftware.morf.jdbc.nuodb.NuoDBDialect;
import org.alfasoftware.morf.jdbc.nuodb.NuoDBMetaDataProvider;
import org.alfasoftware.morf.metadata.Schema;

public final class NuoDB
extends AbstractDatabaseType {
    public static final String IDENTIFIER = "NUODB";

    public NuoDB() {
        super("com.nuodb.jdbc.Driver", IDENTIFIER);
    }

    public String formatJdbcUrl(JdbcUrlElements jdbcUrlElements) {
        return "jdbc:com.nuodb://" + jdbcUrlElements.getHostName() + ":" + jdbcUrlElements.getPort() + "/" + jdbcUrlElements.getDatabaseName() + "?isolation=read_committed&schema=" + jdbcUrlElements.getSchemaName();
    }

    public Schema openSchema(Connection connection, String databaseName, String schemaName) {
        return new NuoDBMetaDataProvider(connection, schemaName);
    }

    public XADataSource getXADataSource(String jdbcUrl, String username, String password) {
        throw new UnsupportedOperationException("XA not supported in NuoDB at present");
    }

    public SqlDialect sqlDialect(String schemaName) {
        return new NuoDBDialect(schemaName);
    }

    public boolean matchesProduct(String product) {
        return product.equalsIgnoreCase(IDENTIFIER);
    }

    public Optional<JdbcUrlElements> extractJdbcUrl(String url) {
        return Optional.empty();
    }
}

