/*
 * Decompiled with CFR 0.152.
 */
package org.alfasoftware.morf.jdbc.h2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.alfasoftware.morf.jdbc.DatabaseType;
import org.alfasoftware.morf.metadata.Schema;
import org.alfasoftware.morf.metadata.Sequence;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestH2MetaDataProvider {
    private final DataSource dataSource = (DataSource)Mockito.mock(DataSource.class, (Answer)Mockito.RETURNS_SMART_NULLS);
    private final Connection connection = (Connection)Mockito.mock(Connection.class, (Answer)Mockito.RETURNS_SMART_NULLS);
    private DatabaseType h2;

    @Before
    public void setup() {
        this.h2 = DatabaseType.Registry.findByIdentifier((String)"H2");
    }

    @Before
    public void before() throws SQLException {
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn((Object)this.connection);
    }

    @Test
    public void testLoadSequences() throws SQLException {
        PreparedStatement statement = (PreparedStatement)Mockito.mock(PreparedStatement.class, (Answer)Mockito.RETURNS_SMART_NULLS);
        Mockito.when((Object)this.connection.prepareStatement("SELECT SEQUENCE_NAME FROM INFORMATION_SCHEMA.SEQUENCES WHERE SEQUENCE_SCHEMA =?")).thenReturn((Object)statement);
        Mockito.when((Object)statement.executeQuery()).thenAnswer((Answer)new ReturnMockResultSetWithSequence(1));
        Schema h2MetaDataProvider = this.h2.openSchema(this.connection, "TestDatabase", "TestSchema");
        Assert.assertEquals((String)"Sequence names", (Object)"[Sequence1]", (Object)h2MetaDataProvider.sequenceNames().toString());
        Sequence sequence = (Sequence)h2MetaDataProvider.sequences().iterator().next();
        Assert.assertEquals((String)"Sequence name", (Object)"Sequence1", (Object)sequence.getName());
        ((PreparedStatement)Mockito.verify((Object)statement, (VerificationMode)Mockito.never())).setString(1, "TestSchema");
    }

    private static final class ReturnMockResultSetWithSequence
    implements Answer<ResultSet> {
        private final int numberOfResultRows;

        private ReturnMockResultSetWithSequence(int numberOfResultRows) {
            this.numberOfResultRows = numberOfResultRows;
        }

        public ResultSet answer(InvocationOnMock invocation) throws Throwable {
            ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class, (Answer)Mockito.RETURNS_SMART_NULLS);
            Mockito.when((Object)resultSet.next()).thenAnswer((Answer)new Answer<Boolean>(){
                private int counter;

                public Boolean answer(InvocationOnMock invocation) throws Throwable {
                    return this.counter++ < numberOfResultRows;
                }
            });
            Mockito.when((Object)resultSet.getString(1)).thenReturn((Object)"Sequence1");
            return resultSet;
        }
    }
}

