/*
 * Decompiled with CFR 0.152.
 */
package org.alfasoftware.morf.jdbc.h2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import org.alfasoftware.morf.jdbc.DatabaseMetaDataProvider;
import org.alfasoftware.morf.jdbc.DatabaseMetaDataProviderUtils;
import org.alfasoftware.morf.metadata.SchemaUtils;

class H2MetaDataProvider
extends DatabaseMetaDataProvider {
    private static final Set<String> SYSTEM_TABLES = Set.of("CHECK_CONSTRAINTS", "COLLATIONS", "COLUMNS", "COLUMN_PRIVILEGES", "CONSTANTS", "CONSTRAINT_COLUMN_USAGE", "DOMAINS", "DOMAIN_CONSTRAINTS", "ELEMENT_TYPES", "ENUM_VALUES", "FIELDS", "INDEXES", "INDEX_COLUMNS", "INFORMATION_SCHEMA_CATALOG_NAME", "IN_DOUBT", "KEY_COLUMN_USAGE", "LOCKS", "PARAMETERS", "QUERY_STATISTICS", "REFERENTIAL_CONSTRAINTS", "RIGHTS", "ROLES", "ROUTINES", "SCHEMATA", "SEQUENCES", "SESSIONS", "SESSION_STATE", "SETTINGS", "SYNONYMS", "TABLES", "TABLE_CONSTRAINTS", "TABLE_PRIVILEGES", "TRIGGERS", "USERS", "VIEWS");

    public H2MetaDataProvider(Connection connection) {
        super(connection, "PUBLIC");
    }

    public H2MetaDataProvider(Connection connection, String schemaName) {
        super(connection, schemaName);
    }

    protected boolean isPrimaryKeyIndex(DatabaseMetaDataProvider.RealName indexName) {
        return indexName.getDbName().startsWith("PRIMARY_KEY");
    }

    protected boolean isIgnoredTable(DatabaseMetaDataProvider.RealName tableName) {
        return tableName.getDbName().startsWith("TEMP_");
    }

    protected boolean isSystemTable(DatabaseMetaDataProvider.RealName tableName) {
        return SYSTEM_TABLES.contains(tableName.getDbName());
    }

    protected boolean isSystemSequence(DatabaseMetaDataProvider.RealName sequenceName) {
        return sequenceName.getDbName().startsWith("SYSTEM_SEQUENCE_");
    }

    protected SchemaUtils.ColumnBuilder setAdditionalColumnMetadata(DatabaseMetaDataProvider.RealName tableName, SchemaUtils.ColumnBuilder columnBuilder, ResultSet columnMetaData) throws SQLException {
        if ((columnBuilder = super.setAdditionalColumnMetadata(tableName, columnBuilder, columnMetaData)).isAutoNumbered()) {
            int startValue = DatabaseMetaDataProviderUtils.getAutoIncrementStartValue((String)columnMetaData.getString(12));
            return columnBuilder.autoNumbered(startValue == -1 ? 1 : startValue);
        }
        return columnBuilder;
    }

    protected String buildSequenceSql(String schemaName) {
        StringBuilder sequenceSqlBuilder = new StringBuilder();
        sequenceSqlBuilder.append("SELECT SEQUENCE_NAME FROM INFORMATION_SCHEMA.SEQUENCES");
        if (schemaName != null && !schemaName.isBlank()) {
            sequenceSqlBuilder.append(" WHERE SEQUENCE_SCHEMA =?");
        }
        return sequenceSqlBuilder.toString();
    }
}

