/*
 * Decompiled with CFR 0.152.
 */
package org.alfasoftware.morf.jdbc.h2;

import java.util.List;
import org.alfasoftware.morf.jdbc.h2.H2DialectExt;
import org.alfasoftware.morf.jdbc.h2.H2Sql;
import org.alfasoftware.morf.sql.DeleteStatement;
import org.alfasoftware.morf.sql.InsertStatement;
import org.alfasoftware.morf.sql.MergeStatement;
import org.alfasoftware.morf.sql.SelectFirstStatement;
import org.alfasoftware.morf.sql.SelectStatement;
import org.alfasoftware.morf.sql.Statement;
import org.alfasoftware.morf.sql.TruncateStatement;
import org.alfasoftware.morf.sql.UpdateStatement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;

public class TestH2Sql {
    @Spy
    private H2DialectExt h2DialectExt = new H2DialectExt();
    private H2Sql h2Sql;

    @Before
    public void setUp() {
        MockitoAnnotations.openMocks((Object)this);
        this.h2Sql = this.h2DialectExt.createH2Sql();
    }

    @Test
    public void testCreateH2Sql() {
        H2DialectExt h2DialectExt = new H2DialectExt();
        H2Sql result = h2DialectExt.createH2Sql();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testSqlFromSelectStatement() {
        SelectStatement statement = (SelectStatement)Mockito.mock(SelectStatement.class);
        String expectedSql = "SELECT * FROM table";
        ((H2DialectExt)Mockito.doReturn((Object)expectedSql).when((Object)this.h2DialectExt)).convertStatementToSQL(statement);
        String result = this.h2Sql.sqlFrom(statement);
        Assert.assertEquals((Object)expectedSql, (Object)result);
        ((H2DialectExt)Mockito.verify((Object)this.h2DialectExt, (VerificationMode)Mockito.times((int)1))).convertStatementToSQL(statement);
    }

    @Test
    public void testSqlFromSelectFirstStatement() {
        SelectFirstStatement statement = (SelectFirstStatement)Mockito.mock(SelectFirstStatement.class);
        String expectedSql = "SELECT FIRST * FROM table";
        ((H2DialectExt)Mockito.doReturn((Object)expectedSql).when((Object)this.h2DialectExt)).convertStatementToSQL(statement);
        String result = this.h2Sql.sqlFrom(statement);
        Assert.assertEquals((Object)expectedSql, (Object)result);
        ((H2DialectExt)Mockito.verify((Object)this.h2DialectExt, (VerificationMode)Mockito.times((int)1))).convertStatementToSQL(statement);
    }

    @Test
    public void testSqlFromInsertStatement() {
        InsertStatement statement = (InsertStatement)Mockito.mock(InsertStatement.class);
        List<String> expectedSql = List.of("INSERT INTO table (column1) VALUES ('value1')");
        ((H2DialectExt)Mockito.doReturn(expectedSql).when((Object)this.h2DialectExt)).convertStatementToSQL(statement);
        List result = this.h2Sql.sqlFrom(statement);
        Assert.assertEquals(expectedSql, (Object)result);
        ((H2DialectExt)Mockito.verify((Object)this.h2DialectExt, (VerificationMode)Mockito.times((int)1))).convertStatementToSQL(statement);
    }

    @Test
    public void testSqlFromUpdateStatement() {
        UpdateStatement statement = (UpdateStatement)Mockito.mock(UpdateStatement.class);
        String expectedSql = "UPDATE table SET column1 = 'value1' WHERE condition";
        ((H2DialectExt)Mockito.doReturn((Object)expectedSql).when((Object)this.h2DialectExt)).convertStatementToSQL(statement);
        String result = this.h2Sql.sqlFrom(statement);
        Assert.assertEquals((Object)expectedSql, (Object)result);
        ((H2DialectExt)Mockito.verify((Object)this.h2DialectExt, (VerificationMode)Mockito.times((int)1))).convertStatementToSQL(statement);
    }

    @Test
    public void testSqlFromMergeStatement() {
        MergeStatement statement = (MergeStatement)Mockito.mock(MergeStatement.class);
        String expectedSql = "MERGE INTO table USING source ON condition WHEN MATCHED THEN UPDATE SET column1 = 'value1' WHEN NOT MATCHED THEN INSERT (column1) VALUES ('value1')";
        ((H2DialectExt)Mockito.doReturn((Object)expectedSql).when((Object)this.h2DialectExt)).convertStatementToSQL(statement);
        String result = this.h2Sql.sqlFrom(statement);
        Assert.assertEquals((Object)expectedSql, (Object)result);
        ((H2DialectExt)Mockito.verify((Object)this.h2DialectExt, (VerificationMode)Mockito.times((int)1))).convertStatementToSQL(statement);
    }

    @Test
    public void testSqlFromDeleteStatement() {
        DeleteStatement statement = (DeleteStatement)Mockito.mock(DeleteStatement.class);
        String expectedSql = "DELETE FROM table WHERE condition";
        ((H2DialectExt)Mockito.doReturn((Object)expectedSql).when((Object)this.h2DialectExt)).convertStatementToSQL(statement);
        String result = this.h2Sql.sqlFrom(statement);
        Assert.assertEquals((Object)expectedSql, (Object)result);
        ((H2DialectExt)Mockito.verify((Object)this.h2DialectExt, (VerificationMode)Mockito.times((int)1))).convertStatementToSQL(statement);
    }

    @Test
    public void testSqlFromTruncateStatement() {
        TruncateStatement statement = (TruncateStatement)Mockito.mock(TruncateStatement.class);
        String expectedSql = "TRUNCATE TABLE table";
        ((H2DialectExt)Mockito.doReturn((Object)expectedSql).when((Object)this.h2DialectExt)).convertStatementToSQL(statement);
        String result = this.h2Sql.sqlFrom(statement);
        Assert.assertEquals((Object)expectedSql, (Object)result);
        ((H2DialectExt)Mockito.verify((Object)this.h2DialectExt, (VerificationMode)Mockito.times((int)1))).convertStatementToSQL(statement);
    }

    @Test
    public void testSqlFromNonInsertStatement() {
        Statement updateStatement = (Statement)Mockito.mock(Statement.class);
        List<String> expectedSql = List.of("UPDATE table SET column1 = 'value1' WHERE condition");
        ((H2DialectExt)Mockito.doReturn(expectedSql).when((Object)this.h2DialectExt)).convertStatementToSQL(updateStatement, null, null);
        List result = this.h2Sql.sqlFrom(updateStatement);
        Assert.assertEquals(expectedSql, (Object)result);
        ((H2DialectExt)Mockito.verify((Object)this.h2DialectExt, (VerificationMode)Mockito.times((int)1))).convertStatementToSQL(updateStatement, null, null);
    }
}

