/*
 * Decompiled with CFR 0.152.
 */
package org.alfasoftware.morf.jdbc.h2;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.alfasoftware.morf.jdbc.DatabaseType;
import org.alfasoftware.morf.jdbc.SqlDialect;
import org.alfasoftware.morf.metadata.Column;
import org.alfasoftware.morf.metadata.DataType;
import org.alfasoftware.morf.metadata.Index;
import org.alfasoftware.morf.metadata.SchemaUtils;
import org.alfasoftware.morf.metadata.Sequence;
import org.alfasoftware.morf.metadata.Table;
import org.alfasoftware.morf.sql.element.AliasedField;
import org.alfasoftware.morf.sql.element.BlobFieldLiteral;
import org.alfasoftware.morf.sql.element.Function;
import org.alfasoftware.morf.sql.element.FunctionType;
import org.alfasoftware.morf.sql.element.PortableSqlFunction;
import org.alfasoftware.morf.sql.element.SequenceReference;
import org.alfasoftware.morf.sql.element.SqlParameter;
import org.alfasoftware.morf.sql.element.TableReference;
import org.apache.commons.lang3.StringUtils;

class H2Dialect
extends SqlDialect {
    public static final String TEMPORARY_TABLE_PREFIX = "TEMP_";
    public static final String SYSTEM_SEQUENCE_PREFIX = "SYSTEM_SEQUENCE_";

    public H2Dialect(String schemaName) {
        super(schemaName);
    }

    public Collection<String> internalTableDeploymentStatements(Table table) {
        ArrayList<String> statements = new ArrayList<String>();
        StringBuilder createTableStatement = new StringBuilder();
        createTableStatement.append("CREATE ");
        if (table.isTemporary()) {
            createTableStatement.append("TEMPORARY ");
        }
        createTableStatement.append("TABLE ");
        createTableStatement.append(this.schemaNamePrefix());
        createTableStatement.append(table.getName());
        createTableStatement.append(" (");
        ArrayList<String> primaryKeys = new ArrayList<String>();
        boolean first = true;
        for (Column column : table.columns()) {
            if (!first) {
                createTableStatement.append(", ");
            }
            createTableStatement.append(column.getName()).append(" ");
            createTableStatement.append(this.sqlRepresentationOfColumnType(column));
            if (column.isAutoNumbered()) {
                int autoNumberStart = column.getAutoNumberStart() == -1 ? 1 : column.getAutoNumberStart();
                createTableStatement.append(" AUTO_INCREMENT(").append(autoNumberStart).append(") COMMENT 'AUTONUMSTART:[").append(autoNumberStart).append("]'");
            }
            if (column.isPrimaryKey()) {
                primaryKeys.add(column.getName());
            }
            first = false;
        }
        if (!primaryKeys.isEmpty()) {
            createTableStatement.append(", CONSTRAINT ");
            createTableStatement.append(table.getName());
            createTableStatement.append("_PK PRIMARY KEY (");
            createTableStatement.append(Joiner.on((String)", ").join(primaryKeys));
            createTableStatement.append(")");
        }
        createTableStatement.append(")");
        statements.add(createTableStatement.toString());
        return statements;
    }

    public Collection<String> internalSequenceDeploymentStatements(Sequence sequence) {
        ArrayList<String> statements = new ArrayList<String>();
        StringBuilder createSequenceStatement = new StringBuilder();
        createSequenceStatement.append("CREATE ");
        createSequenceStatement.append("SEQUENCE ");
        createSequenceStatement.append(this.schemaNamePrefix());
        createSequenceStatement.append(sequence.getName());
        if (sequence.getStartsWith() != null) {
            createSequenceStatement.append(" START WITH ");
            createSequenceStatement.append(sequence.getStartsWith());
        }
        statements.add(createSequenceStatement.toString());
        return statements;
    }

    public Collection<String> dropStatements(Table table) {
        return this.dropTables(Lists.newArrayList((Object[])new Table[]{table}), false, true);
    }

    protected String getColumnRepresentation(DataType dataType, int width, int scale) {
        switch (dataType) {
            case STRING: {
                return width == 0 ? "VARCHAR" : String.format("VARCHAR(%d)", width);
            }
            case DECIMAL: {
                return width == 0 ? "DECIMAL" : String.format("DECIMAL(%d,%d)", width, scale);
            }
            case DATE: {
                return "DATE";
            }
            case BOOLEAN: {
                return "BIT";
            }
            case BIG_INTEGER: {
                return "BIGINT";
            }
            case INTEGER: {
                return "INTEGER";
            }
            case BLOB: {
                return "LONGVARBINARY";
            }
            case CLOB: {
                return "NCLOB";
            }
        }
        throw new UnsupportedOperationException("Cannot map column with type [" + String.valueOf(dataType) + "]");
    }

    protected String getFromDummyTable() {
        return " FROM dual";
    }

    public String connectionTestStatement() {
        return "select 1";
    }

    public DatabaseType getDatabaseType() {
        return DatabaseType.Registry.findByIdentifier((String)"H2");
    }

    public Collection<String> alterTableAddColumnStatements(Table table, Column column) {
        String statement = "ALTER TABLE " + this.schemaNamePrefix() + table.getName() + " ADD COLUMN " + column.getName() + " " + this.sqlRepresentationOfColumnType(column, true);
        return Collections.singletonList(statement);
    }

    public Collection<String> alterTableChangeColumnStatements(Table table, Column oldColumn, Column newColumn) {
        ArrayList<String> result = new ArrayList<String>();
        if (oldColumn.isPrimaryKey() && !newColumn.isPrimaryKey()) {
            result.add(this.dropPrimaryKeyConstraintStatement(table));
        }
        if (!newColumn.getName().equals(oldColumn.getName())) {
            result.add("ALTER TABLE " + this.schemaNamePrefix() + table.getName() + " ALTER COLUMN " + oldColumn.getName() + " RENAME TO " + newColumn.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)newColumn.getDefaultValue())) {
            result.add("ALTER TABLE " + this.schemaNamePrefix() + table.getName() + " ALTER COLUMN " + newColumn.getName() + " SET DEFAULT " + this.sqlForDefaultClauseLiteral(newColumn));
        }
        if (oldColumn.isNullable() != newColumn.isNullable()) {
            result.add("ALTER TABLE " + this.schemaNamePrefix() + table.getName() + " ALTER COLUMN " + newColumn.getName() + " SET " + (newColumn.isNullable() ? "NULL" : "NOT NULL"));
        }
        if (oldColumn.getType() != newColumn.getType() || oldColumn.getScale() != newColumn.getScale() || oldColumn.getWidth() != newColumn.getWidth() || !StringUtils.equals((CharSequence)oldColumn.getDefaultValue(), (CharSequence)newColumn.getDefaultValue()) || oldColumn.isAutoNumbered() != newColumn.isAutoNumbered()) {
            result.add("ALTER TABLE " + this.schemaNamePrefix() + table.getName() + " ALTER COLUMN " + newColumn.getName() + " " + this.sqlRepresentationOfColumnType(newColumn, false, false, true));
        }
        List primaryKeys = SchemaUtils.primaryKeysForTable((Table)table);
        if (oldColumn.isPrimaryKey() != newColumn.isPrimaryKey() && !primaryKeys.isEmpty()) {
            result.add(this.addPrimaryKeyConstraintStatement(table, SchemaUtils.namesOfColumns((List)primaryKeys)));
        }
        return result;
    }

    public Collection<String> alterTableDropColumnStatements(Table table, Column column) {
        String statement = "ALTER TABLE " + this.schemaNamePrefix() + table.getName() + " DROP COLUMN " + column.getName();
        return Collections.singletonList(statement);
    }

    public Collection<String> changePrimaryKeyColumns(Table table, List<String> oldPrimaryKeyColumns, List<String> newPrimaryKeyColumns) {
        ArrayList<String> result = new ArrayList<String>();
        if (!oldPrimaryKeyColumns.isEmpty()) {
            result.add(this.dropPrimaryKeyConstraintStatement(table));
        }
        if (!newPrimaryKeyColumns.isEmpty()) {
            result.add(this.addPrimaryKeyConstraintStatement(table, newPrimaryKeyColumns));
        }
        return result;
    }

    private String addPrimaryKeyConstraintStatement(Table table, List<String> primaryKeyColumnNames) {
        return "ALTER TABLE " + this.schemaNamePrefix() + table.getName() + " ADD CONSTRAINT " + table.getName() + "_PK PRIMARY KEY (" + Joiner.on((String)", ").join(primaryKeyColumnNames) + ")";
    }

    private String dropPrimaryKeyConstraintStatement(Table table) {
        return "ALTER TABLE " + this.schemaNamePrefix() + table.getName() + " DROP PRIMARY KEY";
    }

    protected Collection<String> indexDeploymentStatements(Table table, Index index) {
        StringBuilder statement = new StringBuilder();
        statement.append("CREATE ");
        if (index.isUnique()) {
            statement.append("UNIQUE ");
        }
        statement.append("INDEX ").append(index.getName()).append(" ON ").append(this.schemaNamePrefix()).append(table.getName()).append(" (").append(Joiner.on((char)',').join((Iterable)index.columnNames())).append(")");
        return Collections.singletonList(statement.toString());
    }

    public Collection<String> indexDropStatements(Table table, Index indexToBeRemoved) {
        return Arrays.asList("DROP INDEX " + indexToBeRemoved.getName());
    }

    protected String getSqlFrom(Boolean literalValue) {
        return literalValue != false ? "true" : "false";
    }

    protected String getSqlFrom(BlobFieldLiteral field) {
        return String.format("X'%s'", field.getValue());
    }

    protected String makeStringLiteral(String literalValue) {
        if (StringUtils.isEmpty((CharSequence)literalValue)) {
            return "NULL";
        }
        return String.format("CAST(%s AS VARCHAR(%d))", super.makeStringLiteral(literalValue), literalValue.length());
    }

    public String decorateTemporaryTableName(String undecoratedName) {
        return TEMPORARY_TABLE_PREFIX + undecoratedName;
    }

    protected String getSqlForYYYYMMDDToDate(Function function) {
        AliasedField field = (AliasedField)function.getArguments().get(0);
        return "CAST(SUBSTRING(" + this.getSqlFrom(field) + ", 1, 4)||'-'||SUBSTRING(" + this.getSqlFrom(field) + ", 5, 2)||'-'||SUBSTRING(" + this.getSqlFrom(field) + ", 7, 2) AS DATE)";
    }

    protected String getSqlForDateToYyyymmdd(Function function) {
        String sqlExpression = this.getSqlFrom((AliasedField)function.getArguments().get(0));
        return String.format("CAST(SUBSTRING(%1$s, 1, 4)||SUBSTRING(%1$s, 6, 2)||SUBSTRING(%1$s, 9, 2) AS DECIMAL(8))", sqlExpression);
    }

    protected String getSqlForDateToYyyymmddHHmmss(Function function) {
        String sqlExpression = this.getSqlFrom((AliasedField)function.getArguments().get(0));
        return String.format("CAST(SUBSTRING(%1$s, 1, 4)||SUBSTRING(%1$s, 6, 2)||SUBSTRING(%1$s, 9, 2)||SUBSTRING(%1$s, 12, 2)||SUBSTRING(%1$s, 15, 2)||SUBSTRING(%1$s, 18, 2) AS DECIMAL(14))", sqlExpression);
    }

    protected String getSqlForNow(Function function) {
        return "CURRENT_TIMESTAMP()";
    }

    protected String getSqlForDaysBetween(AliasedField toDate, AliasedField fromDate) {
        return "DATEDIFF('DAY'," + this.getSqlFrom(fromDate) + ", " + this.getSqlFrom(toDate) + ")";
    }

    protected String getSqlForMonthsBetween(AliasedField toDate, AliasedField fromDate) {
        return String.format("CASE WHEN %1$s = %2$s THEN 0 ELSE DATEDIFF(MONTH, %1$s, %2$s) + CASE WHEN %2$s > %1$s THEN CASE WHEN DAY(%1$s) <= DAY(%2$s) OR MONTH(%2$s) <> MONTH(DATEADD(DAY, 1, %2$s)) THEN 0 ELSE -1 END ELSE CASE WHEN DAY(%2$s) <= DAY(%1$s) OR MONTH(%1$s) <> MONTH(DATEADD(DAY, 1, %1$s)) THEN 0 ELSE 1 END END END ", this.getSqlFrom(fromDate), this.getSqlFrom(toDate));
    }

    protected String getSqlForAddDays(Function function) {
        return String.format("DATEADD('DAY', %s, %s)", this.getSqlFrom((AliasedField)function.getArguments().get(1)), this.getSqlFrom((AliasedField)function.getArguments().get(0)));
    }

    protected String getSqlForAddMonths(Function function) {
        return String.format("DATEADD('MONTH', %s, %s)", this.getSqlFrom((AliasedField)function.getArguments().get(1)), this.getSqlFrom((AliasedField)function.getArguments().get(0)));
    }

    public Collection<String> renameTableStatements(Table from, Table to) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (!SchemaUtils.primaryKeysForTable((Table)from).isEmpty()) {
            builder.add((Object)this.dropPrimaryKeyConstraintStatement(from));
        }
        builder.add((Object)("ALTER TABLE " + this.schemaNamePrefix() + from.getName() + " RENAME TO " + to.getName()));
        if (!SchemaUtils.primaryKeysForTable((Table)to).isEmpty()) {
            builder.add((Object)this.addPrimaryKeyConstraintStatement(to, SchemaUtils.namesOfColumns((List)SchemaUtils.primaryKeysForTable((Table)to))));
        }
        return builder.build();
    }

    protected String getSqlFrom(SqlParameter sqlParameter) {
        return String.format("CAST(:%s AS %s)", sqlParameter.getMetadata().getName(), this.sqlRepresentationOfColumnType(sqlParameter.getMetadata(), false));
    }

    protected String getSqlFrom(SequenceReference sequenceReference) {
        StringBuilder result = new StringBuilder();
        switch (sequenceReference.getTypeOfOperation()) {
            case NEXT_VALUE: {
                result.append("NEXT");
                break;
            }
            case CURRENT_VALUE: {
                result.append("CURRENT");
            }
        }
        result.append(" VALUE FOR ");
        result.append(sequenceReference.getName());
        return result.toString();
    }

    protected String getSqlForRandomString(Function function) {
        return String.format("SUBSTRING(REPLACE(RANDOM_UUID(),'-'), 1, %s)", this.getSqlFrom((AliasedField)function.getArguments().get(0)));
    }

    protected String getSqlForLastDayOfMonth(AliasedField date) {
        return "DATEADD(dd, -DAY(DATEADD(m,1," + this.getSqlFrom(date) + ")), DATEADD(m,1," + this.getSqlFrom(date) + "))";
    }

    protected String getSqlForRowNumber() {
        return "ROW_NUMBER() OVER()";
    }

    protected String getSqlForWindowFunction(Function function) {
        FunctionType functionType = function.getType();
        switch (functionType) {
            case ROW_NUMBER: {
                return "ROW_NUMBER()";
            }
        }
        return super.getSqlForWindowFunction(function);
    }

    protected Optional<String> getDeleteLimitSuffix(int limit) {
        return Optional.of("LIMIT " + limit);
    }

    protected String tableNameWithSchemaName(TableReference tableRef) {
        if (!StringUtils.isEmpty((CharSequence)tableRef.getDblink())) {
            throw new IllegalStateException("DB Links are not supported in the H2 dialect. Found dbLink=" + tableRef.getDblink() + " for tableNameWithSchemaName=" + super.tableNameWithSchemaName(tableRef));
        }
        return super.tableNameWithSchemaName(tableRef);
    }

    protected String getSqlFrom(PortableSqlFunction function) {
        return super.getSqlForPortableFunction(function.getFunctionForDatabaseType("H2"));
    }

    public boolean useForcedSerialImport() {
        return true;
    }
}

