/*
 * Decompiled with CFR 0.152.
 */
package org.alfasoftware.morf.jdbc.h2;

import java.io.File;
import java.sql.Connection;
import java.util.Optional;
import javax.sql.XADataSource;
import org.alfasoftware.morf.jdbc.AbstractDatabaseType;
import org.alfasoftware.morf.jdbc.JdbcUrlElements;
import org.alfasoftware.morf.jdbc.SqlDialect;
import org.alfasoftware.morf.jdbc.h2.H2Dialect;
import org.alfasoftware.morf.jdbc.h2.H2MetaDataProvider;
import org.alfasoftware.morf.metadata.Schema;
import org.apache.commons.lang3.StringUtils;

public final class H2
extends AbstractDatabaseType {
    public static final String IDENTIFIER = "H2";

    public H2() {
        super("org.h2.Driver", IDENTIFIER);
    }

    public String formatJdbcUrl(JdbcUrlElements jdbcUrlElements) {
        StringBuilder builder = new StringBuilder().append("jdbc:h2:");
        if (StringUtils.isNotBlank((CharSequence)jdbcUrlElements.getHostName()) && !"localhost".equals(jdbcUrlElements.getHostName()) || jdbcUrlElements.getPort() > 0) {
            builder.append("tcp://").append(jdbcUrlElements.getHostName()).append((String)(jdbcUrlElements.getPort() == 0 ? "" : ":" + jdbcUrlElements.getPort())).append("/mem:").append(jdbcUrlElements.getDatabaseName());
        } else if (StringUtils.isBlank((CharSequence)jdbcUrlElements.getInstanceName())) {
            builder.append("mem:").append(jdbcUrlElements.getDatabaseName());
        } else {
            builder.append("file:").append(jdbcUrlElements.getInstanceName()).append(jdbcUrlElements.getInstanceName().endsWith(File.separator) ? "" : File.separator).append(jdbcUrlElements.getDatabaseName());
        }
        builder.append(";DB_CLOSE_DELAY=-1;DEFAULT_LOCK_TIMEOUT=150000;LOB_TIMEOUT=2000;MV_STORE=TRUE");
        return builder.toString();
    }

    public Schema openSchema(Connection connection, String databaseName, String schemaName) {
        return new H2MetaDataProvider(connection);
    }

    public XADataSource getXADataSource(String jdbcUrl, String username, String password) {
        throw new UnsupportedOperationException("H2 does not fully support XA connections. It may cause many different problems while running integration tests with H2. Please switch off Atomikos or change database engine. See WEB-31172 for details");
    }

    public SqlDialect sqlDialect(String schemaName) {
        return new H2Dialect(schemaName);
    }

    public boolean matchesProduct(String product) {
        return product.equalsIgnoreCase(IDENTIFIER);
    }

    public Optional<JdbcUrlElements> extractJdbcUrl(String url) {
        return Optional.empty();
    }
}

