/*
 * Decompiled with CFR 0.152.
 */
package org.alfasoftware.morf.jdbc.h2;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.alfasoftware.morf.jdbc.AbstractSqlDialectTest;
import org.alfasoftware.morf.jdbc.SqlDialect;
import org.alfasoftware.morf.jdbc.h2.H2Dialect;
import org.apache.commons.lang3.StringUtils;

public class TestH2Dialect
extends AbstractSqlDialectTest {
    private static final String TEST_SCHEMA = "TESTSCHEMA";

    protected SqlDialect createTestDialect() {
        return new H2Dialect(TEST_SCHEMA);
    }

    protected List<String> expectedCreateTableStatements() {
        return Arrays.asList("CREATE TABLE TESTSCHEMA.Test (id BIGINT NOT NULL, version INTEGER DEFAULT 0, stringField VARCHAR(3), intField INTEGER, floatField DECIMAL(13,2) NOT NULL, dateField DATE, booleanField BIT, charField VARCHAR(1), blobField LONGVARBINARY, bigIntegerField BIGINT DEFAULT 12345, clobField NCLOB, CONSTRAINT Test_PK PRIMARY KEY (id))", "CREATE UNIQUE INDEX Test_NK ON TESTSCHEMA.Test (stringField)", "CREATE UNIQUE INDEX Test_1 ON TESTSCHEMA.Test (intField,floatField)", "CREATE TABLE TESTSCHEMA.Alternate (id BIGINT NOT NULL, version INTEGER DEFAULT 0, stringField VARCHAR(3), CONSTRAINT Alternate_PK PRIMARY KEY (id))", "CREATE INDEX Alternate_1 ON TESTSCHEMA.Alternate (stringField)", "CREATE TABLE TESTSCHEMA.NonNull (id BIGINT NOT NULL, version INTEGER DEFAULT 0, stringField VARCHAR(3) NOT NULL, intField DECIMAL(8,0) NOT NULL, booleanField BIT NOT NULL, dateField DATE NOT NULL, blobField LONGVARBINARY NOT NULL, CONSTRAINT NonNull_PK PRIMARY KEY (id))", "CREATE TABLE TESTSCHEMA.CompositePrimaryKey (id BIGINT NOT NULL, version INTEGER DEFAULT 0, stringField VARCHAR(3) NOT NULL, secondPrimaryKey VARCHAR(3) NOT NULL, CONSTRAINT CompositePrimaryKey_PK PRIMARY KEY (id, secondPrimaryKey))", "CREATE TABLE TESTSCHEMA.AutoNumber (intField BIGINT AUTO_INCREMENT(5) COMMENT 'AUTONUMSTART:[5]', CONSTRAINT AutoNumber_PK PRIMARY KEY (intField))");
    }

    protected List<String> expectedCreateTemporaryTableStatements() {
        return Arrays.asList("CREATE TEMPORARY TABLE TESTSCHEMA.TEMP_TempTest (id BIGINT NOT NULL, version INTEGER DEFAULT 0, stringField VARCHAR(3), intField INTEGER, floatField DECIMAL(13,2) NOT NULL, dateField DATE, booleanField BIT, charField VARCHAR(1), blobField LONGVARBINARY, bigIntegerField BIGINT DEFAULT 12345, clobField NCLOB, CONSTRAINT TEMP_TempTest_PK PRIMARY KEY (id))", "CREATE UNIQUE INDEX TempTest_NK ON TESTSCHEMA.TEMP_TempTest (stringField)", "CREATE INDEX TempTest_1 ON TESTSCHEMA.TEMP_TempTest (intField,floatField)", "CREATE TEMPORARY TABLE TESTSCHEMA.TEMP_TempAlternate (id BIGINT NOT NULL, version INTEGER DEFAULT 0, stringField VARCHAR(3), CONSTRAINT TEMP_TempAlternate_PK PRIMARY KEY (id))", "CREATE INDEX TempAlternate_1 ON TESTSCHEMA.TEMP_TempAlternate (stringField)", "CREATE TEMPORARY TABLE TESTSCHEMA.TEMP_TempNonNull (id BIGINT NOT NULL, version INTEGER DEFAULT 0, stringField VARCHAR(3) NOT NULL, intField DECIMAL(8,0) NOT NULL, booleanField BIT NOT NULL, dateField DATE NOT NULL, blobField LONGVARBINARY NOT NULL, CONSTRAINT TEMP_TempNonNull_PK PRIMARY KEY (id))");
    }

    protected List<String> expectedCreateTableStatementsWithLongTableName() {
        return Arrays.asList("CREATE TABLE TESTSCHEMA.tableWithANameThatExceeds30Char (id BIGINT NOT NULL, version INTEGER DEFAULT 0, stringField VARCHAR(3), intField DECIMAL(8,0), floatField DECIMAL(13,2) NOT NULL, dateField DATE, booleanField BIT, charField VARCHAR(1), CONSTRAINT tableWithANameThatExceeds30Char_PK PRIMARY KEY (id))", "CREATE UNIQUE INDEX Test_NK ON TESTSCHEMA.tableWithANameThatExceeds30Char (stringField)", "CREATE INDEX Test_1 ON TESTSCHEMA.tableWithANameThatExceeds30Char (intField,floatField)");
    }

    protected List<String> expectedDropTableStatements() {
        return Arrays.asList("DROP TABLE TESTSCHEMA.Test CASCADE");
    }

    protected List<String> expectedDropSingleTable() {
        return Arrays.asList("DROP TABLE TESTSCHEMA.Test");
    }

    protected List<String> expectedDropTables() {
        return Arrays.asList("DROP TABLE TESTSCHEMA.Test, TESTSCHEMA.Other");
    }

    protected List<String> expectedDropTablesWithParameters() {
        return Arrays.asList("DROP TABLE IF EXISTS TESTSCHEMA.Test, TESTSCHEMA.Other CASCADE");
    }

    protected List<String> expectedDropTempTableStatements() {
        return Arrays.asList("DROP TABLE TESTSCHEMA.TEMP_TempTest CASCADE");
    }

    protected List<String> expectedTruncateTableStatements() {
        return Arrays.asList("TRUNCATE TABLE TESTSCHEMA.Test");
    }

    protected List<String> expectedTruncateTempTableStatements() {
        return Arrays.asList("TRUNCATE TABLE TESTSCHEMA.TEMP_TempTest");
    }

    protected List<String> expectedDeleteAllFromTableStatements() {
        return Arrays.asList("DELETE FROM TESTSCHEMA.Test");
    }

    protected String expectedParameterisedInsertStatement() {
        return "INSERT INTO TESTSCHEMA.Test (id, version, stringField, intField, floatField, dateField, booleanField, charField, blobField, bigIntegerField, clobField) VALUES (5, CAST(:version AS INTEGER), CAST('Escap''d' AS VARCHAR(7)), 7, CAST(:floatField AS DECIMAL(13,2)), 20100405, true, CAST(:charField AS VARCHAR(1)), CAST(:blobField AS LONGVARBINARY), CAST(:bigIntegerField AS BIGINT), CAST(:clobField AS NCLOB))";
    }

    protected String expectedParameterisedInsertStatementWithTableInDifferentSchema() {
        return "INSERT INTO MYSCHEMA.Test (id, version, stringField, intField, floatField, dateField, booleanField, charField, blobField, bigIntegerField, clobField) VALUES (5, CAST(:version AS INTEGER), CAST('Escap''d' AS VARCHAR(7)), 7, CAST(:floatField AS DECIMAL(13,2)), 20100405, true, CAST(:charField AS VARCHAR(1)), CAST(:blobField AS LONGVARBINARY), CAST(:bigIntegerField AS BIGINT), CAST(:clobField AS NCLOB))";
    }

    protected List<String> expectedAutoGenerateIdStatement() {
        return Arrays.asList("DELETE FROM TESTSCHEMA.idvalues where name = 'Test'", "INSERT INTO TESTSCHEMA.idvalues (name, nextvalue) VALUES('Test', (SELECT COALESCE(MAX(id) + 1, 1) AS CurrentValue FROM TESTSCHEMA.Test))", "INSERT INTO TESTSCHEMA.Test (version, stringField, id) SELECT version, stringField, (SELECT COALESCE(nextvalue, 0) FROM TESTSCHEMA.idvalues WHERE (name = CAST('Test' AS VARCHAR(4)))) + Other.id FROM TESTSCHEMA.Other");
    }

    protected List<String> expectedInsertWithIdAndVersion() {
        return Arrays.asList("DELETE FROM TESTSCHEMA.idvalues where name = 'Test'", "INSERT INTO TESTSCHEMA.idvalues (name, nextvalue) VALUES('Test', (SELECT COALESCE(MAX(id) + 1, 1) AS CurrentValue FROM TESTSCHEMA.Test))", "INSERT INTO TESTSCHEMA.Test (stringField, id, version) SELECT stringField, (SELECT COALESCE(nextvalue, 0) FROM TESTSCHEMA.idvalues WHERE (name = CAST('Test' AS VARCHAR(4)))) + Other.id, 0 AS version FROM TESTSCHEMA.Other");
    }

    protected List<String> expectedSpecifiedValueInsert() {
        return Arrays.asList("DELETE FROM TESTSCHEMA.idvalues where name = 'Test'", "INSERT INTO TESTSCHEMA.idvalues (name, nextvalue) VALUES('Test', (SELECT COALESCE(MAX(id) + 1, 1) AS CurrentValue FROM TESTSCHEMA.Test))", "INSERT INTO TESTSCHEMA.Test (stringField, intField, floatField, dateField, booleanField, charField, id, version, blobField, bigIntegerField, clobField) VALUES (CAST('Escap''d' AS VARCHAR(7)), 7, 11.25, 20100405, true, CAST('X' AS VARCHAR(1)), (SELECT COALESCE(nextvalue, 1) FROM TESTSCHEMA.idvalues WHERE (name = CAST('Test' AS VARCHAR(4)))), 0, null, 12345, null)");
    }

    protected List<String> expectedSpecifiedValueInsertWithTableInDifferentSchema() {
        return Arrays.asList("DELETE FROM TESTSCHEMA.idvalues where name = 'Test'", "INSERT INTO TESTSCHEMA.idvalues (name, nextvalue) VALUES('Test', (SELECT COALESCE(MAX(id) + 1, 1) AS CurrentValue FROM MYSCHEMA.Test))", "INSERT INTO MYSCHEMA.Test (stringField, intField, floatField, dateField, booleanField, charField, id, version, blobField, bigIntegerField, clobField) VALUES (CAST('Escap''d' AS VARCHAR(7)), 7, 11.25, 20100405, true, CAST('X' AS VARCHAR(1)), (SELECT COALESCE(nextvalue, 1) FROM TESTSCHEMA.idvalues WHERE (name = CAST('Test' AS VARCHAR(4)))), 0, null, 12345, null)");
    }

    protected String expectedParameterisedInsertStatementWithNoColumnValues() {
        return "INSERT INTO TESTSCHEMA.Test (id, version, stringField, intField, floatField, dateField, booleanField, charField, blobField, bigIntegerField, clobField) VALUES (CAST(:id AS BIGINT), CAST(:version AS INTEGER), CAST(:stringField AS VARCHAR(3)), CAST(:intField AS INTEGER), CAST(:floatField AS DECIMAL(13,2)), CAST(:dateField AS DATE), CAST(:booleanField AS BIT), CAST(:charField AS VARCHAR(1)), CAST(:blobField AS LONGVARBINARY), CAST(:bigIntegerField AS BIGINT), CAST(:clobField AS NCLOB))";
    }

    protected String expectedEmptyStringInsertStatement() {
        return "INSERT INTO TESTSCHEMA.Test (stringField, id, version, intField, floatField, dateField, booleanField, charField, blobField, bigIntegerField, clobField) VALUES (NULL, (SELECT COALESCE(nextvalue, 1) FROM TESTSCHEMA.idvalues WHERE (name = CAST('Test' AS VARCHAR(4)))), 0, 0, 0, null, false, NULL, null, 12345, null)";
    }

    protected String expectedConcatenationWithCase() {
        return "SELECT COALESCE(assetDescriptionLine1,'') || COALESCE(CASE WHEN (taxVariationIndicator = CAST('Y' AS VARCHAR(1))) THEN exposureCustomerNumber ELSE invoicingCustomerNumber END,'') AS test FROM TESTSCHEMA.schedule";
    }

    protected String expectedConcatenationWithFunction() {
        return "SELECT COALESCE(assetDescriptionLine1,'') || COALESCE(MAX(scheduleStartDate),'') AS test FROM TESTSCHEMA.schedule";
    }

    protected String expectedConcatenationWithMultipleFieldLiterals() {
        return "SELECT COALESCE(CAST('ABC' AS VARCHAR(3)),'') || COALESCE(CAST(' ' AS VARCHAR(1)),'') || COALESCE(CAST('DEF' AS VARCHAR(3)),'') AS assetDescription FROM TESTSCHEMA.schedule";
    }

    protected String expectedNestedConcatenations() {
        return "SELECT COALESCE(field1,'') || COALESCE(COALESCE(field2,'') || COALESCE(CAST('XYZ' AS VARCHAR(3)),''),'') AS test FROM TESTSCHEMA.schedule";
    }

    protected String expectedSelectWithConcatenation1() {
        return "SELECT COALESCE(assetDescriptionLine1,'') || COALESCE(CAST(' ' AS VARCHAR(1)),'') || COALESCE(assetDescriptionLine2,'') AS assetDescription FROM TESTSCHEMA.schedule";
    }

    protected String expectedSelectWithConcatenation2() {
        return "SELECT COALESCE(assetDescriptionLine1,'') || COALESCE(CAST('XYZ' AS VARCHAR(3)),'') || COALESCE(assetDescriptionLine2,'') AS assetDescription FROM TESTSCHEMA.schedule";
    }

    protected String expectedIsNull() {
        return "COALESCE(CAST('A' AS VARCHAR(1)), CAST('B' AS VARCHAR(1)))";
    }

    protected String expectedBlobLiteral(String value) {
        return String.format("X'%s'", value);
    }

    protected String expectedMathsPlus() {
        return "1 + 1";
    }

    protected String expectedMathsMinus() {
        return "1 - 1";
    }

    protected String expectedMathsDivide() {
        return "1 / 1";
    }

    protected String expectedMathsMultiply() {
        return "1 * 1";
    }

    protected String expectedStringCast() {
        return "CAST(value AS VARCHAR(10))";
    }

    protected String expectedBigIntCast() {
        return "CAST(value AS BIGINT)";
    }

    protected String expectedBigIntFunctionCast() {
        return "CAST(MIN(value) AS BIGINT)";
    }

    protected String expectedBooleanCast() {
        return "CAST(value AS BIT)";
    }

    protected String expectedBooleanLiteral(boolean value) {
        return value ? "true" : "false";
    }

    protected String expectedDateCast() {
        return "CAST(value AS DATE)";
    }

    protected String expectedDecimalCast() {
        return "CAST(value AS DECIMAL(10,2))";
    }

    protected String expectedIntegerCast() {
        return "CAST(value AS INTEGER)";
    }

    protected String expectedSelectWithUnion() {
        return "SELECT stringField FROM TESTSCHEMA.Other UNION SELECT stringField FROM TESTSCHEMA.Test UNION ALL SELECT stringField FROM TESTSCHEMA.Alternate ORDER BY stringField";
    }

    protected String expectedLeftPad() {
        return "SELECT LPAD(stringField, 10, CAST('j' AS VARCHAR(1))) FROM TESTSCHEMA.Test";
    }

    protected String expectedRightPad() {
        return "SELECT RPAD(stringField, 10, CAST('j' AS VARCHAR(1))) FROM TESTSCHEMA.Test";
    }

    protected List<String> expectedAlterTableAddBlobColumnStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ADD COLUMN blobField_new LONGVARBINARY NULL");
    }

    protected List<String> expectedAlterTableAlterBlobColumnStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ALTER COLUMN blobField SET NOT NULL");
    }

    protected List<String> expectedAlterTableAlterBooleanColumnStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ALTER COLUMN booleanField SET NOT NULL");
    }

    protected List<String> expectedAlterTableAddBooleanColumnStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ADD COLUMN booleanField_new BIT NULL");
    }

    protected List<String> expectedAlterTableAddStringColumnStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ADD COLUMN stringField_new VARCHAR(6) NULL");
    }

    protected List<String> expectedAlterTableAlterStringColumnStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ALTER COLUMN stringField VARCHAR(6)");
    }

    protected List<String> expectedAlterTableAddIntegerColumnStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ADD COLUMN intField_new INTEGER NULL");
    }

    protected List<String> expectedAlterTableAlterIntegerColumnStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ALTER COLUMN intField SET NOT NULL");
    }

    protected List<String> expectedAlterTableAddDateColumnStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ADD COLUMN dateField_new DATE NULL");
    }

    protected List<String> expectedAlterTableAlterDateColumnStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ALTER COLUMN dateField SET NOT NULL");
    }

    protected List<String> expectedAlterTableAddDecimalColumnStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ADD COLUMN floatField_new DECIMAL(6,3) NULL");
    }

    protected List<String> expectedAlterTableAlterDecimalColumnStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ALTER COLUMN floatField SET NULL", "ALTER TABLE TESTSCHEMA.Test ALTER COLUMN floatField DECIMAL(14,3)");
    }

    protected List<String> expectedAlterTableAddBigIntegerColumnStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ADD COLUMN bigIntegerField_new BIGINT NULL");
    }

    protected List<String> expectedAlterTableAlterBigIntegerColumnStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ALTER COLUMN bigIntegerField BIGINT");
    }

    protected List<String> expectedAlterTableAddColumnNotNullableStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ADD COLUMN dateField_new DATE DEFAULT DATE '2010-01-01' NOT NULL");
    }

    protected List<String> expectedAlterTableAlterColumnFromNullableToNotNullableStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ALTER COLUMN dateField SET NOT NULL");
    }

    protected List<String> expectedAlterTableAlterColumnFromNotNullableToNotNullableStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ALTER COLUMN floatField DECIMAL(20,3)");
    }

    protected List<String> expectedAlterTableDropColumnWithDefaultStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test DROP COLUMN bigIntegerField");
    }

    protected List<String> expectedAlterTableAlterColumnFromNotNullableToNullableStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ALTER COLUMN floatField SET NULL", "ALTER TABLE TESTSCHEMA.Test ALTER COLUMN floatField DECIMAL(20,3)");
    }

    protected List<String> expectedAlterTableAddColumnWithDefaultStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ADD COLUMN floatField_new DECIMAL(6,3) DEFAULT 20.33 NULL");
    }

    protected List<String> expectedAlterTableAlterColumnWithDefaultStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ALTER COLUMN bigIntegerField SET DEFAULT 54321", "ALTER TABLE TESTSCHEMA.Test ALTER COLUMN bigIntegerField BIGINT");
    }

    protected List<String> expectedChangeIndexFollowedByChangeOfAssociatedColumnStatement() {
        return Arrays.asList("DROP INDEX Test_1", "CREATE INDEX Test_1 ON TESTSCHEMA.Test (intField)", "ALTER TABLE TESTSCHEMA.Test ALTER COLUMN intField SET NOT NULL");
    }

    protected List<String> expectedAddIndexStatementsOnSingleColumn() {
        return Arrays.asList("CREATE INDEX indexName ON TESTSCHEMA.Test (id)");
    }

    protected List<String> expectedAddIndexStatementsOnMultipleColumns() {
        return Arrays.asList("CREATE INDEX indexName ON TESTSCHEMA.Test (id,version)");
    }

    protected List<String> expectedAddIndexStatementsUnique() {
        return Arrays.asList("CREATE UNIQUE INDEX indexName ON TESTSCHEMA.Test (id)");
    }

    protected List<String> expectedAddIndexStatementsUniqueNullable() {
        return Arrays.asList("CREATE UNIQUE INDEX indexName ON TESTSCHEMA.Test (stringField,intField,floatField,dateField)");
    }

    protected List<String> expectedIndexDropStatements() {
        return Arrays.asList("DROP INDEX indexName");
    }

    protected List<String> expectedAlterColumnMakePrimaryStatements() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ADD CONSTRAINT Test_PK PRIMARY KEY (id, dateField)");
    }

    protected List<String> expectedAlterPrimaryKeyColumnCompositeKeyStatements() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.CompositePrimaryKey ALTER COLUMN secondPrimaryKey VARCHAR(5)");
    }

    protected List<String> expectedAlterRemoveColumnFromCompositeKeyStatements() {
        return ImmutableList.of((Object)"ALTER TABLE TESTSCHEMA.CompositePrimaryKey DROP PRIMARY KEY", (Object)"ALTER TABLE TESTSCHEMA.CompositePrimaryKey ALTER COLUMN secondPrimaryKey SET NULL", (Object)"ALTER TABLE TESTSCHEMA.CompositePrimaryKey ALTER COLUMN secondPrimaryKey VARCHAR(5)", (Object)"ALTER TABLE TESTSCHEMA.CompositePrimaryKey ADD CONSTRAINT CompositePrimaryKey_PK PRIMARY KEY (id)");
    }

    protected List<String> expectedAlterPrimaryKeyColumnStatements() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ALTER COLUMN id RENAME TO renamedId");
    }

    protected List<String> expectedAlterColumnRenameNonPrimaryIndexedColumn() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Alternate ALTER COLUMN stringField RENAME TO blahField");
    }

    protected List<String> expectedAlterColumnRenamingAndChangingNullability() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Other ALTER COLUMN floatField RENAME TO blahField", "ALTER TABLE TESTSCHEMA.Other ALTER COLUMN blahField SET NULL", "ALTER TABLE TESTSCHEMA.Other ALTER COLUMN blahField DECIMAL(20,3)");
    }

    protected List<String> expectedAlterColumnChangingLengthAndCase() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Other ALTER COLUMN floatField RENAME TO FloatField", "ALTER TABLE TESTSCHEMA.Other ALTER COLUMN FloatField DECIMAL(20,3)");
    }

    protected String varCharCast(String value) {
        return String.format("CAST(%s AS VARCHAR(%d))", value, StringUtils.replace((String)value, (String)"'", (String)"").length());
    }

    protected List<String> expectedAlterTableAddStringColumnWithDefaultStatement() {
        return Arrays.asList("ALTER TABLE TESTSCHEMA.Test ADD COLUMN stringField_with_default VARCHAR(6) DEFAULT CAST('N' AS VARCHAR(1)) NOT NULL");
    }

    protected List<String> expectedAutonumberUpdate() {
        return Arrays.asList("MERGE INTO TESTSCHEMA.Autonumber (id, value) SELECT 'TestTable', (SELECT GREATEST((SELECT COALESCE(MAX(id) + 1, 1)  AS CurrentValue FROM TESTSCHEMA.TestTable), (SELECT value from Autonumber WHERE name='TestTable'), 1))");
    }

    protected String expectedUpdateWithSelectMinimum() {
        String value1 = this.varCharCast("'S'");
        String value2 = this.varCharCast("'Y'");
        return "UPDATE " + this.tableName("Other") + " O SET intField = (SELECT MIN(intField) FROM " + this.tableName("Test") + " T WHERE ((T.charField = " + this.stringLiteralPrefix() + value1 + ") AND (T.stringField = O.stringField) AND (T.intField = O.intField))) WHERE (stringField = " + this.stringLiteralPrefix() + value2 + ")";
    }

    protected String expectedUpdateUsingAliasedDestinationTable() {
        return "UPDATE " + this.tableName("FloatingRateRate") + " A SET settlementFrequency = (SELECT settlementFrequency FROM " + this.tableName("FloatingRateDetail") + " B WHERE (A.floatingRateDetailId = B.id))";
    }

    protected List<String> expectedCreateViewStatements() {
        return Arrays.asList("CREATE VIEW " + this.tableName("TestView") + " AS (SELECT stringField FROM " + this.tableName("Test") + " WHERE (stringField = " + this.varCharCast("'blah'") + "))");
    }

    protected List<String> expectedCreateSequenceStatements() {
        return Arrays.asList("CREATE SEQUENCE " + this.tableName("TestSequence") + " START WITH 1");
    }

    protected List<String> expectedCreateTemporarySequenceStatements() {
        return Arrays.asList("CREATE SEQUENCE " + this.tableName("TestSequence") + " START WITH 1");
    }

    protected List<String> expectedCreateSequenceStatementsWithNoStartWith() {
        return Arrays.asList("CREATE SEQUENCE " + this.tableName("TestSequence"));
    }

    protected List<String> expectedCreateTemporarySequenceStatementsWithNoStartWith() {
        return Arrays.asList("CREATE SEQUENCE " + this.tableName("TestSequence"));
    }

    protected String expectedYYYYMMDDToDate() {
        return "CAST(SUBSTRING(CAST('20100101' AS VARCHAR(8)), 1, 4)||'-'||SUBSTRING(CAST('20100101' AS VARCHAR(8)), 5, 2)||'-'||SUBSTRING(CAST('20100101' AS VARCHAR(8)), 7, 2) AS DATE)";
    }

    protected String expectedDateToYyyymmdd() {
        return "CAST(SUBSTRING(testField, 1, 4)||SUBSTRING(testField, 6, 2)||SUBSTRING(testField, 9, 2) AS DECIMAL(8))";
    }

    protected String expectedDateToYyyymmddHHmmss() {
        return "CAST(SUBSTRING(testField, 1, 4)||SUBSTRING(testField, 6, 2)||SUBSTRING(testField, 9, 2)||SUBSTRING(testField, 12, 2)||SUBSTRING(testField, 15, 2)||SUBSTRING(testField, 18, 2) AS DECIMAL(14))";
    }

    protected String expectedClobLiteralCast() {
        return "CAST('CREATE VIEW viewName AS (SELECT tableField1, tableField2, tableField3, tableField4, tableField5, tableField6, tableField7, tableField8, tableField9, tableField10, tableField11, tableField12, tableField13, tableField14, tableField15, tableField16, tableField17, tableField18, tableField19, tableField20, tableField21, tableField22, tableField23, tableField24, tableField25, tableField26, tableField27, tableField28, tableField29, tableField30 FROM table INNER JOIN table2 ON (table1.tableField1 = table2 = tableField1));' AS VARCHAR(519))";
    }

    protected String expectedNow() {
        return "CURRENT_TIMESTAMP()";
    }

    protected List<String> expectedDropViewStatements() {
        return Arrays.asList("DROP VIEW " + this.tableName("TestView") + " IF EXISTS CASCADE");
    }

    protected String expectedStringLiteralToIntegerCast() {
        return "CAST(" + this.varCharCast("'1234567890'") + " AS INTEGER)";
    }

    protected String expectedSubstring() {
        return "SELECT SUBSTRING(field1, 1, 3) FROM " + this.tableName("schedule");
    }

    protected List<String> expectedAutonumberUpdateForNonIdColumn() {
        return Arrays.asList("MERGE INTO TESTSCHEMA.Autonumber (id, value) SELECT 'TestTable', (SELECT GREATEST((SELECT COALESCE(MAX(generatedColumn) + 1, 1)  AS CurrentValue FROM TestTable), (SELECT value from Autonumber WHERE name='TestTable'), 1))");
    }

    protected String expectedStringFunctionCast() {
        return "CAST(MIN(field) AS VARCHAR(8))";
    }

    protected String expectedDaysBetween() {
        return "SELECT DATEDIFF('DAY',dateOne, dateTwo) FROM TESTSCHEMA.MyTable";
    }

    protected String expectedMergeSimple() {
        return "MERGE INTO TESTSCHEMA.foo USING (SELECT somewhere.newId AS id, somewhere.newBar AS bar FROM TESTSCHEMA.somewhere) xmergesource ON (foo.id = xmergesource.id) WHEN MATCHED THEN UPDATE SET bar = xmergesource.bar WHEN NOT MATCHED THEN INSERT (id, bar) VALUES (xmergesource.id, xmergesource.bar)";
    }

    protected String expectedMergeComplex() {
        return "MERGE INTO TESTSCHEMA.foo USING (SELECT somewhere.newId AS id, join.joinBar AS bar FROM TESTSCHEMA.somewhere INNER JOIN TESTSCHEMA.join ON (somewhere.newId = join.joinId)) xmergesource ON (foo.id = xmergesource.id) WHEN MATCHED THEN UPDATE SET bar = xmergesource.bar WHEN NOT MATCHED THEN INSERT (id, bar) VALUES (xmergesource.id, xmergesource.bar)";
    }

    protected String expectedMergeSourceInDifferentSchema() {
        return "MERGE INTO TESTSCHEMA.foo USING (SELECT somewhere.newId AS id, somewhere.newBar AS bar FROM MYSCHEMA.somewhere) xmergesource ON (foo.id = xmergesource.id) WHEN MATCHED THEN UPDATE SET bar = xmergesource.bar WHEN NOT MATCHED THEN INSERT (id, bar) VALUES (xmergesource.id, xmergesource.bar)";
    }

    protected String expectedMergeTargetInDifferentSchema() {
        return "MERGE INTO MYSCHEMA.foo USING (SELECT somewhere.newId AS id, somewhere.newBar AS bar FROM TESTSCHEMA.somewhere) xmergesource ON (foo.id = xmergesource.id) WHEN MATCHED THEN UPDATE SET bar = xmergesource.bar WHEN NOT MATCHED THEN INSERT (id, bar) VALUES (xmergesource.id, xmergesource.bar)";
    }

    protected String expectedMergeForAllPrimaryKeys() {
        return "MERGE INTO TESTSCHEMA.foo USING (SELECT somewhere.newId AS id FROM TESTSCHEMA.somewhere) xmergesource ON (foo.id = xmergesource.id) WHEN NOT MATCHED THEN INSERT (id) VALUES (xmergesource.id)";
    }

    protected String expectedMergeWithUpdateExpressions() {
        return "MERGE INTO TESTSCHEMA.foo USING (SELECT somewhere.newId AS id, somewhere.newBar AS bar FROM TESTSCHEMA.somewhere) xmergesource ON (foo.id = xmergesource.id) WHEN MATCHED THEN UPDATE SET bar = xmergesource.bar + foo.bar WHEN NOT MATCHED THEN INSERT (id, bar) VALUES (xmergesource.id, xmergesource.bar)";
    }

    protected String expectedAddDays() {
        return "DATEADD('DAY', -20, testField)";
    }

    protected String expectedAddMonths() {
        return "DATEADD('MONTH', -3, testField)";
    }

    protected List<String> expectedAlterRemoveColumnFromSimpleKeyStatements() {
        return Collections.singletonList("ALTER TABLE TESTSCHEMA.Test DROP COLUMN id");
    }

    protected List<String> expectedRenameTableStatements() {
        return ImmutableList.of((Object)"ALTER TABLE TESTSCHEMA.Test DROP PRIMARY KEY", (Object)"ALTER TABLE TESTSCHEMA.Test RENAME TO Renamed", (Object)"ALTER TABLE TESTSCHEMA.Renamed ADD CONSTRAINT Renamed_PK PRIMARY KEY (id)");
    }

    protected List<String> getRenamingTableWithLongNameStatements() {
        return ImmutableList.of((Object)"ALTER TABLE TESTSCHEMA.123456789012345678901234567890X DROP PRIMARY KEY", (Object)"ALTER TABLE TESTSCHEMA.123456789012345678901234567890X RENAME TO Blah", (Object)"ALTER TABLE TESTSCHEMA.Blah ADD CONSTRAINT Blah_PK PRIMARY KEY (id)");
    }

    protected List<String> expectedRenameIndexStatements() {
        return ImmutableList.of((Object)"ALTER INDEX TESTSCHEMA.Test_1 RENAME TO Test_2");
    }

    protected List<String> expectedRenameTempIndexStatements() {
        return ImmutableList.of((Object)"ALTER INDEX TESTSCHEMA.TempTest_1 RENAME TO TempTest_2");
    }

    protected String expectedRandomString() {
        return "SUBSTRING(REPLACE(RANDOM_UUID(),'-'), 1, 10)";
    }

    protected String expectedSelectLiteralWithWhereClauseString() {
        return "SELECT CAST('LITERAL' AS VARCHAR(7)) FROM dual WHERE (CAST('ONE' AS VARCHAR(3)) = CAST('ONE' AS VARCHAR(3)))";
    }

    protected List<String> expectedAddTableFromStatements() {
        return ImmutableList.of((Object)"CREATE TABLE TESTSCHEMA.SomeTable (someField VARCHAR(3) NOT NULL, otherField DECIMAL(3,0) NOT NULL, CONSTRAINT SomeTable_PK PRIMARY KEY (someField))", (Object)"CREATE INDEX SomeTable_1 ON TESTSCHEMA.SomeTable (otherField)", (Object)"INSERT INTO TESTSCHEMA.SomeTable SELECT someField, otherField FROM TESTSCHEMA.OtherTable");
    }

    protected List<String> expectedReplaceTableFromStatements() {
        return ImmutableList.of((Object)"CREATE TABLE TESTSCHEMA.tmp_SomeTable (someField VARCHAR(3) NOT NULL, otherField DECIMAL(3,0) NOT NULL, thirdField DECIMAL(5,0) NOT NULL, CONSTRAINT tmp_SomeTable_PK PRIMARY KEY (someField))", (Object)"INSERT INTO TESTSCHEMA.tmp_SomeTable SELECT someField, otherField, CAST(thirdField AS DECIMAL(5,0)) AS thirdField FROM TESTSCHEMA.OtherTable", (Object)"DROP TABLE TESTSCHEMA.SomeTable CASCADE", (Object)"ALTER TABLE TESTSCHEMA.tmp_SomeTable DROP PRIMARY KEY", (Object)"ALTER TABLE TESTSCHEMA.tmp_SomeTable RENAME TO SomeTable", (Object)"ALTER TABLE TESTSCHEMA.SomeTable ADD CONSTRAINT SomeTable_PK PRIMARY KEY (someField)", (Object)"CREATE INDEX SomeTable_1 ON TESTSCHEMA.SomeTable (otherField)");
    }

    protected List<String> expectedReplaceTableWithAutonumber() {
        return ImmutableList.of((Object)"CREATE TABLE TESTSCHEMA.tmp_SomeTable (someField VARCHAR(3) NOT NULL, otherField DECIMAL(3,0) AUTO_INCREMENT(1) COMMENT 'AUTONUMSTART:[1]', thirdField DECIMAL(5,0) NOT NULL, CONSTRAINT tmp_SomeTable_PK PRIMARY KEY (someField))", (Object)"INSERT INTO TESTSCHEMA.tmp_SomeTable SELECT someField, otherField, CAST(thirdField AS DECIMAL(5,0)) AS thirdField FROM TESTSCHEMA.OtherTable", (Object)"DROP TABLE TESTSCHEMA.SomeTable CASCADE", (Object)"ALTER TABLE TESTSCHEMA.tmp_SomeTable DROP PRIMARY KEY", (Object)"ALTER TABLE TESTSCHEMA.tmp_SomeTable RENAME TO SomeTable", (Object)"ALTER TABLE TESTSCHEMA.SomeTable ADD CONSTRAINT SomeTable_PK PRIMARY KEY (someField)", (Object)"CREATE INDEX SomeTable_1 ON TESTSCHEMA.SomeTable (otherField)");
    }

    protected String expectedHints1(int rowCount) {
        return "SELECT * FROM SCHEMA2.Foo INNER JOIN TESTSCHEMA.Bar ON (a = b) LEFT OUTER JOIN TESTSCHEMA.Fo ON (a = b) INNER JOIN TESTSCHEMA.Fum Fumble ON (a = b) ORDER BY a";
    }

    protected Collection<String> expectedAnalyseTableSql() {
        return SqlDialect.NO_STATEMENTS;
    }

    protected String expectedDeleteWithLimitAndWhere(String value) {
        return "DELETE FROM " + this.tableName("Test") + " WHERE (Test.stringField = " + this.stringLiteralPrefix() + value + ") LIMIT 1000";
    }

    protected String expectedDeleteWithLimitAndComplexWhere(String value1, String value2) {
        return "DELETE FROM " + this.tableName("Test") + " WHERE ((Test.stringField = " + this.stringLiteralPrefix() + value1 + ") OR (Test.stringField = " + this.stringLiteralPrefix() + value2 + ")) LIMIT 1000";
    }

    protected String expectedDeleteWithLimitWithoutWhere() {
        return "DELETE FROM " + this.tableName("Test") + " LIMIT 1000";
    }

    protected String expectedRowNumber() {
        return "ROW_NUMBER() OVER()";
    }

    protected String tableName(String baseName) {
        return "TESTSCHEMA." + baseName;
    }

    protected List<String> expectedCreateViewOverUnionSelectStatements() {
        return Arrays.asList("CREATE VIEW " + this.tableName("TestView") + " AS (SELECT stringField FROM " + this.tableName("Test") + " WHERE (stringField = " + this.stringLiteralPrefix() + "CAST('blah' AS VARCHAR(4))) UNION ALL SELECT stringField FROM " + this.tableName("Other") + " WHERE (stringField = " + this.stringLiteralPrefix() + "CAST('blah' AS VARCHAR(4))))");
    }

    protected String expectedSelectWithExcept() {
        return null;
    }

    protected String expectedSelectWithDbLink() {
        return null;
    }

    protected String expectedSelectWithExceptAndDbLinkFormer() {
        return null;
    }

    protected String expectedSelectWithExceptAndDbLinkLatter() {
        return null;
    }

    protected String expectedNextValForSequence() {
        return "SELECT NEXT VALUE FOR TestSequence FROM dual";
    }

    protected String expectedCurrValForSequence() {
        return "SELECT CURRENT VALUE FOR TestSequence FROM dual";
    }

    protected String expectedPortableStatement() {
        return "UPDATE TESTSCHEMA.Table SET field = BTRIM(field, CAST('2' AS VARCHAR(1)), CAST('B' AS VARCHAR(1)))";
    }

    protected boolean expectedForceSerialImport() {
        return true;
    }
}

